/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

import java.io.IOException;
import java.io.Reader;
import org.xml.sax.InputSource;
import weblogic.utils.UnsyncCircularQueue;
import weblogic.xml.babel.baseparser.BaseEntityResolver;
import weblogic.xml.babel.dtd.EntityTable;
import weblogic.xml.babel.reader.XmlChars;
import weblogic.xml.babel.scanner.IntegerQueue;
import weblogic.xml.babel.scanner.PEReference;
import weblogic.xml.babel.scanner.Scanner;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.Token;
import weblogic.xml.babel.scanner.TokenFactory;

public final class ScannerState {
    private Reader input;
    private UnsyncCircularQueue tokenQ;
    private IntegerQueue lineQ;
    private IntegerQueue columnQ;
    private boolean reachedEOF;
    private boolean checkedRead = true;
    private char[] inputBuffer;
    private int inputBufferPosition;
    private int inputBufferSize;
    private static int MAXBUFSIZE = 16384;
    private static int bufSize = 1024;
    static final int initialBufSize = 1024;
    private int numAlloc = 1;
    private PEReference perReference;
    private int mark;
    private boolean markSet;
    private int insertionPoint;
    private boolean insertionPointSet;
    private int tokenState;
    private boolean tokenStateSet;
    TokenFactory tokenFactory = new TokenFactory();
    char currentChar;
    char lookAhead;
    int currentLine;
    int currentColumn;
    Token currentToken;
    BaseEntityResolver entityResolver;
    EntityTable parameterEntityTable;
    EntityTable internalEntityTable;
    EntityTable externalEntityTable;

    public ScannerState(Reader reader) throws IOException, ScannerException {
        this.tokenQ = new UnsyncCircularQueue();
        this.lineQ = new IntegerQueue();
        this.columnQ = new IntegerQueue();
        this.perReference = new PEReference(this);
        this.parameterEntityTable = new EntityTable();
        this.internalEntityTable = new EntityTable();
        this.externalEntityTable = new EntityTable();
        this.lineQ.add(0);
        this.columnQ.add(0);
        this.input = reader;
        this.currentLine = 1;
        this.currentColumn = 1;
        this.reachedEOF = false;
        this.inputBufferPosition = 0;
        this.inputBufferSize = 0;
        this.inputBuffer = new char[bufSize];
        this.read();
        this.mark = 0;
        this.markSet = false;
        this.tokenStateSet = false;
        this.insertionPoint = 0;
        this.insertionPointSet = false;
    }

    public void clear() {
        this.lineQ.clear();
        this.columnQ.clear();
        this.lineQ.add(0);
        this.columnQ.add(0);
        this.tokenFactory.init();
        if (this.inputBuffer.length > MAXBUFSIZE) {
            this.inputBuffer = new char[1024];
        }
    }

    public ScannerState recycle(Reader reader) throws IOException, ScannerException {
        this.tokenQ = new UnsyncCircularQueue();
        this.clear();
        this.input = reader;
        this.currentLine = 1;
        this.currentColumn = 1;
        this.reachedEOF = false;
        this.inputBufferPosition = 0;
        this.inputBufferSize = 0;
        this.read();
        this.mark = 0;
        this.markSet = false;
        this.tokenStateSet = false;
        this.numAlloc = 1;
        this.insertionPoint = 0;
        this.insertionPointSet = false;
        return this;
    }

    public Scanner createScanner(InputSource inputSource) throws IOException, ScannerException {
        Scanner scanner = Scanner.createScanner(inputSource);
        scanner.init(this);
        return scanner;
    }

    Token returnToken() {
        if (this.tokenQ.size() == 0) {
            return this.currentToken;
        }
        this.lineQ.remove();
        this.columnQ.remove();
        return (Token)this.tokenQ.get();
    }

    final void setToken(Token token) {
        if (this.tokenQ.size() > 0) {
            this.pushToken(token);
        } else {
            this.currentToken = token;
        }
    }

    final void pushToken(Token token) {
        this.tokenQ.put(token);
        this.lineQ.add(this.currentLine);
        this.columnQ.add(this.currentColumn);
        this.currentToken = token;
    }

    final boolean hasQueuedTokens() {
        return this.tokenQ.size() > 0;
    }

    final int currentIndex() {
        return this.tokenQ.size() - 1;
    }

    final void assign(int n, Token token) {
        for (int i = 0; i < this.tokenQ.size(); ++i) {
            Token token2 = (Token)this.tokenQ.get();
            if (i == n) {
                this.tokenQ.put(token);
                continue;
            }
            this.tokenQ.put(token2);
        }
    }

    final boolean hasReachedEOF() {
        return this.reachedEOF;
    }

    final boolean expect(String string) throws IOException, ScannerException {
        int n;
        for (n = 0; n < string.length(); ++n) {
            this.expect(string.charAt(n));
        }
        if (n == string.length()) {
            return true;
        }
        throw new ScannerException(" '" + string + "' expected, got char[" + this.currentChar + "] ", this);
    }

    final boolean expect(char c) throws IOException, ScannerException {
        if (this.currentChar == c) {
            this.read();
            return true;
        }
        throw new ScannerException("Line:" + this.currentLine + " '" + c + "' expected, got char[" + this.currentChar + "]", this);
    }

    final boolean expect(char c, String string) throws IOException, ScannerException {
        if (this.currentChar == c) {
            this.read();
            return true;
        }
        throw new ScannerException("Line:" + this.currentLine + " A '" + c + "' was expected, " + string);
    }

    final void insertData(char[] cArray) throws IOException, ScannerException {
        int n;
        if (!this.insertionPointSet) {
            throw new ScannerException("Attempt to rewrite data buffer without setting the insertion point");
        }
        this.insertionPointSet = false;
        char[] cArray2 = new char[this.inputBuffer.length + cArray.length];
        for (n = 0; n < this.insertionPoint; ++n) {
            cArray2[n] = this.inputBuffer[n];
        }
        for (n = 0; n < cArray.length; ++n) {
            cArray2[this.insertionPoint + n] = cArray[n];
        }
        for (n = 0; n < this.inputBuffer.length - this.insertionPoint; ++n) {
            cArray2[this.insertionPoint + cArray.length + n] = this.inputBuffer[this.insertionPoint + n];
        }
        this.inputBuffer = cArray2;
        this.inputBufferSize += cArray.length;
        this.currentChar = this.inputBuffer[this.insertionPoint];
        this.inputBufferPosition = this.insertionPoint + 1;
    }

    final char[] addToBuffer(char[] cArray, int n) {
        char[] cArray2 = new char[cArray.length + n];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        return cArray2;
    }

    private final void set(char c) {
        this.inputBuffer[this.inputBufferPosition] = c;
    }

    private final void set(int n, char c) {
        this.inputBuffer[n] = c;
    }

    final void deleteFromLastInsertionPoint() {
        int n = this.inputBufferPosition - 1 - this.insertionPoint;
        this.deleteFromLastInsertionPoint(n);
    }

    final void deleteFromLastInsertionPoint(int n) {
        if (this.insertionPointSet) {
            for (int i = this.insertionPoint; i < this.inputBufferSize - n; ++i) {
                this.inputBuffer[i] = this.inputBuffer[i + n];
            }
            this.inputBufferSize -= n;
            this.inputBufferPosition -= n;
        }
    }

    private final void delete(int n) {
        for (int i = n; i < this.inputBufferSize - 1; ++i) {
            this.inputBuffer[i] = this.inputBuffer[i + 1];
        }
        --this.inputBufferSize;
    }

    final void read() throws IOException, ScannerException {
        try {
            if (this.inputBufferPosition == this.inputBufferSize && !this.reachedEOF) {
                int n = 0;
                int n2 = 512;
                int n3 = 256;
                if (this.markSet || this.hasQueuedTokens()) {
                    try {
                        if (this.inputBufferSize + n3 >= bufSize || this.inputBufferSize + n3 >= this.inputBuffer.length) {
                            this.inputBuffer = this.addToBuffer(this.inputBuffer, this.inputBuffer.length / 2 + this.numAlloc * n3);
                            bufSize = this.inputBuffer.length;
                            ++this.numAlloc;
                        }
                        n = this.input.read(this.inputBuffer, this.inputBufferSize, n3);
                        this.inputBufferSize += n;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        System.out.println("amount read:" + n + "inputBufferSize" + this.inputBufferSize + "overflow" + n3);
                    }
                } else {
                    this.inputBufferSize = n = this.input.read(this.inputBuffer, 0, n2);
                    this.inputBufferPosition = 0;
                    this.numAlloc = 1;
                }
                if (n == -1) {
                    this.reachedEOF = true;
                }
            }
            this.currentChar = this.inputBuffer[this.inputBufferPosition];
            ++this.inputBufferPosition;
            ++this.currentColumn;
            if (this.currentChar == '\n') {
                this.currentColumn = 1;
                ++this.currentLine;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ScannerException("Unterminated element", this);
        }
    }

    final void skipSpace() throws IOException, ScannerException {
        while (XmlChars.isSpace(this.currentChar)) {
            this.read();
        }
    }

    final void skipDTDSpace() throws IOException, ScannerException {
        this.skipSpace();
        while (this.currentChar == '%') {
            this.perReference.read();
        }
        this.skipSpace();
    }

    final void markInsert() {
        this.insertionPoint = this.inputBufferPosition - 1;
        this.insertionPointSet = true;
    }

    final void unMarkInsert() {
        this.insertionPoint = 0;
        this.insertionPointSet = false;
    }

    final void mark() {
        this.mark = this.inputBufferPosition - 1;
        if (this.mark < 0) {
            this.mark = 0;
        }
        this.markSet = true;
    }

    void unMark() {
        this.markSet = false;
    }

    final String getString(int n) {
        this.markSet = false;
        if (n > 0) {
            return new String(this.inputBuffer, this.mark, n);
        }
        return null;
    }

    final String getInputBuffer(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            return null;
        }
        if (n + n2 > this.inputBufferSize) {
            n2 = this.inputBufferSize - n;
        }
        if (n2 < 0) {
            return null;
        }
        return new String(this.inputBuffer, n, n2);
    }

    final String getInputBufferContext(int n) {
        String string = this.getInputBuffer(this.inputBufferPosition - n, n);
        string = "{" + string + "} <-- bad character";
        string = string + ", currentChar is {" + this.currentChar + "}";
        return string;
    }

    final Token createToken(int n, int n2) {
        if (n2 > 0 && this.markSet) {
            return this.tokenFactory.createToken(n, this.inputBuffer, this.mark, n2);
        }
        return this.tokenFactory.createToken(n);
    }

    final Token createStoredToken(int n, int n2) {
        if (n2 > 0 && this.markSet) {
            this.markSet = false;
            return this.tokenFactory.createStoredToken(n, this.inputBuffer, this.mark, n2);
        }
        return this.tokenFactory.createToken(n);
    }

    final int getLine() {
        return this.lineQ.get();
    }

    final int getColumn() {
        return this.columnQ.get();
    }

    final boolean isEOL(char c) {
        return c == '\r' || c == '\n' || c == '\t';
    }

    public final boolean checkSize(int n) {
        return n >= 1024;
    }

    final void setState(int n) {
        this.tokenStateSet = true;
        this.tokenState = n;
    }

    final int getState() {
        this.tokenStateSet = false;
        return this.tokenState;
    }

    final boolean isStateSet() {
        return this.tokenStateSet;
    }

    public final void printTokenStack() {
        if (this.hasQueuedTokens()) {
            System.out.println("Scanner has tokens:");
        } else {
            System.out.println("Scanner has no tokens:");
        }
        while (this.hasQueuedTokens()) {
            System.out.println("\t" + this.returnToken());
        }
    }

    public void setBaseEntityResolver(BaseEntityResolver baseEntityResolver) {
        this.entityResolver = baseEntityResolver;
    }

    public BaseEntityResolver getBaseEntityResolver() {
        return this.entityResolver;
    }

    public void setParameterEntityTable(EntityTable entityTable) {
        this.parameterEntityTable = entityTable;
    }

    public void setExternalEntityTable(EntityTable entityTable) {
        this.externalEntityTable = entityTable;
    }

    public void setInternalEntityTable(EntityTable entityTable) {
        this.internalEntityTable = entityTable;
    }

    public EntityTable getParameterEntityTable() {
        return this.parameterEntityTable;
    }

    public EntityTable getInternalEntityTable() {
        return this.internalEntityTable;
    }

    public EntityTable getExternalEntityTable() {
        return this.externalEntityTable;
    }

    public final void checkedRead() throws IOException, ScannerException {
        if (this.checkedRead && !XmlChars.isChar(this.currentChar)) {
            throw new ScannerException(" Got character[" + this.currentChar + "] expected a valid XML character", this);
        }
        this.read();
    }
}

