/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import org.xml.sax.InputSource;
import weblogic.xml.babel.baseparser.BaseEntityResolver;
import weblogic.xml.babel.reader.XmlReader;
import weblogic.xml.babel.scanner.CData;
import weblogic.xml.babel.scanner.CharData;
import weblogic.xml.babel.scanner.CloseTag;
import weblogic.xml.babel.scanner.Comment;
import weblogic.xml.babel.scanner.DTDHandler;
import weblogic.xml.babel.scanner.DTDProcessor;
import weblogic.xml.babel.scanner.DTDScanner;
import weblogic.xml.babel.scanner.Name;
import weblogic.xml.babel.scanner.OpenTag;
import weblogic.xml.babel.scanner.ProcessingInstruction;
import weblogic.xml.babel.scanner.Reference;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.ScannerState;
import weblogic.xml.babel.scanner.Space;
import weblogic.xml.babel.scanner.Token;

public final class Scanner {
    private ScannerState state;
    private OpenTag openTag;
    private CloseTag closeTag;
    private Comment comment;
    private ProcessingInstruction processingInstruction;
    private CData cData;
    private CharData datachar;
    private Reference reference;
    private Name name;
    private Space space;
    private DTDProcessor dtdScanner;
    private int readAhead;
    private BaseEntityResolver entityResolver;
    static final boolean debug = false;
    static final boolean verbose = false;

    public Scanner(Reader reader) throws IOException, ScannerException {
        this.state = new ScannerState(reader);
        this.openTag = new OpenTag(this.state);
        this.closeTag = new CloseTag(this.state);
        this.comment = new Comment(this.state, false);
        this.processingInstruction = new ProcessingInstruction(this.state);
        this.cData = new CData(this.state);
        this.datachar = new CharData(this.state, "&<\t\n\r");
        this.reference = new Reference(this.state);
        this.name = new Name(this.state);
        this.space = new Space(this.state);
        this.dtdScanner = new DTDHandler(this.state);
        this.readAhead = 10;
    }

    public Scanner recycle(Reader reader) throws IOException, ScannerException {
        this.clear();
        this.state = this.state.recycle(reader);
        return this;
    }

    public void clear() {
        this.state.clear();
        this.space.init();
    }

    public static Scanner createScanner(InputSource inputSource) throws IOException, ScannerException {
        if (inputSource.getCharacterStream() != null) {
            return new Scanner(inputSource.getCharacterStream());
        }
        if (inputSource.getByteStream() != null) {
            return new Scanner(XmlReader.createReader(inputSource.getByteStream()));
        }
        if (inputSource.getSystemId() != null) {
            URL uRL = new URL(inputSource.getSystemId());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            return new Scanner(XmlReader.createReader(bufferedInputStream));
        }
        throw new ScannerException("Unable to resolve input source.");
    }

    public void setEntityResolver(BaseEntityResolver baseEntityResolver) {
        this.entityResolver = baseEntityResolver;
        this.state.setBaseEntityResolver(baseEntityResolver);
    }

    public void init(ScannerState scannerState) {
        this.state.setBaseEntityResolver(scannerState.getBaseEntityResolver());
        this.state.setParameterEntityTable(scannerState.getParameterEntityTable());
        this.state.setInternalEntityTable(scannerState.getInternalEntityTable());
        this.state.setExternalEntityTable(scannerState.getExternalEntityTable());
    }

    public BaseEntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public ScannerState getState() {
        return this.state;
    }

    public void setReadDTD() throws IOException, ScannerException {
        this.dtdScanner = new DTDScanner(this.state);
    }

    public void setExternalDTD(boolean bl) {
        this.dtdScanner.setExternalDTD(bl);
        this.state.setState(24);
    }

    public void setSkipDTD() throws IOException, ScannerException {
        this.dtdScanner = new DTDHandler(this.state);
    }

    public final Token scan() throws IOException, ScannerException {
        if (this.state.hasQueuedTokens()) {
            return this.state.returnToken();
        }
        for (int i = 0; i < this.readAhead; ++i) {
            if (this.state.hasReachedEOF()) {
                this.state.setToken(this.state.tokenFactory.createEOF());
                return this.state.returnToken();
            }
            this.startState();
            if (this.state.currentToken != null && this.state.currentToken.isEODTD()) break;
        }
        return this.state.returnToken();
    }

    public final int getLine() {
        return this.state.getLine();
    }

    public final int getColumn() {
        return this.state.getColumn();
    }

    public final void printTokenStack() {
        this.state.printTokenStack();
    }

    public final void setReadAhead(int n) {
        this.readAhead = n;
    }

    public final int getReadAhead() {
        return this.readAhead;
    }

    private final void startState() throws IOException, ScannerException {
        if (this.state.isStateSet()) {
            int n = this.state.getState();
            switch (n) {
                case 11: {
                    this.cData.read(false);
                    return;
                }
                case 24: {
                    this.dtdScanner.read();
                    return;
                }
            }
        } else {
            switch (this.state.currentChar) {
                case '<': {
                    this.state.read();
                    if (Name.isNameBegin(this.state.currentChar)) {
                        this.openTag.read();
                        break;
                    }
                    if (this.state.currentChar == '/') {
                        this.state.read();
                        this.closeTag.read();
                        break;
                    }
                    if (this.state.currentChar == '!') {
                        this.state.read();
                        if (this.state.currentChar == '-') {
                            this.state.read();
                            this.state.expect('-');
                            this.comment.read();
                            break;
                        }
                        if (this.state.currentChar == '[') {
                            this.state.read();
                            this.state.expect("CDATA[");
                            this.cData.read();
                            break;
                        }
                        String string = this.name.stringRead();
                        if (!string.equals("DOCTYPE")) break;
                        this.dtdScanner.read();
                        return;
                    }
                    if (this.state.currentChar == '?') {
                        this.state.read();
                        this.processingInstruction.read();
                        break;
                    }
                    throw new ScannerException(" '" + this.state.currentChar + "' expected [/?! -- [CDATA[ ]", this.state);
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    this.space.read();
                    break;
                }
                case '&': {
                    this.reference.read();
                    break;
                }
                default: {
                    if (this.datachar.read()) break;
                    throw new ScannerException(" '" + this.state.currentChar + "' expected a valid XML character", this.state);
                }
            }
        }
    }

    public static final void main(String[] stringArray) {
        try {
            for (int i = 0; i < 10; ++i) {
                Token token;
                boolean bl = false;
                if (stringArray.length == 2) {
                    bl = true;
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(stringArray[0]));
                Reader reader = XmlReader.createReader(bufferedInputStream);
                Scanner scanner = new Scanner(reader);
                scanner.setReadDTD();
                long l = System.currentTimeMillis();
                if (!bl) {
                    do {
                        token = scanner.scan();
                        while (token == null) {
                            token = scanner.scan();
                        }
                        System.out.print("[" + scanner.getLine());
                        System.out.print("," + scanner.getColumn() + "] ");
                        System.out.println(token);
                    } while (!token.isEOF());
                    break;
                }
                do {
                    token = scanner.scan();
                    while (token == null) {
                        token = scanner.scan();
                    }
                } while (!token.isEOF());
                long l2 = System.currentTimeMillis();
                long l3 = l2 - l;
                System.out.println("Scanner took:" + l3 + " milliseconds");
            }
        }
        catch (ScannerException scannerException) {
            System.out.println(scannerException);
            scannerException.printStackTrace();
            scannerException.printTokenStack();
            scannerException.printErrorLine();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

