/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

import java.io.IOException;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.ScannerState;

final class CharData {
    private ScannerState state;
    private boolean[] terminateCharacters = new boolean[256];

    private void addCharacter(int n) {
        this.terminateCharacters[n] = true;
    }

    CharData(ScannerState scannerState) {
        this(scannerState, "<&");
    }

    CharData(ScannerState scannerState, String string) {
        for (int i = 0; i < this.terminateCharacters.length; ++i) {
            this.terminateCharacters[i] = false;
        }
        this.state = scannerState;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            this.addCharacter(cArray[i]);
        }
    }

    boolean isTerminateChar(int n) {
        if (n < 0 || n >= this.terminateCharacters.length) {
            return false;
        }
        return this.terminateCharacters[n];
    }

    boolean read() throws IOException, ScannerException {
        int n = 0;
        this.state.mark();
        while (true) {
            if (this.isTerminateChar(this.state.currentChar) || this.state.checkSize(n) || this.state.hasReachedEOF()) {
                if (n > 0) {
                    this.state.pushToken(this.state.createToken(13, n));
                    return true;
                }
                this.state.unMark();
                return false;
            }
            this.state.checkedRead();
            ++n;
        }
    }
}

