/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.baseparser;

import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.reader.XmlChars;

public class XMLDeclaration {
    protected String version = null;
    protected String encoding = null;
    protected String standalone = null;
    protected boolean isValid = false;
    protected int position = 0;
    protected char currentChar;
    protected String input;
    protected static final boolean debug = false;

    public XMLDeclaration(String string) {
        this.input = string;
        if (this.input != null && this.hasNext()) {
            this.accept();
        }
    }

    protected boolean hasNext() {
        return this.position < this.input.length();
    }

    protected void accept() {
        if (!this.hasNext()) {
            return;
        }
        this.currentChar = this.input.charAt(this.position);
        ++this.position;
    }

    protected void accept(char c) throws ParseException {
        if (this.currentChar != c) {
            throw new ParseException("The XMLDeclaration was not well formed");
        }
        this.accept();
    }

    protected void accept(String string) throws ParseException {
        for (int i = 0; i < string.length(); ++i) {
            this.accept(string.charAt(i));
        }
    }

    protected void skipSpace() {
        while (XmlChars.isSpace(this.currentChar) && this.hasNext()) {
            this.accept();
        }
    }

    protected String readName(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.currentChar != c && this.hasNext()) {
            stringBuffer.append(this.currentChar);
            this.accept();
        }
        return stringBuffer.toString();
    }

    protected String readAttribute() throws ParseException {
        this.skipSpace();
        if (this.currentChar == '\'') {
            this.accept();
            String string = this.readName('\'');
            this.accept('\'');
            return string;
        }
        if (this.currentChar == '\"') {
            this.accept();
            String string = this.readName('\"');
            this.accept('\"');
            return string;
        }
        throw new ParseException("Unterminated value");
    }

    protected void readEquals() throws ParseException {
        this.skipSpace();
        this.accept('=');
        this.skipSpace();
    }

    protected String readParam(String string) throws ParseException {
        this.skipSpace();
        this.accept(string);
        this.readEquals();
        String string2 = this.readAttribute();
        return string2;
    }

    public void parse() throws ParseException {
        if (this.input == null) {
            return;
        }
        this.version = this.readParam("version");
        if (!this.hasNext()) {
            return;
        }
        this.skipSpace();
        if (this.currentChar == 'e') {
            this.encoding = this.readParam("encoding");
        }
        this.skipSpace();
        if (this.currentChar == 's') {
            this.standalone = this.readParam("standalone");
            if (!this.standalone.equals("yes") && !this.standalone.equals("no")) {
                throw new ParseException("Standalone declaration must be yes or no [" + this.standalone + "]");
            }
        }
        this.skipSpace();
        if (this.hasNext()) {
            throw new ParseException("The XML Encoding Declaration must consist of a valid version plus optional encoding and standalone declarations");
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getStandalone() {
        return this.standalone;
    }

    public String toString() {
        String string = "<?xml ";
        if (this.version != null) {
            string = string + "version='" + this.version + "'";
        }
        if (this.encoding != null) {
            string = string + " encoding='" + this.encoding + "'";
        }
        if (this.standalone != null) {
            string = string + " standalone='" + this.standalone + "'";
        }
        string = string + "?>";
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            XMLDeclaration xMLDeclaration = new XMLDeclaration("version = '1.0' encoding = 'foo' standalone='no'");
            xMLDeclaration.parse();
            System.out.println(xMLDeclaration);
            xMLDeclaration = new XMLDeclaration("version = '1.0' encoding = 'foo'");
            xMLDeclaration.parse();
            System.out.println(xMLDeclaration);
            xMLDeclaration = new XMLDeclaration("version = '1.0' ");
            xMLDeclaration.parse();
            System.out.println(xMLDeclaration);
            try {
                xMLDeclaration = new XMLDeclaration("version = '1.0 ");
                xMLDeclaration.parse();
            }
            catch (ParseException parseException) {
                System.out.println("Caught a bad decl [1]" + parseException);
            }
            System.out.println(xMLDeclaration);
            try {
                xMLDeclaration = new XMLDeclaration("version = '1.0' standalone='nope' ");
                xMLDeclaration.parse();
            }
            catch (ParseException parseException) {
                System.out.println("Caught a bad decl [2]" + parseException);
            }
            System.out.println(xMLDeclaration);
        } else {
            XMLDeclaration xMLDeclaration = new XMLDeclaration(stringArray[0]);
            xMLDeclaration.parse();
            System.out.println(xMLDeclaration);
        }
    }
}

