/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.baseparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.xml.babel.baseparser.Attribute;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.Element;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.scanner.ScannerException;

public final class StartElement
extends Element {
    ArrayList attributes = new ArrayList();
    boolean declaresNameSpace;
    boolean declaresDefaultNameSpace;

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public List getAttributes() {
        return this.attributes;
    }

    StartElement() {
    }

    protected void init() {
        super.init();
        this.attributes.clear();
        this.declaresNameSpace = false;
        this.declaresDefaultNameSpace = false;
    }

    public void parse(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        this.init();
        this.setPosition(baseParser);
        baseParser.accept(1);
        switch (baseParser.currentToken.tokenType) {
            case 18: {
                this.prefix = baseParser.currentToken.text;
                baseParser.accept();
                this.name = baseParser.currentToken.text;
                baseParser.accept(0);
                break;
            }
            case 0: {
                this.name = baseParser.currentToken.text;
                baseParser.accept();
                break;
            }
            default: {
                throw new ParseException("Expected a NAME", baseParser.getLine(), baseParser.currentToken);
            }
        }
        while (!baseParser.compare(2) && !baseParser.compare(5)) {
            Attribute attribute = new Attribute();
            attribute.parse(baseParser);
            this.addAttribute(attribute);
            if (attribute.isNameSpaceDeclaration()) {
                this.declaresNameSpace = true;
            }
            if (!attribute.declaresDefaultNameSpace()) continue;
            this.declaresDefaultNameSpace = true;
        }
        switch (baseParser.currentToken.tokenType) {
            case 2: {
                this.type = 0;
                baseParser.accept();
                break;
            }
            case 5: {
                this.type = 1;
                baseParser.accept();
                break;
            }
            default: {
                throw new ParseException("Expected a > or />", baseParser.getLine(), baseParser.currentToken);
            }
        }
        if (!this.setNameSpace(baseParser)) {
            this.setDefaultNameSpace(baseParser);
        }
        this.setAttributesNameSpaces(baseParser);
    }

    private void setAttributesNameSpaces(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        int n = this.attributes.size();
        for (int i = 0; i < n; ++i) {
            Attribute attribute = (Attribute)this.attributes.get(i);
            attribute.setNameSpace(baseParser);
        }
    }

    public boolean declaresNameSpace() {
        return this.declaresNameSpace;
    }

    public boolean declaresDefaultNameSpace() {
        return this.declaresDefaultNameSpace;
    }

    public String toString() {
        String string = "<";
        string = string + this.getName();
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            string = string + attribute.toString();
        }
        string = this.type == 0 ? string + ">" : string + "/>";
        return string;
    }
}

