/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.util;

import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import weblogic.utils.AssertionError;
import weblogic.utils.StackTraceUtils;
import weblogic.webservice.core.soap.DetailImpl;
import weblogic.webservice.core.soap.NameImpl;
import weblogic.webservice.core.soap.SOAPElementImpl;
import weblogic.webservice.core.soap.SOAPFaultImpl;
import weblogic.webservice.util.ExceptionUtil;
import weblogic.webservice.util.WLMessageFactory;

public final class FaultUtil {
    private static final String FAULT_URI = "http://www.bea.com/servers/wls70/webservice/fault/1.0.0";
    private static final String soapEnvelopeNS = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String FAULT_PREFIX = "bea_fault";
    private static final Name FAULT_NAME = new NameImpl("stacktrace", "bea_fault", "http://www.bea.com/servers/wls70/webservice/fault/1.0.0");
    private static final boolean isJ2ME = FaultUtil.isJ2ME();

    private static boolean isJ2ME() {
        try {
            Class.forName("java.rmi.RemoteException");
            return false;
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    public static Detail newDetail() {
        return new DetailImpl();
    }

    public static void throwSOAPFaultException(String string, String string2, Throwable throwable) throws SOAPFaultException {
        throw new SOAPFaultException(new QName(soapEnvelopeNS, string), string2, null, FaultUtil.newDetail(throwable));
    }

    public static Detail newDetail(Throwable throwable) {
        if (throwable instanceof SOAPFaultException) {
            return ((SOAPFaultException)throwable).getDetail();
        }
        Detail detail = FaultUtil.newDetail();
        return FaultUtil.fillDetail(throwable, detail);
    }

    public static Detail fillDetail(Throwable throwable, Detail detail) {
        try {
            DetailEntry detailEntry = detail.addDetailEntry(FAULT_NAME);
            detailEntry.addNamespaceDeclaration(FAULT_PREFIX, FAULT_URI);
            StringBuffer stringBuffer = new StringBuffer();
            Throwable throwable2 = throwable;
            String string = "";
            do {
                stringBuffer.append(string);
                stringBuffer.append(StackTraceUtils.throwable2StackTrace(throwable));
                throwable2 = isJ2ME ? null : throwable2.getCause();
                string = "Caused by: ";
            } while (throwable2 != null);
            detailEntry.addTextNode(stringBuffer.toString());
        }
        catch (SOAPException sOAPException) {
            throw new AssertionError(sOAPException);
        }
        return detail;
    }

    public static void fillFault(SOAPFault sOAPFault, Throwable throwable) throws SOAPException {
        if (throwable instanceof SOAPFaultException) {
            SOAPFaultException sOAPFaultException = (SOAPFaultException)throwable;
            FaultUtil.addFaultCode(sOAPFault, sOAPFaultException);
            sOAPFault.setFaultString(sOAPFaultException.getFaultString());
            String string = sOAPFaultException.getFaultActor();
            if (string != null) {
                sOAPFault.setFaultActor(string);
            }
            if (sOAPFaultException.getDetail() != null) {
                ((SOAPFaultImpl)sOAPFault).setDetail(sOAPFaultException.getDetail());
            }
        } else if (throwable.getClass().getName().endsWith("AccessException")) {
            sOAPFault.setFaultCode(SOAPElementImpl.ENV_PREFIX + ":Client.Authentication");
            sOAPFault.setFaultString(throwable.getMessage());
            FaultUtil.fillDetail(throwable, sOAPFault.addDetail());
        } else {
            sOAPFault.setFaultCode(SOAPElementImpl.ENV_PREFIX + ":Server");
            sOAPFault.setFaultString("Exception during processing: " + throwable.toString() + " (see Fault Detail for stacktrace)");
            FaultUtil.fillDetail(throwable, sOAPFault.addDetail());
        }
    }

    private static void addFaultCode(SOAPFault sOAPFault, SOAPFaultException sOAPFaultException) throws SOAPException {
        QName qName = sOAPFaultException.getFaultCode();
        if (qName == null) {
            sOAPFault.setFaultCode(SOAPElementImpl.ENV_PREFIX + ":Server");
        } else {
            String string = qName.getLocalPart();
            String string2 = qName.getNamespaceURI();
            if (string == null) {
                string = "Server";
            }
            if (string2 == null) {
                sOAPFault.setFaultCode(SOAPElementImpl.ENV_PREFIX + ":" + string);
            } else {
                sOAPFault.addNamespaceDeclaration("fault", string2);
                sOAPFault.setFaultCode("fault:" + string);
            }
        }
    }

    public static SOAPMessage exception2Fault(Throwable throwable) {
        try {
            SOAPMessage sOAPMessage = WLMessageFactory.getInstance().getMessageFactory().createMessage();
            SOAPFault sOAPFault = sOAPMessage.getSOAPPart().getEnvelope().getBody().addFault();
            if (!isJ2ME) {
                throwable = ExceptionUtil.unwrapException(throwable);
            }
            FaultUtil.fillFault(sOAPFault, throwable);
            return sOAPMessage;
        }
        catch (SOAPException sOAPException) {
            throw new AssertionError(sOAPException);
        }
    }
}

