/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.SOAPException;
import weblogic.utils.AssertionError;
import weblogic.xml.schema.binding.BindingException;
import weblogic.xml.schema.binding.TypeMapping;
import weblogic.xml.schema.binding.TypeMappingBuilder;
import weblogic.xml.schema.binding.TypeMappingBuilderFactory;

public final class ExceptionUtil {
    static /* synthetic */ Class class$java$lang$Exception;

    public static Throwable unwrapException(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            InvocationTargetException invocationTargetException = (InvocationTargetException)throwable;
            if (invocationTargetException.getTargetException() != null) {
                return ExceptionUtil.unwrapException(invocationTargetException.getTargetException());
            }
            return throwable;
        }
        if (throwable instanceof JAXRPCException) {
            JAXRPCException jAXRPCException = (JAXRPCException)throwable;
            if (jAXRPCException.getLinkedCause() != null) {
                return ExceptionUtil.unwrapException(jAXRPCException.getLinkedCause());
            }
            return throwable;
        }
        if (throwable instanceof SOAPException) {
            SOAPException sOAPException = (SOAPException)throwable;
            if (sOAPException.getCause() != null) {
                return ExceptionUtil.unwrapException(sOAPException.getCause());
            }
            return throwable;
        }
        if (throwable instanceof RemoteException) {
            RemoteException remoteException = (RemoteException)throwable;
            return remoteException.detail == null ? remoteException : remoteException.detail;
        }
        return throwable;
    }

    public static Object getPropertyValue(Object object, Class clazz) {
        Method[] methodArray = object.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().startsWith("get") || !methodArray[i].getReturnType().equals(clazz) || methodArray[i].getParameterTypes().length != 0) continue;
            try {
                return methodArray[i].invoke(object, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
            catch (InvocationTargetException invocationTargetException) {
                return null;
            }
        }
        return null;
    }

    public static Class getSingleSimpleProperty(Class clazz) {
        Class clazz2 = ExceptionUtil.getSingleSimpleType(clazz);
        if (clazz2 == null) {
            return null;
        }
        if (ExceptionUtil.getPropertyName(clazz, clazz2) != null) {
            return clazz2;
        }
        return null;
    }

    public static String getSingleSimplePropertyName(Class clazz) {
        Class clazz2 = ExceptionUtil.getSingleSimpleType(clazz);
        if (clazz2 == null) {
            return null;
        }
        return ExceptionUtil.getPropertyName(clazz, clazz2);
    }

    private static String getPropertyName(Class clazz, Class clazz2) {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            String string = methodArray[i].getName();
            if (!string.startsWith("get") || string.length() <= 3 || !methodArray[i].getReturnType().equals(clazz2) || methodArray[i].getParameterTypes().length != 0) continue;
            return string.substring(3);
        }
        return null;
    }

    private static Class getSingleSimpleType(Class clazz) {
        Object object;
        if (!(class$java$lang$Exception == null ? (class$java$lang$Exception = ExceptionUtil.class$("java.lang.Exception")) : class$java$lang$Exception).isAssignableFrom(clazz)) {
            throw new AssertionError(clazz.getName() + " is not an exception.");
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        HashSet hashSet = new HashSet();
        TypeMappingBuilder typeMappingBuilder = TypeMappingBuilderFactory.newInstance().createTypeMappingBuilder();
        TypeMapping typeMapping = null;
        try {
            typeMapping = typeMappingBuilder.getTypeMapping();
        }
        catch (BindingException bindingException) {
            return null;
        }
        for (int i = 0; i < constructorArray.length; ++i) {
            object = constructorArray[i].getParameterTypes();
            if (((Class<?>[])object).length == 0) continue;
            if (((Class<?>[])object).length > 1) {
                return null;
            }
            hashSet.add(object[0]);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (Class)iterator.next();
            if (typeMapping.getXMLNameFromClass((Class)object) == null) continue;
            return object;
        }
        return null;
    }

    public static Class getSingleArrayProperty(Class clazz) {
        Object object;
        if (!(class$java$lang$Exception == null ? (class$java$lang$Exception = ExceptionUtil.class$("java.lang.Exception")) : class$java$lang$Exception).isAssignableFrom(clazz)) {
            throw new AssertionError(clazz.getName() + " is not an exception.");
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < constructorArray.length; ++i) {
            object = constructorArray[i].getParameterTypes();
            if (((Class<?>[])object).length == 0) continue;
            if (((Class<?>[])object).length > 1) {
                return null;
            }
            hashSet.add(object[0]);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (Class)iterator.next();
            if (((Class)object).getComponentType() == null || ExceptionUtil.getPropertyName(clazz, (Class)object) == null) continue;
            return object;
        }
        return null;
    }

    public static Class getSingleProperty(Class clazz) {
        Object object;
        if (!(class$java$lang$Exception == null ? (class$java$lang$Exception = ExceptionUtil.class$("java.lang.Exception")) : class$java$lang$Exception).isAssignableFrom(clazz)) {
            throw new AssertionError(clazz.getName() + " is not an exception.");
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        HashSet hashSet = new HashSet();
        for (int i = 0; i < constructorArray.length; ++i) {
            object = constructorArray[i].getParameterTypes();
            if (((Class<?>[])object).length == 0) continue;
            if (((Class<?>[])object).length > 1) {
                return null;
            }
            hashSet.add(object[0]);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (Class)iterator.next();
            if (ExceptionUtil.getPropertyName(clazz, object) == null) continue;
            return object;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

