/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.tools.wsdlp;

import java.util.Iterator;
import weblogic.webservice.Operation;
import weblogic.webservice.Part;
import weblogic.webservice.tools.wsdlp.WSDLParseException;

public class ParameterModeHelper {
    public void updateParameterMode(Operation operation) throws WSDLParseException {
        this.setParameterMode(operation);
        if (operation.getParameterOrder() != null) {
            this.handleParamOrder(operation);
        } else {
            this.handleNullParamOrder(operation);
        }
    }

    private void handleNullParamOrder(Operation operation) {
        Part part = null;
        Iterator iterator = operation.getOutput().getParts();
        while (iterator.hasNext()) {
            Part part2 = (Part)iterator.next();
            if (part2.isHeader()) continue;
            if (part == null) {
                part = part2;
                continue;
            }
            return;
        }
        if (part != null) {
            part.setMode(Part.Mode.RETURN);
        }
    }

    private void handleParamOrder(Operation operation) throws WSDLParseException {
        String[] stringArray = operation.getParameterOrder();
        if (stringArray == null) {
            return;
        }
        this.checkMissingPart(operation, stringArray);
        this.findReturnPart(operation, stringArray);
    }

    private void findReturnPart(Operation operation, String[] stringArray) throws WSDLParseException {
        boolean bl = false;
        Iterator iterator = operation.getOutput().getParts();
        while (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            if (this.containsString(part.getName(), stringArray)) continue;
            if (bl) {
                if (part.isBody()) {
                    System.err.println("WARNING: Parameter order [" + this.toString(stringArray) + "] for Operation [" + operation.getName() + "] miss more than one part name. " + "Missing part in the parameter order is taken as the return" + "type. Hence there should be only one missing part in " + "the parameterOrder");
                }
                operation.setParameterOrder((String)null);
                return;
            }
            if (part.getMode() == Part.Mode.INOUT) {
                throw new WSDLParseException("Return part " + part.getName() + " can not be an inout parameter. It should be defined as " + "an out parameter");
            }
            part.setMode(Part.Mode.RETURN);
            bl = true;
        }
    }

    private String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 2) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private boolean containsString(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private void checkMissingPart(Operation operation, String[] stringArray) throws WSDLParseException {
        for (int i = 0; i < stringArray.length; ++i) {
            Part part = operation.getInput().getPart(stringArray[i]);
            Part part2 = operation.getOutput().getPart(stringArray[i]);
            if (part != null || part2 != null) continue;
            throw new WSDLParseException("part specified in the parameterOrder:" + stringArray[i] + " not defined in in or out message." + operation);
        }
    }

    private void setParameterMode(Operation operation) throws WSDLParseException {
        Part part;
        Part part2;
        Iterator iterator = operation.getInput().getParts();
        while (iterator.hasNext()) {
            part2 = (Part)iterator.next();
            if (this.isSamePart(part2, part = operation.getOutput().getPart(part2.getName()))) {
                part2.setMode(Part.Mode.INOUT);
                part.setMode(Part.Mode.INOUT);
                continue;
            }
            part2.setMode(Part.Mode.IN);
        }
        iterator = operation.getOutput().getParts();
        while (iterator.hasNext()) {
            part2 = (Part)iterator.next();
            part = operation.getInput().getPart(part2.getName());
            if (this.isSamePart(part, part2)) {
                part2.setMode(Part.Mode.INOUT);
                continue;
            }
            part2.setMode(Part.Mode.OUT);
        }
    }

    private boolean isSamePart(Part part, Part part2) {
        if (part == null || part2 == null) {
            return false;
        }
        if (part.getName().equals(part2.getName())) {
            return part.getJavaType() != null && part.getJavaType().equals(part2.getJavaType());
        }
        return false;
    }
}

