/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.tools.wsdlp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import weblogic.utils.encoders.BASE64Encoder;
import weblogic.utils.encoders.CharacterEncoder;
import weblogic.webservice.WebServiceLogger;
import weblogic.webservice.client.BaseWLSSLAdapter;
import weblogic.webservice.client.SSLAdapter;
import weblogic.webservice.client.SSLAdapterFactory;
import weblogic.webservice.client.WLSSLAdapter;
import weblogic.webservice.tools.wsdlp.WSDLParseException;
import weblogic.webservice.tools.wsdlp.WSDLParser;
import weblogic.xml.xmlnode.XMLNode;

public class DefinitionFactory {
    private SSLAdapter adapter = null;

    public DefinitionFactory() {
        this.adapter = SSLAdapterFactory.getDefaultFactory().getSSLAdapter();
    }

    public DefinitionFactory(SSLAdapter sSLAdapter) {
        this.adapter = sSLAdapter;
    }

    private URL getWsdlURL(String string) throws IOException {
        try {
            URL uRL = new URL(string);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            URL uRL;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            if ((uRL = classLoader.getResource(string)) != null) {
                return uRL;
            }
            uRL = this.getClass().getResource(string);
            if (uRL != null) {
                return uRL;
            }
            throw new IOException("unable to find resource:" + string);
        }
    }

    public XMLNode createDefinition(String string) throws IOException {
        InputStream inputStream = null;
        try {
            Object object;
            Object object2;
            Object object3;
            URL uRL = this.getWsdlURL(string);
            String string2 = uRL.getUserInfo();
            if (string2 != null) {
                uRL = new URL(uRL.getProtocol() + "://" + uRL.getHost() + ":" + uRL.getPort() + uRL.getPath() + "?" + uRL.getQuery());
                object3 = new BASE64Encoder();
                string2 = "Basic " + ((CharacterEncoder)object3).encodeBuffer(string2.getBytes());
            }
            object3 = null;
            if ("https".equalsIgnoreCase(uRL.getProtocol())) {
                if (this.adapter instanceof WLSSLAdapter) {
                    object2 = (WLSSLAdapter)this.adapter;
                    object = ((BaseWLSSLAdapter)object2).createSocket(uRL.getHost(), uRL.getPort());
                    StringBuffer stringBuffer = new StringBuffer(128);
                    if (string2 == null) {
                        stringBuffer.append("GET " + uRL.getFile() + " HTTP/1.0\r\n\r\n");
                    } else {
                        stringBuffer.append("GET " + uRL.getFile() + " HTTP/1.0\r\n");
                        stringBuffer.append("Authorization: " + string2 + "\r\n\r\n");
                    }
                    OutputStream outputStream = ((Socket)object).getOutputStream();
                    outputStream.write(stringBuffer.toString().getBytes());
                    outputStream.flush();
                    outputStream.close();
                    inputStream = ((Socket)object).getInputStream();
                } else {
                    object3 = this.adapter.openConnection(uRL);
                    if (string2 != null) {
                        ((URLConnection)object3).setRequestProperty("Authorization", string2);
                    }
                    inputStream = ((URLConnection)object3).getInputStream();
                }
            } else {
                object3 = uRL.openConnection();
                if (string2 != null) {
                    ((URLConnection)object3).setRequestProperty("Authorization", string2);
                }
                inputStream = ((URLConnection)object3).getInputStream();
            }
            object2 = new XMLNode();
            ((XMLNode)object2).read(inputStream, true);
            this.resolveImports(string, (XMLNode)object2);
            object = object2;
            return object;
        }
        catch (IOException iOException) {
            String string3 = WebServiceLogger.logDefinitionFactoryIOException();
            WebServiceLogger.logStackTrace(string3, iOException);
            throw new WSDLParseException("Failed to retrieve WSDL from " + string + ". Please check the URL and make sure " + "that it is a valid XML file [" + iOException + "]");
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void resolveImports(String string, XMLNode xMLNode) throws IOException {
        XMLNode xMLNode2 = xMLNode.getChild("import", WSDLParser.wsdlNS);
        if (xMLNode2 == null) {
            return;
        }
        xMLNode.removeChild(xMLNode2);
        String string2 = xMLNode2.getAttribute("location", null);
        URL uRL = this.findImportedWSDL(string, string2);
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            string2 = n != -1 ? string2.substring(0, n) : null;
        }
        XMLNode xMLNode3 = new XMLNode(string2);
        InputStream inputStream = null;
        inputStream = this.adapter != null ? this.adapter.openConnection(uRL).getInputStream() : uRL.openStream();
        xMLNode3.read(inputStream, true);
        String string3 = xMLNode3.getName().getLocalName();
        if ("schema".equals(string3)) {
            this.addToTypes(xMLNode, xMLNode3);
        } else if ("definitions".equals(string3)) {
            this.resolveImports(uRL.toString(), xMLNode3);
            this.addToDefinition(xMLNode, xMLNode3);
        } else {
            throw new WSDLParseException("unknown element in the imported wsdl:" + string3);
        }
        this.resolveImports(string, xMLNode);
    }

    private URL findImportedWSDL(String string, String string2) throws WSDLParseException, IOException {
        if (string2 == null) {
            throw new WSDLParseException("location must be specified in import:");
        }
        try {
            return new URL(string2);
        }
        catch (IOException iOException) {
            return new URL(this.removeFile(string) + "/" + string2);
        }
    }

    private String removeFile(String string) {
        int n = string.lastIndexOf("/");
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    private void addToTypes(XMLNode xMLNode, XMLNode xMLNode2) {
        XMLNode xMLNode3 = xMLNode.getChild("types", WSDLParser.wsdlNS);
        if (xMLNode3 == null) {
            xMLNode3 = xMLNode.addChild("types", xMLNode.getName().getPrefix(), WSDLParser.wsdlNS);
        }
        xMLNode3.addChild(xMLNode2);
    }

    private void addToDefinition(XMLNode xMLNode, XMLNode xMLNode2) {
        Iterator iterator = xMLNode2.getChildren();
        while (iterator.hasNext()) {
            XMLNode xMLNode3 = (XMLNode)iterator.next();
            if ("types".equals(xMLNode3.getName().getLocalName())) {
                Iterator iterator2 = xMLNode3.getChildren();
                while (iterator2.hasNext()) {
                    this.addToTypes(xMLNode, (XMLNode)iterator2.next());
                }
                continue;
            }
            xMLNode.addChild(xMLNode3);
        }
    }
}

