/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.saf;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.apache.xerces.dom.DocumentImpl;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.Debug;
import weblogic.webservice.GenericHandler;
import weblogic.webservice.ReliableDelivery;
import weblogic.webservice.WLMessageContext;
import weblogic.webservice.async.AsyncInfo;
import weblogic.webservice.async.FutureResultImpl;
import weblogic.webservice.core.ClientDispatcher;
import weblogic.webservice.core.handler.ConversationContext;
import weblogic.webservice.core.soap.SOAPElementImpl;
import weblogic.webservice.saf.ConversationAssembler;
import weblogic.webservice.saf.DeliveryFailureAction;
import weblogic.webservice.saf.DeliverySuccessAction;
import weblogic.webservice.saf.ReliableMessagingConstants;
import weblogic.webservice.saf.SAFAgent;
import weblogic.webservice.saf.StoreForwardException;
import weblogic.webservice.saf.Util;
import weblogic.webservice.saf.WSSAFAgent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.xmlnode.XMLNode;

public final class SAFHandler
extends GenericHandler
implements ReliableMessagingConstants {
    private String messageId;
    private String sequenceNumber;
    private SAFAgent saf;
    private ConversationAssembler conversation;
    private ReliableDelivery listener;
    private FutureResultImpl futureResult;
    private int retryCount = -1;
    private long retryInterval = -1L;
    private long persistDuration = -1L;
    private AuthenticatedSubject kernelID;
    private static boolean debug = false;

    public void init(HandlerInfo handlerInfo) {
        super.init(handlerInfo);
        debug = "true".equalsIgnoreCase(System.getProperty("weblogic.webservice.reliable.verbose")) || "true".equalsIgnoreCase(System.getProperty("weblogic.webservice.reliable.debug")) || debug;
        this.kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        Map map = handlerInfo.getHandlerConfig();
        if (debug) {
            Debug.say("** init called with: " + map);
        }
        if (map != null) {
            Integer n;
            Integer n2;
            Integer n3 = (Integer)map.get("retries_param");
            if (n3 != null) {
                this.retryCount = n3;
            }
            if ((n2 = (Integer)map.get("retry_interval_param")) != null) {
                this.retryInterval = n2 * 1000;
            }
            if ((n = (Integer)map.get("persist_interval_param")) != null) {
                this.persistDuration = n * 1000;
            }
        }
        if (debug) {
            Debug.say("== init(): retryCount = " + this.retryCount + "retryInterval  = " + this.retryInterval + "persistDuration  = " + this.persistDuration);
        }
        this.saf = WSSAFAgent.getSAFAgent();
    }

    public boolean handleRequest(MessageContext messageContext) throws JAXRPCException {
        if (debug) {
            Debug.say("** handleRequest called");
        }
        boolean bl = false;
        boolean bl2 = false;
        AsyncInfo asyncInfo = null;
        if (messageContext instanceof WLMessageContext) {
            this.listener = (ReliableDelivery)((WLMessageContext)messageContext).getProperty("__BEA_PRIVATE_RELIABLE_PROP");
            if (debug) {
                Debug.say("== listener = " + this.listener);
            }
            this.futureResult = (FutureResultImpl)((WLMessageContext)messageContext).getProperty("__BEA_PRIVATE_FUTURE_RESULT_PROP");
            if (debug) {
                Debug.say("== futureResult = " + this.futureResult);
            }
            if (this.futureResult != null) {
                asyncInfo = this.futureResult.getAsyncInfo();
                if (debug) {
                    Debug.say("== wsCtx = " + asyncInfo);
                }
                if (asyncInfo != null) {
                    bl2 = asyncInfo.isReliableDelivery();
                    bl = asyncInfo.isInOrderDelivery();
                }
            }
        }
        try {
            Object object;
            if (this.saf == null) {
                throw new JAXRPCException("Reliable SOAP message is not supported");
            }
            SOAPElement sOAPElement = SAFHandler.generateHeaders(messageContext);
            this.messageId = (String)messageContext.getProperty("__BEA_INTERNAL_MSG_ID");
            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
            SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
            SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
            SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
            SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
            if (sOAPHeader == null) {
                sOAPHeader = sOAPEnvelope.addHeader();
            }
            Iterator iterator = sOAPElement.getChildElements();
            while (iterator.hasNext()) {
                sOAPHeader.addChildElement((SOAPElement)iterator.next());
            }
            ConversationContext conversationContext = (ConversationContext)sOAPMessageContext.getProperty("__BEA_PRIVATE_CONVERSATION_PROP");
            String string = null;
            String string2 = null;
            if (conversationContext != null) {
                string = conversationContext.getConversationID();
                string2 = conversationContext.getHeaderType();
            }
            boolean bl3 = false;
            if (string == null || !bl) {
                string = "con" + this.messageId;
                bl3 = true;
            }
            this.conversation = (ConversationAssembler)this.saf.getConversation(string);
            if (this.conversation == null) {
                this.conversation = this.saf.createConversation(string, bl3, bl, this.retryCount, this.retryInterval, this.persistDuration, this.listener);
            }
            if (bl) {
                this.sequenceNumber = this.conversation.getNextSequenceNumberString();
                object = sOAPEnvelope.createName("MessageOrder", "wsr", "http://www.openuri.org/2002/10/soap/reliability/");
                Name name = sOAPEnvelope.createName("Version", "wsr", "http://www.openuri.org/2002/10/soap/reliability/");
                SOAPHeaderElement sOAPHeaderElement = sOAPHeader.addHeaderElement((Name)object);
                sOAPHeaderElement.addNamespaceDeclaration("wsr", "http://www.openuri.org/2002/10/soap/reliability/");
                sOAPHeaderElement.addAttribute(name, "1.0");
                sOAPHeaderElement.setMustUnderstand(true);
                SOAPElement sOAPElement2 = sOAPHeaderElement.addChildElement("SequenceNumber", "wsr");
                sOAPElement2.addTextNode(this.sequenceNumber);
                if (debug) {
                    Debug.say("*** Added  sequenceNumber '" + this.sequenceNumber + "' to MessageOrder header \n" + sOAPHeaderElement + "\n******\n(conversationId=" + string + ")***");
                }
            }
            if ((object = (ClientDispatcher)sOAPMessageContext.getProperty("weblogic.webservice.core.client-dispatcher")) != null) {
                this.conversation.addClientDispatcher(this.messageId, (ClientDispatcher)object);
            }
            messageContext.setProperty("__BEA_INTERNAL_CONV_ID", string);
            messageContext.setProperty("__BEA_INTERNAL_SEQ_NUM", this.sequenceNumber);
            messageContext.setProperty("__BEA_INTERNAL_PERSIST_DUR", new Long(this.persistDuration));
            return true;
        }
        catch (StoreForwardException storeForwardException) {
            throw new JAXRPCException("Failed to store the message", storeForwardException);
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException("Failed to store the message", sOAPException);
        }
    }

    public boolean handleResponse(MessageContext messageContext) {
        if (debug) {
            Debug.say("** handleResponse called");
        }
        try {
            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
            SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
            SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
            SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
            String string = SAFHandler.getStatus(sOAPEnvelope, true);
            String string2 = SAFHandler.getRefToMessageId(sOAPEnvelope);
            if ("OutOfOrder".equals(string)) {
                throw new JAXRPCException("Needs retry -- message is out of order");
            }
            if ("OK".equals(string)) {
                if (debug) {
                    Debug.say("*** Got OK acknowledgement for '" + string2 + "'***");
                }
                if (this.listener != null) {
                    DeliverySuccessAction deliverySuccessAction = new DeliverySuccessAction(this.listener);
                    Throwable throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)this.kernelID, (AuthenticatedSubject)SubjectUtils.getAnonymousSubject(), (PrivilegedAction)deliverySuccessAction);
                    if (throwable != null) {
                        throw new JAXRPCException("Could not deliver callback on successful RM delivery");
                    }
                }
            } else {
                if ("Dup".equals(string)) {
                    return false;
                }
                if (debug) {
                    Debug.say("*** No OK acknowledgement for '" + this.messageId + "'***");
                }
                throw new JAXRPCException("No Acknowledgement headers in the response");
            }
            this.cleanupConversation();
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException("Failed to handle the response", sOAPException);
        }
        catch (StoreForwardException storeForwardException) {
            throw new JAXRPCException("Failed to handle the response", storeForwardException);
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext) throws JAXRPCException {
        if (debug) {
            Debug.say("** handleFault called");
        }
        if (this.listener != null) {
            DeliveryFailureAction deliveryFailureAction = new DeliveryFailureAction(this.listener, "Failed to deliver message", "DF_UNKNOWN_CODE");
            Throwable throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)this.kernelID, (AuthenticatedSubject)SubjectUtils.getAnonymousSubject(), (PrivilegedAction)deliveryFailureAction);
            if (throwable != null) {
                throw new JAXRPCException("Could not deliver callback on failed RM delivery");
            }
        }
        try {
            this.cleanupConversation();
        }
        catch (StoreForwardException storeForwardException) {
            throw new JAXRPCException("Failed to remove a message from store", storeForwardException);
        }
        return true;
    }

    public static Element generateDOMHeaders(MessageContext messageContext) throws StoreForwardException {
        XMLNode xMLNode = (XMLNode)((Object)SAFHandler.generateHeaders(messageContext));
        XMLInputStream xMLInputStream = xMLNode.stream();
        XMLOutputStreamFactory xMLOutputStreamFactory = XMLOutputStreamFactory.newInstance();
        try {
            DocumentImpl documentImpl = new DocumentImpl();
            XMLOutputStream xMLOutputStream = xMLOutputStreamFactory.newOutputStream((Document)documentImpl);
            xMLOutputStream.add(xMLInputStream);
            xMLOutputStream.flush();
            return documentImpl.getDocumentElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StoreForwardException("Cannot create RM headers", xMLStreamException);
        }
    }

    private static SOAPElement generateHeaders(MessageContext messageContext) throws StoreForwardException {
        try {
            String string = (String)messageContext.getProperty("__BEA_INTERNAL_SOAP_ENV_PREFIX");
            if (string == null) {
                string = SOAPElementImpl.ENV_PREFIX;
            }
            SOAPFactory sOAPFactory = SOAPFactory.newInstance();
            SOAPElement sOAPElement = sOAPFactory.createElement("Header", string, "http://schemas.xmlsoap.org/soap/envelope/");
            sOAPElement.addNamespaceDeclaration(string, "http://schemas.xmlsoap.org/soap/envelope/");
            Name name = sOAPFactory.createName("MessageData", "wsmd", "http://openuri.org/2002/soap/messagedata/");
            Name name2 = sOAPFactory.createName("MessageID", "wsmd", "http://openuri.org/2002/soap/messagedata/");
            Name name3 = sOAPFactory.createName("Version", "wsmd", "http://openuri.org/2002/soap/messagedata/");
            Name name4 = sOAPFactory.createName("AckRequested", "wsr", "http://www.openuri.org/2002/10/soap/reliability/");
            Name name5 = sOAPFactory.createName("Version", "wsr", "http://www.openuri.org/2002/10/soap/reliability/");
            Name name6 = sOAPFactory.createName("mustUnderstand", string, "http://schemas.xmlsoap.org/soap/envelope/");
            WSSAFAgent wSSAFAgent = WSSAFAgent.getSAFAgent();
            if (wSSAFAgent == null) {
                throw new StoreForwardException("Store-And-Forward Agent was not initialized properly. Check your config.xml file");
            }
            String string2 = wSSAFAgent.getMessageId();
            messageContext.setProperty("__BEA_INTERNAL_MSG_ID", string2);
            SOAPElement sOAPElement2 = sOAPElement.addChildElement(name);
            sOAPElement2.addNamespaceDeclaration("wsmd", "http://openuri.org/2002/soap/messagedata/");
            sOAPElement2.addAttribute(name3, "1.0");
            SOAPElement sOAPElement3 = sOAPElement2.addChildElement(name2);
            sOAPElement3.addTextNode(string2);
            SOAPElement sOAPElement4 = sOAPElement.addChildElement(name4);
            sOAPElement4.addAttribute(name6, "1");
            sOAPElement4.addNamespaceDeclaration("wsr", "http://www.openuri.org/2002/10/soap/reliability/");
            sOAPElement4.addAttribute(name5, "1.0");
            if (debug) {
                Debug.say("*** Generated MessageData header ****\n" + sOAPElement2 + "\n*********\n and AckRequested header *****\n" + sOAPElement4 + "\n*******");
                Debug.say("*** Added messageId '" + string2 + "' to AckRequested header***");
            }
            return sOAPElement;
        }
        catch (SOAPException sOAPException) {
            throw new StoreForwardException("Cannot create RM headers", sOAPException);
        }
    }

    public static void storeAndForwardMessage(MessageContext messageContext) throws StoreForwardException {
        ClientDispatcher clientDispatcher;
        ConversationAssembler conversationAssembler;
        Integer n;
        Integer n2;
        if (debug) {
            Debug.say("** storeAndForwardMessage called");
        }
        int n3 = -1;
        long l = -1L;
        long l2 = -1L;
        boolean bl = false;
        boolean bl2 = false;
        Object var12_6 = null;
        Integer n4 = (Integer)messageContext.getProperty("retries_param");
        if (n4 != null) {
            n3 = n4;
        }
        if ((n2 = (Integer)messageContext.getProperty("retry_interval_param")) != null) {
            l = n2 * 1000;
        }
        if ((n = (Integer)messageContext.getProperty("persist_interval_param")) != null) {
            l2 = n * 1000;
        }
        ReliableDelivery reliableDelivery = (ReliableDelivery)messageContext.getProperty("__BEA_PRIVATE_RELIABLE_PROP");
        if (debug) {
            Debug.say("== listener = " + reliableDelivery);
        }
        WSSAFAgent wSSAFAgent = WSSAFAgent.getSAFAgent();
        String string = (String)messageContext.getProperty("__BEA_INTERNAL_MSG_ID");
        ConversationContext conversationContext = (ConversationContext)messageContext.getProperty("__BEA_PRIVATE_CONVERSATION_PROP");
        String string2 = null;
        String string3 = null;
        if (conversationContext != null) {
            string2 = conversationContext.getConversationID();
            string3 = conversationContext.getHeaderType();
        }
        boolean bl3 = false;
        if (string2 == null || !bl) {
            string2 = "con" + string;
            bl3 = true;
        }
        if ((conversationAssembler = (ConversationAssembler)wSSAFAgent.getConversation(string2)) == null) {
            conversationAssembler = wSSAFAgent.createConversation(string2, bl3, bl, n3, l, l2, reliableDelivery);
        }
        if ((clientDispatcher = (ClientDispatcher)messageContext.getProperty("weblogic.webservice.core.client-dispatcher")) != null) {
            conversationAssembler.addClientDispatcher(string, clientDispatcher);
        }
        wSSAFAgent.store(string, string2, null, messageContext, reliableDelivery, l2);
        if (debug) {
            Debug.say("*** Sucessfully stored the message:  messageId = " + string + "***");
        }
    }

    private void cleanupConversation() throws StoreForwardException {
        if (this.conversation != null && this.conversation.isDone()) {
            this.conversation.close();
            this.saf.removeConversation(this.conversation.getId());
            this.conversation = null;
        }
    }

    static String getStatus(SOAPEnvelope sOAPEnvelope, boolean bl) throws StoreForwardException {
        try {
            SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
            if (sOAPHeader == null) {
                sOAPHeader = sOAPEnvelope.addHeader();
            }
            Name name = sOAPEnvelope.createName("Acknowledgement", "wsr", "http://www.openuri.org/2002/10/soap/reliability/");
            Name name2 = sOAPEnvelope.createName("Status", "wsr", "http://www.openuri.org/2002/10/soap/reliability/");
            SOAPElement sOAPElement = Util.getChildSOAPElement((SOAPElement)sOAPHeader, (Name)name);
            if (sOAPElement == null) {
                if (debug) {
                    Debug.say("*** No acknowledgement in SOAPHeader ***");
                }
                return null;
            }
            if (bl) {
                sOAPElement.detachNode();
            }
            return sOAPElement.getAttributeValue(name2);
        }
        catch (SOAPException sOAPException) {
            throw new StoreForwardException("Failed to get the status in aknowledgement", sOAPException);
        }
    }

    private static String getRefToMessageId(SOAPEnvelope sOAPEnvelope) throws StoreForwardException {
        try {
            SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
            if (sOAPHeader == null) {
                sOAPHeader = sOAPEnvelope.addHeader();
            }
            Name name = sOAPEnvelope.createName("MessageData", "wsmd", "http://openuri.org/2002/soap/messagedata/");
            Name name2 = sOAPEnvelope.createName("RefToMessageID", "wsmd", "http://openuri.org/2002/soap/messagedata/");
            SOAPElement sOAPElement = Util.getChildSOAPElement((SOAPElement)sOAPHeader, (Name)name);
            if (sOAPElement == null) {
                if (debug) {
                    Debug.say("*** No MessageData in SOAPHeader ***");
                }
                throw new StoreForwardException("Could not find MessageData header in aknowledgement.");
            }
            SOAPElement sOAPElement2 = Util.getChildSOAPElement((SOAPElement)sOAPElement, (Name)name2);
            if (sOAPElement2 == null) {
                if (debug) {
                    Debug.say("*** No RefToMessageID in SOAPHeader ***");
                }
                return null;
            }
            sOAPElement.detachNode();
            return sOAPElement2.getValue();
        }
        catch (SOAPException sOAPException) {
            throw new StoreForwardException("Failed to get the RefTo message id in aknowledgement", sOAPException);
        }
    }
}

