/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.saf;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;
import weblogic.kernel.Kernel;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.time.common.TimeTriggerException;
import weblogic.utils.Debug;
import weblogic.webservice.ReliableDelivery;
import weblogic.webservice.WLMessageContext;
import weblogic.webservice.binding.Binding;
import weblogic.webservice.core.ClientDispatcher;
import weblogic.webservice.saf.Conversation;
import weblogic.webservice.saf.DeliveryFailureAction;
import weblogic.webservice.saf.MessageReference;
import weblogic.webservice.saf.ReliableMessagingConstants;
import weblogic.webservice.saf.RetryTrigger;
import weblogic.webservice.saf.SAFHandler;
import weblogic.webservice.saf.StoreForwardException;
import weblogic.webservice.saf.WSSAFAgent;
import weblogic.webservice.util.FaultUtil;

final class ConversationAssembler
extends Conversation
implements ReliableMessagingConstants {
    private boolean individual;
    private int nextSequenceNumber;
    private RetryTrigger trigger;
    private int retryCount;
    private long retryInterval;
    private HashMap dispatchers;
    private ReliableDelivery listener;
    private WSSAFAgent safAgent;
    private boolean poisoned;
    private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    ConversationAssembler(String string, boolean bl, boolean bl2, int n, long l, long l2, ReliableDelivery reliableDelivery) {
        super(string, bl2);
        this.individual = bl;
        this.dispatchers = new HashMap();
        this.listener = reliableDelivery;
        this.safAgent = WSSAFAgent.getSAFAgent();
        this.retryCount = n != -1 ? n : this.safAgent.getDefaultRetryNumber();
        this.retryInterval = l != -1L ? l : this.safAgent.getDefaultRetryInterval();
        this.persistDuration = l2 != -1L ? l2 : this.safAgent.getDefaultPersistDuration();
        this.nextSequenceNumber = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMessage(String string, int n, Object object) {
        MessageReference messageReference = null;
        if (object instanceof MessageContext) {
            messageReference = new MessageReference(string, n, (MessageContext)object, this.retryCount, this.retryInterval, this.persistDuration);
        }
        if (messageReference == null) {
            return;
        }
        boolean bl = false;
        ConversationAssembler conversationAssembler = this;
        synchronized (conversationAssembler) {
            if (this.poisoned) {
                this.rejectOneMessage(messageReference);
                return;
            }
            this.addMessageToList(messageReference);
            if (this.firstMessage == messageReference && this.firstMessage == this.lastMessage) {
                bl = true;
            }
        }
        if (bl) {
            if (this.trigger == null) {
                this.trigger = new RetryTrigger((Conversation)this, this.retryInterval);
            }
            try {
                this.trigger.init();
            }
            catch (TimeTriggerException timeTriggerException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveMessageToEnd(MessageReference messageReference) {
        ConversationAssembler conversationAssembler = this;
        synchronized (conversationAssembler) {
            if (messageReference == this.firstMessage) {
                this.firstMessage = messageReference.getNext();
                if (this.firstMessage != null) {
                    this.firstMessage.setPrev(null);
                }
            }
            messageReference.setNext(null);
            this.lastMessage.setNext(messageReference);
            messageReference.setPrev(this.lastMessage);
        }
    }

    void removeMessage(MessageReference messageReference) {
        this.removeMessageFromList(messageReference);
    }

    void rejectOneMessage(MessageReference messageReference) {
        MessageContext messageContext = messageReference.getMessage();
        if (messageContext instanceof SOAPMessageContext) {
            StoreForwardException storeForwardException = new StoreForwardException("Request failed to be delivered to the remote side either because the message was expired or it exceeded the maximum number of retries");
            ((SOAPMessageContext)messageContext).setMessage(FaultUtil.exception2Fault(storeForwardException));
            ClientDispatcher clientDispatcher = this.getAndRemoveClientDispatcher(messageReference.getMessageId());
            if (clientDispatcher != null) {
                clientDispatcher.callReceive((WLMessageContext)messageContext);
            }
            if (this.listener != null) {
                DeliveryFailureAction deliveryFailureAction = new DeliveryFailureAction(this.listener, storeForwardException.getMessage(), "DF_EXPIRED_CODE");
                Throwable throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)kernelID, (AuthenticatedSubject)SubjectUtils.getAnonymousSubject(), (PrivilegedAction)deliveryFailureAction);
                if (throwable != null) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rejectAllMessages() {
        MessageReference messageReference = null;
        ConversationAssembler conversationAssembler = this;
        synchronized (conversationAssembler) {
            this.poisoned = true;
            messageReference = this.firstMessage;
        }
        while (messageReference != null) {
            this.rejectOneMessage(messageReference);
            this.removeMessage(messageReference);
            conversationAssembler = this;
            synchronized (conversationAssembler) {
                messageReference = this.firstMessage;
            }
        }
    }

    public void getResponse(String string) throws StoreForwardException {
        if (debug) {
            Debug.say("getResponse(): This messageId = " + string);
        }
        MessageContext messageContext = this.safAgent.getSOAPMessage(string);
        Binding binding = (Binding)messageContext.getProperty("__BEA_PRIVATE_BINDING_PROP");
        boolean bl = "true".equals(messageContext.getProperty("__BEA_PRIVATE_ONEWAY_PROP"));
        try {
            binding.receive((WLMessageContext)messageContext);
            ClientDispatcher clientDispatcher = this.getAndRemoveClientDispatcher(string);
            if (debug) {
                Debug.say(" === getResponse() dispatcher =" + clientDispatcher);
            }
            if (clientDispatcher != null) {
                clientDispatcher.callReceive((WLMessageContext)messageContext);
            } else {
                String string2 = this.getSOAPFault(messageContext);
                if (string2 != null) {
                    ReliableDelivery reliableDelivery = (ReliableDelivery)((WLMessageContext)messageContext).getProperty("__BEA_PRIVATE_RELIABLE_PROP");
                    DeliveryFailureAction deliveryFailureAction = new DeliveryFailureAction(reliableDelivery, "Receiver returned SOAP Fault: " + string2, "DF_UNKNOWN_CODE");
                    Throwable throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)kernelID, (AuthenticatedSubject)SubjectUtils.getAnonymousSubject(), (PrivilegedAction)deliveryFailureAction);
                    if (throwable != null) {
                        // empty if block
                    }
                    return;
                }
                String string3 = this.getAckStatus(messageContext);
                if (string3 == null) {
                    throw new StoreForwardException("No Ack headers in SOAP response");
                }
            }
        }
        catch (IOException iOException) {
            throw new StoreForwardException("Failed to get response:" + iOException, iOException);
        }
        catch (SOAPException sOAPException) {
            throw new StoreForwardException("Failed to get response:" + sOAPException, sOAPException);
        }
        catch (JAXRPCException jAXRPCException) {
            throw new StoreForwardException("Failed to process response:" + jAXRPCException, jAXRPCException);
        }
    }

    synchronized void addClientDispatcher(String string, ClientDispatcher clientDispatcher) {
        this.dispatchers.put(string, clientDispatcher);
    }

    private synchronized ClientDispatcher getAndRemoveClientDispatcher(String string) {
        return (ClientDispatcher)this.dispatchers.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() {
        ConversationAssembler conversationAssembler = this;
        synchronized (conversationAssembler) {
            this.dispatchers.clear();
            if (this.running) {
                this.running = false;
            }
            this.lastMessage = null;
            this.firstMessage = null;
        }
        if (this.trigger != null) {
            try {
                this.trigger.cancel();
                this.trigger = null;
            }
            catch (TimeTriggerException timeTriggerException) {
                // empty catch block
            }
        }
    }

    final synchronized String getNextSequenceNumberString() {
        String string = Integer.toString(this.nextSequenceNumber, 10);
        ++this.nextSequenceNumber;
        return string;
    }

    final boolean isIndividual() {
        return this.individual;
    }

    private final String getAckStatus(MessageContext messageContext) throws StoreForwardException {
        try {
            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
            SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
            SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
            SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
            return SAFHandler.getStatus(sOAPEnvelope, false);
        }
        catch (SOAPException sOAPException) {
            throw new StoreForwardException("Failed to get the acknowledgement", sOAPException);
        }
    }

    private final String getSOAPFault(MessageContext messageContext) throws StoreForwardException {
        try {
            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
            SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
            SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
            SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
            SOAPBody sOAPBody = sOAPEnvelope.getBody();
            if (sOAPBody.hasFault()) {
                return sOAPBody.getFault().getFaultString();
            }
            return null;
        }
        catch (SOAPException sOAPException) {
            throw new StoreForwardException("Failed to get the SOAP Fault", sOAPException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() {
        ConversationAssembler conversationAssembler = this;
        synchronized (conversationAssembler) {
            if (this.running) {
                return;
            }
            this.running = true;
        }
        Kernel.execute((ExecuteRequest)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(ExecuteThread executeThread) {
        MessageReference messageReference = null;
        Object object = this;
        synchronized (object) {
            messageReference = this.firstMessage;
        }
        while (messageReference != null) {
            ConversationAssembler conversationAssembler;
            block32: {
                object = messageReference.getMessageId();
                if (debug) {
                    Debug.say("== in execute(): running = " + this.running + " firstMessage = " + (String)object);
                }
                if (messageReference.isExpired() || messageReference.getRetryLeft() == 0) {
                    if (debug) {
                        Debug.say("== execute() firstMessage is expired or exceeds retries");
                    }
                    try {
                        this.safAgent.remove((String)object);
                    }
                    catch (StoreForwardException storeForwardException) {
                        // empty catch block
                    }
                    if (this.isOrdered()) {
                        this.rejectAllMessages();
                        break;
                    }
                    this.rejectOneMessage(messageReference);
                    this.removeMessage(messageReference);
                    this.reScheduleConversationTrigger();
                    conversationAssembler = this;
                    synchronized (conversationAssembler) {
                        messageReference = this.firstMessage;
                        continue;
                    }
                }
                messageReference.decreaseRetryCount();
                try {
                    if (this.safAgent.forward((String)object) == -1) {
                        if (debug) {
                            Debug.say("Could not send message successfully");
                        }
                        if (this.ordered || this.isIndividual()) break;
                        this.moveMessageToEnd(messageReference);
                        this.reScheduleConversationTrigger();
                    }
                    break block32;
                }
                catch (Exception exception) {
                    if (debug) {
                        exception.printStackTrace();
                    }
                    if (!this.ordered && !this.isIndividual()) {
                        this.moveMessageToEnd(messageReference);
                        this.reScheduleConversationTrigger();
                    }
                    this.safAgent.resetSinceStart();
                }
                break;
            }
            if (debug) {
                Debug.say("== execute(): successfully forwarded message: " + (String)object);
            }
            try {
                this.getResponse((String)object);
                this.safAgent.remove((String)object);
            }
            catch (StoreForwardException storeForwardException) {
                if (debug) {
                    storeForwardException.printStackTrace();
                }
                if (this.ordered || this.isIndividual()) break;
                this.moveMessageToEnd(messageReference);
                this.reScheduleConversationTrigger();
                break;
            }
            if (debug) {
                Debug.say("== execute(): response is received");
            }
            this.removeMessage(messageReference);
            this.reScheduleConversationTrigger();
            if (this.ordered || this.individual) {
                conversationAssembler = this;
                synchronized (conversationAssembler) {
                    messageReference = this.firstMessage;
                    continue;
                }
            }
            if (!debug) break;
            Debug.say("== execute() con is not ordered");
            break;
        }
        object = this;
        synchronized (object) {
            this.running = false;
            if (this.isDone()) {
                this.close();
            }
        }
    }

    private void reScheduleConversationTrigger() {
        block7: {
            if (this.firstMessage == null) {
                block6: {
                    try {
                        this.trigger.cancel();
                    }
                    catch (TimeTriggerException timeTriggerException) {
                        if (!debug) break block6;
                        Debug.say("== trigger.cancel() got exception" + (Object)((Object)timeTriggerException));
                    }
                }
                return;
            }
            if (debug) {
                Debug.say("== reSchedule() next time:" + this.firstMessage.getNextScheduleInterval());
            }
            try {
                this.trigger.cancel();
                this.trigger.updateInterval(this.firstMessage.getNextScheduleInterval());
                this.trigger.init();
            }
            catch (TimeTriggerException timeTriggerException) {
                if (!debug) break block7;
                Debug.say("== reSchedule() got exception" + (Object)((Object)timeTriggerException));
            }
        }
    }

    void setRetryCount(int n) {
        this.retryCount = n;
    }

    void setRetryInterval(long l) {
        this.retryInterval = l;
    }
}

