/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.encoding;

import java.io.IOException;
import java.util.ArrayList;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.xml.rpc.JAXRPCException;
import javax.xml.transform.Source;
import weblogic.webservice.WebServiceLogger;
import weblogic.webservice.encoding.AttachmentCodec;
import weblogic.webservice.encoding.XMLSourceCodec;

public class XMLSourceArrayCodec
extends AttachmentCodec {
    private XMLSourceCodec codec = new XMLSourceCodec();

    protected Object deserializeContent(Object object) {
        MimeMultipart mimeMultipart = (MimeMultipart)object;
        try {
            int n = mimeMultipart.getCount();
            ArrayList<Source> arrayList = new ArrayList<Source>();
            for (int i = 0; i < n; ++i) {
                BodyPart bodyPart = mimeMultipart.getBodyPart(i);
                Object object2 = bodyPart.getContent();
                Source source = (Source)this.codec.deserializeContent(object2);
                arrayList.add(source);
            }
            return arrayList.toArray(new Source[arrayList.size()]);
        }
        catch (MessagingException messagingException) {
            String string = WebServiceLogger.logXMLSourceEncodingMessageException();
            WebServiceLogger.logStackTrace(string, messagingException);
            throw new JAXRPCException("failed to deserialize mime multipart", messagingException);
        }
        catch (IOException iOException) {
            String string = WebServiceLogger.logXMLSourceEncodingIOException();
            WebServiceLogger.logStackTrace(string, iOException);
            throw new JAXRPCException("failed to deserialize mime multipart", iOException);
        }
    }

    protected String getContentType() {
        return "multipart/*";
    }

    protected Object serializeContent(Object object) {
        if (!(object instanceof Source[])) {
            throw new JAXRPCException("input is not Source[] :" + object);
        }
        Source[] sourceArray = (Source[])object;
        MimeMultipart mimeMultipart = new MimeMultipart();
        for (int i = 0; i < sourceArray.length; ++i) {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            DataHandler dataHandler = new DataHandler(this.codec.serializeContent(sourceArray[i]), "text/xml");
            try {
                mimeBodyPart.setDataHandler(dataHandler);
                mimeMultipart.addBodyPart(mimeBodyPart, i);
                continue;
            }
            catch (MessagingException messagingException) {
                throw new JAXRPCException("failed to set data handler " + messagingException, messagingException);
            }
        }
        return mimeMultipart;
    }
}

