/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.encoding;

import java.io.IOException;
import java.util.ArrayList;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.webservice.encoding.AttachmentCodec;
import weblogic.xml.schema.binding.DeserializationContext;
import weblogic.xml.schema.binding.SerializationContext;
import weblogic.xml.stream.XMLName;

public class MimeMultipartArrayCodec
extends AttachmentCodec {
    private static final boolean debug = true;
    private static final boolean verbose = true;

    protected String getContentType() {
        throw new Error("should not be called");
    }

    protected Object serializeContent(Object object) {
        throw new Error("should not be called");
    }

    protected Object deserializeContent(Object object) {
        throw new Error("should not be called");
    }

    protected Object deserialize(XMLName xMLName, SOAPMessage sOAPMessage, DeserializationContext deserializationContext) {
        AttachmentPart attachmentPart = this.getAttachmentPart(xMLName, sOAPMessage, deserializationContext);
        if (attachmentPart == null) {
            return null;
        }
        try {
            MimeMultipart mimeMultipart = (MimeMultipart)attachmentPart.getContent();
            int n = mimeMultipart.getCount();
            ArrayList<MimeMultipart> arrayList = new ArrayList<MimeMultipart>();
            for (int i = 0; i < n; ++i) {
                BodyPart bodyPart = mimeMultipart.getBodyPart(i);
                Object object = bodyPart.getContent();
                MimeMultipart mimeMultipart2 = (MimeMultipart)object;
                arrayList.add(mimeMultipart2);
            }
            return arrayList.toArray(new MimeMultipart[arrayList.size()]);
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException("failed to deserialize:" + attachmentPart, sOAPException);
        }
        catch (MessagingException messagingException) {
            throw new JAXRPCException("failed to deserialize mime multipart", messagingException);
        }
        catch (IOException iOException) {
            throw new JAXRPCException("failed to deserialize mime multipart", iOException);
        }
    }

    protected void serialize(Object object, XMLName xMLName, SOAPMessage sOAPMessage, SerializationContext serializationContext) throws SOAPFaultException {
        ArrayList arrayList = new ArrayList();
        try {
            this.addBodyElement(xMLName, sOAPMessage);
            if (object != null) {
                MimeMultipart[] mimeMultipartArray = (MimeMultipart[])object;
                MimeMultipart mimeMultipart = new MimeMultipart();
                for (int i = 0; i < mimeMultipartArray.length; ++i) {
                    MimeBodyPart mimeBodyPart = new MimeBodyPart();
                    mimeBodyPart.setContent(mimeMultipartArray[i]);
                    mimeBodyPart.addHeader("Content-Type", mimeMultipartArray[i].getContentType());
                    mimeMultipart.addBodyPart(mimeBodyPart);
                }
                AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart();
                attachmentPart.setContent(mimeMultipart, "multipart/*");
                attachmentPart.setContentId("<" + xMLName.getLocalName() + ">");
                attachmentPart.setMimeHeader("Content-Type", mimeMultipart.getContentType());
                sOAPMessage.addAttachmentPart(attachmentPart);
            }
        }
        catch (MessagingException messagingException) {
            throw new JAXRPCException("failed to serialize mime multipart", messagingException);
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException("failed to serialize mime multipart", sOAPException);
        }
    }
}

