/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.encoding;

import java.awt.Image;
import java.awt.Panel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import javax.xml.rpc.JAXRPCException;
import weblogic.utils.encoders.BASE64Encoder;
import weblogic.utils.encoders.CharacterEncoder;
import weblogic.webservice.encoding.AttachmentCodec;
import weblogic.xml.schema.types.XSDBase64Binary;

public class ImageCodec
extends AttachmentCodec {
    protected Object deserializeContent(Object object) {
        if (object == null) {
            return null;
        }
        try {
            String string = (String)object;
            byte[] byArray = XSDBase64Binary.convertXml(string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            int n = objectInputStream.readInt();
            int n2 = objectInputStream.readInt();
            int[] nArray = (int[])objectInputStream.readObject();
            MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, nArray, 0, n);
            Panel panel = new Panel();
            Image image = panel.createImage(memoryImageSource);
            return image;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JAXRPCException(classNotFoundException);
        }
        catch (OptionalDataException optionalDataException) {
            throw new JAXRPCException(optionalDataException);
        }
        catch (IOException iOException) {
            throw new JAXRPCException(iOException);
        }
    }

    protected String getContentType() {
        return "text/xml";
    }

    protected Object serializeContent(Object object) {
        Object object2;
        Image image = null;
        if (!(object instanceof Image)) {
            throw new JAXRPCException("Dont know how to serialize:" + object);
        }
        image = (Image)object;
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int[] nArray = (int[])pixelGrabber.getPixels();
        int n = pixelGrabber.getWidth();
        int n2 = pixelGrabber.getHeight();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object2 = new ObjectOutputStream(byteArrayOutputStream);
            ((ObjectOutputStream)object2).writeInt(n);
            ((ObjectOutputStream)object2).writeInt(n2);
            ((ObjectOutputStream)object2).writeObject(nArray);
        }
        catch (IOException iOException) {
            throw new JAXRPCException("failed to serialize:" + iOException, iOException);
        }
        object2 = new BASE64Encoder();
        return ((CharacterEncoder)object2).encodeBuffer(byteArrayOutputStream.toByteArray());
    }
}

