/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.encoding;

import javax.activation.DataHandler;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.webservice.encoding.AttachmentCodec;
import weblogic.xml.schema.binding.DeserializationContext;
import weblogic.xml.schema.binding.SerializationContext;
import weblogic.xml.stream.XMLName;

public class DataHandlerCodec
extends AttachmentCodec {
    protected String getContentType() {
        throw new Error("should not be called");
    }

    protected Object serializeContent(Object object) {
        throw new Error("should not be called");
    }

    protected Object deserializeContent(Object object) {
        throw new Error("should not be called");
    }

    protected Object deserialize(XMLName xMLName, SOAPMessage sOAPMessage, DeserializationContext deserializationContext) throws JAXRPCException {
        AttachmentPart attachmentPart = this.getAttachmentPart(xMLName, sOAPMessage, deserializationContext);
        if (attachmentPart == null) {
            return null;
        }
        try {
            DataHandler dataHandler = attachmentPart.getDataHandler();
            return dataHandler;
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException("unable to deserialize", sOAPException);
        }
    }

    protected void serialize(Object object, XMLName xMLName, SOAPMessage sOAPMessage, SerializationContext serializationContext) throws SOAPFaultException {
        try {
            this.addBodyElement(xMLName, sOAPMessage);
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException("failed to serialize the attachment " + xMLName, sOAPException);
        }
        if (object == null) {
            return;
        }
        DataHandler dataHandler = (DataHandler)object;
        AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart();
        attachmentPart.setDataHandler(dataHandler);
        attachmentPart.setContentId("<" + xMLName.getLocalName() + ">");
        attachmentPart.addMimeHeader("Content-Type", dataHandler.getContentType());
        sOAPMessage.addAttachmentPart(attachmentPart);
    }
}

