/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.encoding;

import java.util.Iterator;
import javax.mail.internet.MimeMultipart;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.webservice.encoding.AbstractCodec;
import weblogic.xml.schema.binding.DeserializationContext;
import weblogic.xml.schema.binding.DeserializationException;
import weblogic.xml.schema.binding.SerializationContext;
import weblogic.xml.schema.binding.SerializationException;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;

public abstract class AttachmentCodec
extends AbstractCodec {
    protected Object deserialize(XMLName xMLName, SOAPMessage sOAPMessage, DeserializationContext deserializationContext) throws JAXRPCException {
        AttachmentPart attachmentPart = this.getAttachmentPart(xMLName, sOAPMessage, deserializationContext);
        if (attachmentPart == null) {
            return null;
        }
        try {
            return this.deserializeContent(attachmentPart.getContent());
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException("failed to deserialize:" + attachmentPart, sOAPException);
        }
    }

    protected abstract Object deserializeContent(Object var1);

    private SOAPElement getFirstChild(SOAPElement sOAPElement) throws SOAPException {
        Iterator iterator = sOAPElement.getChildElements();
        if (iterator.hasNext()) {
            return (SOAPElement)iterator.next();
        }
        return null;
    }

    protected void addBodyElement(XMLName xMLName, SOAPMessage sOAPMessage) throws SOAPException {
        SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
        String string = xMLName.getPrefix();
        String string2 = xMLName.getNamespaceUri();
        if (string2 != null) {
            string = string == null ? "ns" : string;
        }
        Name name = sOAPEnvelope.createName(xMLName.getLocalName(), string, string2);
        SOAPBody sOAPBody = sOAPEnvelope.getBody();
        SOAPElement sOAPElement = this.getFirstChild(sOAPBody);
        if (sOAPElement == null) {
            sOAPElement = sOAPBody.addChildElement(name);
        } else {
            sOAPElement.addChildElement(name);
        }
        Name name2 = sOAPEnvelope.createName("href");
        sOAPElement.addAttribute(name2, "cid:" + xMLName.getLocalName());
    }

    protected void serialize(Object object, XMLName xMLName, SOAPMessage sOAPMessage, SerializationContext serializationContext) throws SOAPFaultException {
        try {
            this.addBodyElement(xMLName, sOAPMessage);
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException("failed to serialize the attachment " + xMLName, sOAPException);
        }
        if (object == null) {
            return;
        }
        Object object2 = this.serializeContent(object);
        AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart();
        attachmentPart.setContent(object2, this.getContentType());
        attachmentPart.setContentId("<" + xMLName.getLocalName() + ">");
        if (object2 instanceof MimeMultipart) {
            attachmentPart.setMimeHeader("Content-Type", ((MimeMultipart)object2).getContentType());
        }
        sOAPMessage.addAttachmentPart(attachmentPart);
    }

    protected abstract Object serializeContent(Object var1);

    protected abstract String getContentType();

    protected AttachmentPart getAttachmentPart(XMLName xMLName, SOAPMessage sOAPMessage, DeserializationContext deserializationContext) {
        Object object;
        SOAPElement sOAPElement = deserializationContext.getSOAPElement();
        String string = null;
        if (sOAPElement != null) {
            try {
                object = sOAPMessage.getSOAPPart().getEnvelope();
                Name name = object.createName("href");
                string = this.cleanHrefId(sOAPElement.getAttributeValue(name));
            }
            catch (SOAPException sOAPException) {
                throw new JAXRPCException(sOAPException);
            }
        }
        object = null;
        if (string != null) {
            object = this.getAttachmentPartFromName(string, sOAPMessage);
        }
        if (object == null) {
            object = this.getAttachmentPartFromName(xMLName.getLocalName(), sOAPMessage);
        }
        return object;
    }

    private String cleanHrefId(String string) {
        if (string != null && string.startsWith("cid:")) {
            string = string.substring("cid:".length(), string.length());
        }
        return string;
    }

    private AttachmentPart getAttachmentPartFromName(String string, SOAPMessage sOAPMessage) {
        Iterator iterator = sOAPMessage.getAttachments();
        while (iterator.hasNext()) {
            AttachmentPart attachmentPart = (AttachmentPart)iterator.next();
            if (string.equals(attachmentPart.getContentId())) {
                return attachmentPart;
            }
            if (!string.equals(this.cleanId(attachmentPart.getContentId()))) continue;
            return attachmentPart;
        }
        return null;
    }

    private String cleanId(String string) {
        if (string != null && string.startsWith("<")) {
            string = string.substring(1, string.length());
        }
        if (string != null && string.endsWith(">")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public final Object deserialize(XMLName xMLName, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException {
        SOAPMessage sOAPMessage = deserializationContext.getSOAPMessage();
        if (sOAPMessage == null) {
            throw new DeserializationException("Unable to find message inside the DeserializationContext");
        }
        return this.deserialize(xMLName, sOAPMessage, deserializationContext);
    }

    public final Object deserialize(XMLName xMLName, Attribute attribute, DeserializationContext deserializationContext) throws DeserializationException {
        throw new DeserializationException("SOAPElementCodec does not support Attribute deserialization");
    }

    public final void serialize(Object object, XMLName xMLName, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        SOAPMessage sOAPMessage = serializationContext.getSOAPMessage();
        if (sOAPMessage == null) {
            throw new SerializationException("Unable to find message inside the SerializationContext");
        }
        this.serialize(object, xMLName, sOAPMessage, serializationContext);
    }
}

