/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core.soap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.ParseException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import weblogic.utils.AssertionError;
import weblogic.utils.CharsetMap;
import weblogic.utils.StackTraceUtils;
import weblogic.webservice.WLSOAPMessage;
import weblogic.webservice.WebServiceLogger;
import weblogic.webservice.core.soap.AttachmentPartImpl;
import weblogic.webservice.core.soap.SOAPMessageImpl;
import weblogic.webservice.core.soap.SOAPPartImpl;
import weblogic.xml.babel.reader.XmlReader;

public class SOAPMessageImpl
extends SOAPMessage
implements WLSOAPMessage {
    private String contentDescription;
    private SOAPPartImpl soapPart;
    private MimeHeaders headers;
    private List attachmentParts = new ArrayList();
    private boolean saveRequired = true;
    private static final boolean debug = false;
    private static final String CONTENT_TYPE = "Content-Type";
    private static final int SOAP11 = 0;
    private static final int SOAP12 = 1;
    private MimeMultipart __dont_touch_mimeMessage;
    private String contentType;
    private String charset;
    private int soapVersion = 0;
    private static String defaultCharset = System.getProperty("weblogic.webservice.i18n.charset");
    private static String language = System.getProperty("user.language");

    SOAPMessageImpl() {
        this.headers = new MimeHeaders();
        this.headers.addHeader(CONTENT_TYPE, "text/xml");
    }

    SOAPMessageImpl(MimeHeaders mimeHeaders, InputStream inputStream) throws SOAPException, IOException {
        this.headers = mimeHeaders;
        ContentType contentType = null;
        contentType = this.headers == null ? SOAPMessageImpl.getDefaultContentType() : this.getContentType(this.headers);
        String string = contentType.getBaseType();
        if ("text/xml".equalsIgnoreCase(string)) {
            String string2 = "US-ASCII";
            String string3 = contentType.getParameter("charset");
            if (string3 != null) {
                string2 = CharsetMap.getJavaFromIANA(string3);
                if (string2 == null) {
                    string2 = string3;
                }
            } else {
                string2 = SOAPMessageImpl.getDefaultContentType().getParameter("charset");
            }
            if (string3 != null) {
                this.setCharset(string3);
            } else {
                this.setCharset(string2);
            }
            this.soapPart = new SOAPPartImpl(this.headers, XmlReader.createReader(inputStream, string2), this);
        } else if ("Multipart/Related".equalsIgnoreCase(string)) {
            this.handleMimeMessage(inputStream, contentType);
        } else if ("application/soap+xml".equalsIgnoreCase(string)) {
            String string4 = null;
            String string5 = contentType.getParameter("charset");
            if (string5 != null) {
                string4 = CharsetMap.getJavaFromIANA(string5);
            }
            this.soapPart = string4 != null ? new SOAPPartImpl(this.headers, XmlReader.createReader(inputStream, string4), this) : new SOAPPartImpl(this.headers, XmlReader.createReader(inputStream), this);
            if (string5 != null) {
                this.setCharset(string5);
            } else {
                this.setCharset("UTF-8");
            }
            this.setSOAP12();
        } else {
            throw new SOAPException("Unsupported Content-Type: " + string);
        }
    }

    private static ContentType getDefaultContentType() {
        ContentType contentType;
        try {
            contentType = new ContentType("text/xml");
        }
        catch (ParseException parseException) {
            String string = WebServiceLogger.logSoapMessageContentException();
            WebServiceLogger.logStackTrace(string, parseException);
            throw new AssertionError(parseException);
        }
        return contentType;
    }

    private ContentType getContentType(MimeHeaders mimeHeaders) throws SOAPException {
        String[] stringArray = mimeHeaders.getHeader(CONTENT_TYPE);
        if (stringArray == null || stringArray.length == 0) {
            throw new SOAPException("There was no Content-Type header");
        }
        if (stringArray.length > 1) {
            throw new SOAPException("There should be only one Content-Type MimeHeader");
        }
        try {
            return new ContentType(stringArray[0]);
        }
        catch (ParseException parseException) {
            String string = WebServiceLogger.logSoapMessageGetContentException();
            WebServiceLogger.logStackTrace(string, parseException);
            throw new SOAPException("Error parsing Content-Type header:" + stringArray[0], parseException);
        }
    }

    private void handleMimeMessage(InputStream inputStream, ContentType contentType) throws SOAPException, IOException {
        String string = contentType.getParameter("start");
        if (string == null) {
            // empty if block
        }
        try {
            InputStreamDataSource inputStreamDataSource = new InputStreamDataSource(this, inputStream);
            MimeMultipart mimeMultipart = new MimeMultipart((DataSource)inputStreamDataSource);
            mimeMultipart.setContentType(contentType.toString());
            boolean bl = false;
            for (int i = 0; i < mimeMultipart.getCount(); ++i) {
                BodyPart bodyPart = mimeMultipart.getBodyPart(i);
                if (i == 0) {
                    if (bl) {
                        throw new SOAPException("Found > 1 attachments with the same content id as the start: " + string);
                    }
                    bl = true;
                    this.soapPart = new SOAPPartImpl(this.createMimeHeaders(bodyPart), XmlReader.createReader(bodyPart.getInputStream()), this);
                    continue;
                }
                AttachmentPart attachmentPart = this.createAttachmentPart(bodyPart);
                this.addAttachmentPart(attachmentPart);
            }
        }
        catch (MessagingException messagingException) {
            String string2 = WebServiceLogger.logSoapMessageMimeException();
            WebServiceLogger.logStackTrace(string2, messagingException);
            throw new SOAPException("Error processing MIME message:", messagingException);
        }
    }

    private MimeHeaders createMimeHeaders(BodyPart bodyPart) throws MessagingException {
        MimeHeaders mimeHeaders = new MimeHeaders();
        Enumeration enumeration = bodyPart.getAllHeaders();
        while (enumeration.hasMoreElements()) {
            Header header = (Header)enumeration.nextElement();
            mimeHeaders.addHeader(header.getName(), header.getValue());
        }
        return mimeHeaders;
    }

    public String getContentDescription() {
        return this.contentDescription;
    }

    public void setContentDescription(String string) {
        this.contentDescription = string;
    }

    public SOAPPart getSOAPPart() {
        if (this.soapPart == null) {
            this.soapPart = new SOAPPartImpl(this);
        }
        return this.soapPart;
    }

    public void removeAllAttachments() {
        this.attachmentParts.clear();
    }

    public int countAttachments() {
        return this.attachmentParts.size();
    }

    public Iterator getAttachments() {
        return this.attachmentParts.iterator();
    }

    private boolean containsAllHeaders(AttachmentPart attachmentPart, MimeHeaders mimeHeaders) {
        Iterator iterator = mimeHeaders.getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            String[] stringArray = attachmentPart.getMimeHeader(mimeHeader.getName());
            if (stringArray == null) {
                return false;
            }
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(mimeHeader.getValue())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public Iterator getAttachments(MimeHeaders mimeHeaders) {
        ArrayList<AttachmentPart> arrayList = new ArrayList<AttachmentPart>();
        Iterator iterator = this.attachmentParts.iterator();
        while (iterator.hasNext()) {
            AttachmentPart attachmentPart = (AttachmentPart)iterator.next();
            if (!this.containsAllHeaders(attachmentPart, mimeHeaders)) continue;
            arrayList.add(attachmentPart);
        }
        return arrayList.iterator();
    }

    public void addAttachmentPart(AttachmentPart attachmentPart) {
        this.attachmentParts.add(attachmentPart);
    }

    public AttachmentPart createAttachmentPart() {
        return new AttachmentPartImpl();
    }

    public AttachmentPart createAttachmentPart(BodyPart bodyPart) throws MessagingException {
        AttachmentPartImpl attachmentPartImpl = new AttachmentPartImpl();
        ((AttachmentPart)attachmentPartImpl).setDataHandler(bodyPart.getDataHandler());
        Enumeration enumeration = bodyPart.getAllHeaders();
        while (enumeration.hasMoreElements()) {
            Header header = (Header)enumeration.nextElement();
            ((AttachmentPart)attachmentPartImpl).addMimeHeader(header.getName(), header.getValue());
        }
        return attachmentPartImpl;
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public void saveChanges() throws SOAPException {
        this.saveRequired = false;
    }

    public boolean saveRequired() {
        return this.saveRequired;
    }

    private MimeMultipart getMimeMessage() {
        if (this.__dont_touch_mimeMessage == null) {
            this.__dont_touch_mimeMessage = new MimeMultipart("related");
            try {
                ContentType contentType = new ContentType(this.__dont_touch_mimeMessage.getContentType());
                String string = "multipart/related;type=\"text/xml\";boundary=\"" + contentType.getParameter("boundary") + "\";start=" + this.soapPart.getContentId();
                this.__dont_touch_mimeMessage.setContentType(string);
                this.headers.setHeader(CONTENT_TYPE, string);
            }
            catch (ParseException parseException) {
                throw new AssertionError(parseException);
            }
        }
        return this.__dont_touch_mimeMessage;
    }

    public boolean isSOAP12() {
        return this.soapVersion == 1;
    }

    public void setSOAP12() {
        this.soapVersion = 1;
    }

    public void setSOAP11() {
        this.soapVersion = 0;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public String getCharset() {
        if (this.charset == null) {
            this.charset = defaultCharset != null && defaultCharset.length() != 0 ? defaultCharset : ("en".equalsIgnoreCase(language) ? null : "utf-8");
        }
        return this.charset;
    }

    public String getContentType() {
        if (this.contentType == null) {
            if (this.countAttachments() == 0) {
                this.contentType = this.isSOAP12() ? "application/soap+xml" : "text/xml";
            } else {
                MimeMultipart mimeMultipart = this.getMimeMessage();
                this.contentType = mimeMultipart.getContentType();
            }
        }
        return this.contentType;
    }

    public void writeTo(OutputStream outputStream) throws SOAPException, IOException {
        if (this.soapPart == null) {
            this.getSOAPPart();
        }
        if (this.attachmentParts.isEmpty()) {
            this.soapPart.writeTo(outputStream);
        } else {
            try {
                this.writeMimeMessage(outputStream);
            }
            catch (MessagingException messagingException) {
                String string = WebServiceLogger.logSoapMessageWriteMimeException();
                WebServiceLogger.logStackTrace(string, messagingException);
                throw new IOException(StackTraceUtils.throwable2StackTrace(messagingException));
            }
        }
    }

    private MimeBodyPart createMimeBodyPart(AttachmentPart attachmentPart) throws MessagingException, SOAPException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setDataHandler(attachmentPart.getDataHandler());
        Iterator iterator = attachmentPart.getAllMimeHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            mimeBodyPart.addHeader(mimeHeader.getName(), mimeHeader.getValue());
        }
        return mimeBodyPart;
    }

    private void writeMimeMessage(OutputStream outputStream) throws SOAPException, IOException, MessagingException {
        outputStream.write(10);
        MimeMultipart mimeMultipart = this.getMimeMessage();
        int n = 0;
        InternetHeaders internetHeaders = new InternetHeaders();
        internetHeaders.addHeader(CONTENT_TYPE, "text/xml; charset='utf-8'");
        internetHeaders.addHeader("Content-ID", this.soapPart.getContentId());
        internetHeaders.addHeader("Content-Transfer-Encoding", "8bit");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.soapPart.writeTo(byteArrayOutputStream);
        MimeBodyPart mimeBodyPart = new MimeBodyPart(internetHeaders, byteArrayOutputStream.toByteArray());
        mimeMultipart.addBodyPart(mimeBodyPart, n++);
        Iterator iterator = this.attachmentParts.iterator();
        while (iterator.hasNext()) {
            AttachmentPart attachmentPart = (AttachmentPart)iterator.next();
            mimeBodyPart = this.createMimeBodyPart(attachmentPart);
            mimeMultipart.addBodyPart(mimeBodyPart, n++);
        }
        mimeMultipart.writeTo(outputStream);
    }

    public String toString() {
        return "SOAPMessageImpl[" + this.soapPart + "]";
    }

    private static class MimeMultipart
    extends javax.mail.internet.MimeMultipart {
        public MimeMultipart() {
        }

        public MimeMultipart(String string) {
            super(string);
        }

        public MimeMultipart(DataSource dataSource) throws MessagingException {
            super(dataSource);
        }

        void setContentType(String string) {
            this.contentType = string;
        }
    }
}

