/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core.soap;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import weblogic.utils.NestedRuntimeException;
import weblogic.utils.StackTraceUtils;
import weblogic.webservice.WebServiceLogger;
import weblogic.webservice.core.soap.NameImpl;
import weblogic.webservice.core.soap.SOAPBodyImpl;
import weblogic.webservice.core.soap.SOAPElementImpl;
import weblogic.webservice.core.soap.SOAPHeaderImpl;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.stream.ElementFilter;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.util.RecyclingFactory;
import weblogic.xml.stream.util.TypeFilter;
import weblogic.xml.xmlnode.NodeBuilder;
import weblogic.xml.xmlnode.XMLNode;
import weblogic.xml.xmlnode.XMLNodeException;

public class SOAPEnvelopeImpl
extends SOAPElementImpl
implements SOAPEnvelope {
    private static final RecyclingFactory pool = new RecyclingFactory();
    private static final boolean debug = false;
    private static final String SCHEMA_PREFIX = "xsd";
    private static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static final String SCHEMA_INSTANCE_PREFIX = "xsi";
    private static final String SOAPENC_PREFIX = "soapenc";
    private static final String SCHEMA_INSTANCE_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private SOAPBodyImpl body;
    private SOAPHeaderImpl header;
    private String soapNS;

    SOAPEnvelopeImpl(String string, String string2) throws SOAPException {
        super(new NameImpl("Envelope", ENV_PREFIX, string));
        this.soapNS = string;
        this.addNamespaceDeclaration(ENV_PREFIX, string);
        this.addNamespaceDeclaration(SCHEMA_PREFIX, SCHEMA_NS);
        this.addNamespaceDeclaration(SCHEMA_INSTANCE_PREFIX, SCHEMA_INSTANCE_NS);
        this.addNamespaceDeclaration(SOAPENC_PREFIX, string2);
        this.header = new SOAPHeaderImpl(string, ENV_PREFIX);
        this.body = new SOAPBodyImpl(string);
        this.addChild(this.header);
        this.addChild(this.body);
    }

    SOAPEnvelopeImpl(InputStream inputStream) throws IOException, SOAPException {
        TypeFilter typeFilter = new TypeFilter(86);
        XMLInputStream xMLInputStream = pool.remove(inputStream, (ElementFilter)typeFilter);
        this.processXMLInputStream(xMLInputStream);
        pool.add(xMLInputStream);
    }

    SOAPEnvelopeImpl(XMLInputStream xMLInputStream) throws IOException {
        this.processXMLInputStream(xMLInputStream);
    }

    SOAPEnvelopeImpl(Reader reader) throws IOException, SOAPException {
        try {
            NodeBuilder nodeBuilder = new NodeBuilder((XMLNode)this, reader);
        }
        catch (XMLNodeException xMLNodeException) {
            throw new SOAPException("Faild to build xml node: " + xMLNodeException, xMLNodeException);
        }
        catch (ParseException parseException) {
            throw new SOAPException("Faild to build xml node: " + parseException, parseException);
        }
        catch (ScannerException scannerException) {
            throw new SOAPException("Faild to build xml node: " + scannerException, scannerException);
        }
    }

    private void processXMLInputStream(XMLInputStream xMLInputStream) throws IOException {
        try {
            xMLInputStream.skip(2);
            this.read(xMLInputStream);
        }
        catch (NestedRuntimeException nestedRuntimeException) {
            Throwable throwable = nestedRuntimeException.getNestedException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            String string = WebServiceLogger.logSoapEnvelopeInputException();
            WebServiceLogger.logStackTrace(string, throwable);
            throw new IOException("Unexpected Error: " + StackTraceUtils.throwable2StackTrace(throwable));
        }
    }

    public Name createName(String string, String string2, String string3) throws SOAPException {
        return new NameImpl(string, string2, string3);
    }

    public Name createName(String string, String string2) throws SOAPException {
        return new NameImpl(string, string2, null);
    }

    public Name createName(String string) throws SOAPException {
        return new NameImpl(string);
    }

    public SOAPHeader getHeader() throws SOAPException {
        return this.header;
    }

    public SOAPBody getBody() throws SOAPException {
        return this.body;
    }

    public SOAPHeader addHeader() throws SOAPException {
        if (this.header != null) {
            throw new SOAPException("header already exist");
        }
        this.header = new SOAPHeaderImpl(this.soapNS, this.getElementName().getPrefix());
        this.insertChild(this.header, 0);
        return this.header;
    }

    public SOAPBody addBody() throws SOAPException {
        if (this.body != null) {
            throw new SOAPException("body already exist");
        }
        this.body = new SOAPBodyImpl(this.soapNS);
        return this.body;
    }

    public void removeChild(XMLNode xMLNode) {
        super.removeChild(xMLNode);
        if (xMLNode instanceof SOAPBody) {
            this.body = null;
        } else if (xMLNode instanceof SOAPHeader) {
            this.header = null;
        } else {
            throw new IllegalArgumentException("child removed is not a header or body");
        }
    }

    protected XMLNode createChild(XMLName xMLName) {
        if ("Body".equals(xMLName.getLocalName())) {
            this.body = new SOAPBodyImpl(this.soapNS);
            return this.body;
        }
        if ("Header".equals(xMLName.getLocalName())) {
            this.header = new SOAPHeaderImpl(this.soapNS, this.getElementName().getPrefix());
            return this.header;
        }
        throw new NestedRuntimeException(new IOException("The InputStream did not contain a valid SOAP message."));
    }

    public String toString() {
        return "SOAPEnvelopeImpl[" + this.header + this.body + "]";
    }
}

