/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core.handler;

import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import weblogic.webservice.core.handler.ConversationContext;

public class ConversationUtil {
    public static final String CONVERSATION_NAMESPACE = "http://www.openuri.org/2002/04/soap/conversation/";
    public static final String START_HEADER = "StartHeader";
    public static final String CONTINUE_HEADER = "ContinueHeader";
    public static final String CALLBACK_HEADER = "CallbackHeader";
    public static final String FINISH_HEADER = "FinishHeader";
    public static final String CONVERSATION_ID = "conversationID";
    public static final String CALLBACK_LOCATION = "callbackLocation";
    public static final String PREFIX = "con";
    private String conversationID;
    private String callbackLocation;
    private String headerType;
    private SOAPHeader header;
    private SOAPEnvelope envelope;
    private boolean processed = false;

    public ConversationUtil(SOAPEnvelope sOAPEnvelope) throws SOAPException {
        this.envelope = sOAPEnvelope;
        this.header = sOAPEnvelope.getHeader();
    }

    public ConversationContext createContext() throws SOAPException {
        if (!this.processed) {
            this.process();
        }
        if (this.conversationID == null && this.callbackLocation == null && this.headerType == null) {
            return null;
        }
        ConversationContext conversationContext = new ConversationContext();
        conversationContext.setConversationID(this.conversationID);
        conversationContext.setCallbackLocation(this.callbackLocation);
        conversationContext.setHeaderType(this.headerType);
        return conversationContext;
    }

    public void addToHeader(ConversationContext conversationContext) throws SOAPException {
        SOAPElement sOAPElement;
        this.headerType = conversationContext.getHeaderType();
        this.conversationID = conversationContext.getConversationID();
        this.callbackLocation = conversationContext.getCallbackLocation();
        if (this.header == null) {
            this.header = this.envelope.addHeader();
        }
        if (this.headerType == FINISH_HEADER) {
            this.headerType = CONTINUE_HEADER;
        }
        this.header.addNamespaceDeclaration(PREFIX, CONVERSATION_NAMESPACE);
        Name name = this.envelope.createName(this.headerType, PREFIX, CONVERSATION_NAMESPACE);
        Object object = this.header.getChildElements(name);
        while (object.hasNext()) {
            ((SOAPElement)object.next()).detachNode();
        }
        object = this.header.addHeaderElement(name);
        if (conversationContext.getConversationID() != null) {
            sOAPElement = object.addChildElement(CONVERSATION_ID, PREFIX);
            sOAPElement.addTextNode(conversationContext.getConversationID());
        }
        if (conversationContext.getCallbackLocation() != null) {
            sOAPElement = object.addChildElement(CALLBACK_LOCATION, PREFIX);
            sOAPElement.addTextNode(conversationContext.getCallbackLocation());
        }
    }

    private void process() throws SOAPException {
        Name name = this.envelope.createName(CONTINUE_HEADER, "junk", CONVERSATION_NAMESPACE);
        Iterator iterator = this.header.getChildElements(name);
        if (iterator.hasNext()) {
            this.processContinueHeader((SOAPElement)iterator.next());
            this.headerType = CONTINUE_HEADER;
            this.processed = true;
            return;
        }
        name = this.envelope.createName(START_HEADER, "junk", CONVERSATION_NAMESPACE);
        iterator = this.header.getChildElements(name);
        if (iterator.hasNext()) {
            this.processStartHeader((SOAPElement)iterator.next());
            this.headerType = START_HEADER;
            this.processed = true;
            return;
        }
        name = this.envelope.createName(FINISH_HEADER, "junk", CONVERSATION_NAMESPACE);
        iterator = this.header.getChildElements(name);
        if (iterator.hasNext()) {
            this.processFinishHeader((SOAPElement)iterator.next());
            this.headerType = FINISH_HEADER;
            this.processed = true;
            return;
        }
        name = this.envelope.createName(CALLBACK_HEADER, "junk", CONVERSATION_NAMESPACE);
        iterator = this.header.getChildElements(name);
        if (iterator.hasNext()) {
            this.processCallbackHeader((SOAPElement)iterator.next());
            this.headerType = CALLBACK_HEADER;
            this.processed = true;
            return;
        }
        this.processed = true;
    }

    private void processStartHeader(SOAPElement sOAPElement) throws SOAPException {
        Iterator iterator = sOAPElement.getChildElements();
        while (iterator.hasNext()) {
            SOAPElement sOAPElement2 = (SOAPElement)iterator.next();
            if (sOAPElement2.getElementName().getLocalName().equals(CONVERSATION_ID)) {
                this.conversationID = sOAPElement2.getValue();
                continue;
            }
            if (!sOAPElement2.getElementName().getLocalName().equals(CALLBACK_LOCATION)) continue;
            this.callbackLocation = sOAPElement2.getValue();
        }
        sOAPElement.detachNode();
    }

    private void processFinishHeader(SOAPElement sOAPElement) throws SOAPException {
        Iterator iterator = sOAPElement.getChildElements();
        while (iterator.hasNext()) {
            SOAPElement sOAPElement2 = (SOAPElement)iterator.next();
            if (!sOAPElement2.getElementName().getLocalName().equals(CONVERSATION_ID)) continue;
            this.conversationID = sOAPElement2.getValue();
        }
        sOAPElement.detachNode();
    }

    private void processContinueHeader(SOAPElement sOAPElement) throws SOAPException {
        Iterator iterator = sOAPElement.getChildElements();
        while (iterator.hasNext()) {
            SOAPElement sOAPElement2 = (SOAPElement)iterator.next();
            if (!sOAPElement2.getElementName().getLocalName().equals(CONVERSATION_ID)) continue;
            this.conversationID = sOAPElement2.getValue();
        }
        sOAPElement.detachNode();
    }

    private void processCallbackHeader(SOAPElement sOAPElement) throws SOAPException {
        Iterator iterator = sOAPElement.getChildElements();
        while (iterator.hasNext()) {
            SOAPElement sOAPElement2 = (SOAPElement)iterator.next();
            if (!sOAPElement2.getElementName().getLocalName().equals(CALLBACK_LOCATION)) continue;
            this.conversationID = sOAPElement2.getValue();
        }
        sOAPElement.detachNode();
    }
}

