/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core.handler;

import java.io.IOException;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPException;
import weblogic.webservice.GenericHandler;
import weblogic.webservice.WLMessageContext;
import weblogic.webservice.WebServiceLogger;
import weblogic.webservice.binding.Binding;
import weblogic.webservice.util.FaultUtil;

public final class ClientHandler
extends GenericHandler {
    private static final boolean debug = true;

    public boolean handleRequest(MessageContext messageContext) {
        Binding binding = (Binding)messageContext.getProperty("__BEA_PRIVATE_BINDING_PROP");
        try {
            binding.send((WLMessageContext)messageContext);
        }
        catch (IOException iOException) {
            String string = WebServiceLogger.logJAXMClientHandlerException();
            WebServiceLogger.logStackTrace(string, iOException);
            FaultUtil.throwSOAPFaultException("Client", "Failed to send request", iOException);
        }
        catch (SOAPException sOAPException) {
            FaultUtil.throwSOAPFaultException("Client", "Failed to send request", sOAPException);
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        Binding binding = (Binding)messageContext.getProperty("__BEA_PRIVATE_BINDING_PROP");
        try {
            WLMessageContext wLMessageContext = (WLMessageContext)messageContext;
            binding.receive(wLMessageContext);
        }
        catch (IOException iOException) {
            throw new JAXRPCException(iOException);
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException(sOAPException);
        }
        return true;
    }
}

