/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core.encoding;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.encoding.TypeMapping;
import weblogic.webservice.client.SSLAdapterFactory;
import weblogic.webservice.core.encoding.TypeMappingRegistryImpl;
import weblogic.xml.schema.binding.TypeMappingFactory;
import weblogic.xml.schema.binding.internal.TypeMappingBase;
import weblogic.xml.schema.binding.util.StdNamespace;

public final class DefaultRegistry
extends TypeMappingRegistryImpl {
    private static final String SOAP12_ENC = "http://www.w3.org/2003/05/soap-encoding";

    public DefaultRegistry(String string) throws IOException, JAXRPCException {
        this();
        Object object;
        URL uRL;
        String string2 = string.replace('.', '/') + ".xml";
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if ((uRL = classLoader.getResource(string2)) == null) {
            uRL = this.getClass().getResource(string2);
        }
        InputStream inputStream = null;
        if (uRL != null) {
            if ("https".equalsIgnoreCase(uRL.getProtocol())) {
                object = SSLAdapterFactory.getDefaultFactory().getSSLAdapter();
                inputStream = object.openConnection(uRL).getInputStream();
            } else {
                inputStream = uRL.openStream();
            }
        } else {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (IOException iOException) {
                throw new IOException("unable to find the type mapping resource file for:" + string);
            }
        }
        object = (TypeMappingBase)this.getTypeMapping(StdNamespace.instance().soapEncoding());
        ((TypeMappingBase)object).readXML(inputStream);
        inputStream.close();
    }

    public DefaultRegistry() throws JAXRPCException {
        TypeMappingFactory typeMappingFactory = TypeMappingFactory.newInstance();
        TypeMapping typeMapping = (TypeMapping)((Object)typeMappingFactory.createDefaultMapping());
        this.register(typeMapping, new String[]{StdNamespace.instance().soapEncoding()});
        this.register(typeMapping, new String[]{SOAP12_ENC});
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[ registerd encodingStyle = ");
        String[] stringArray = this.getRegisteredNamespaces();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

