/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.xml.rpc.JAXRPCException;
import weblogic.webservice.Message;
import weblogic.webservice.Operation;
import weblogic.webservice.Part;
import weblogic.webservice.Port;
import weblogic.webservice.util.ExceptionUtil;
import weblogic.xml.schema.binding.internal.NameUtil;

public class PortMapper {
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;

    public void mapInterfaceToPort(Class clazz, Port port) throws JAXRPCException {
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            Operation operation = this.getOperation(port, method.getName());
            if (operation == null) {
                if (method.getName().startsWith("end") || method.getName().startsWith("start")) continue;
                throw new JAXRPCException("unable to find operation[" + method + "] in the given port:" + port);
            }
            this.mapException(method, operation);
            if (!operation.isRpcStyle()) continue;
            this.mapMethodToOperation(method, operation);
        }
    }

    private Operation getOperation(Port port, String string) {
        Operation operation = port.getOperation(string);
        if (operation != null) {
            return operation;
        }
        Iterator iterator = port.getOperations();
        while (iterator.hasNext()) {
            operation = (Operation)iterator.next();
            if (!string.equals(NameUtil.getJAXRPCMethodName(operation.getName()))) continue;
            return operation;
        }
        return null;
    }

    private void mapException(Method method, Operation operation) {
        Iterator iterator = operation.getFaults();
        block0: while (iterator.hasNext()) {
            Message message;
            Part part;
            if ((class$java$lang$Exception == null ? PortMapper.class$("java.lang.Exception") : class$java$lang$Exception).isAssignableFrom((part = (Part)(message = (Message)iterator.next()).getParts().next()).getJavaType())) continue;
            Class<?>[] classArray = method.getExceptionTypes();
            for (int i = 0; i < classArray.length; ++i) {
                Class clazz = ExceptionUtil.getSingleProperty(classArray[i]);
                if (clazz == null || !part.getJavaType().equals(clazz)) continue;
                if (classArray.length > 1) {
                    if (!classArray[i].getName().endsWith(message.getName())) continue;
                    part.setJavaType(classArray[i]);
                    continue block0;
                }
                part.setJavaType(classArray[i]);
                continue block0;
            }
        }
    }

    public void mapMethodToOperation(Method method, Operation operation) {
        Part part;
        Class<?>[] classArray = method.getParameterTypes();
        int n = 0;
        Iterator iterator = operation.getInput().getParts();
        while (iterator.hasNext()) {
            part = (Part)iterator.next();
            if (n >= classArray.length) {
                throw new JAXRPCException("number of params does not match for:" + method);
            }
            Class<?> clazz = classArray[n];
            ++n;
            if (clazz == part.getJavaType()) continue;
            this.mapClassToPart(clazz, part);
        }
        iterator = operation.getOutput().getParts();
        while (iterator.hasNext()) {
            part = (Part)iterator.next();
            if (part.getMode() != Part.Mode.RETURN) continue;
            this.mapClassToPart(method.getReturnType(), part);
        }
    }

    public void mapClassToPart(Class clazz, Part part) {
        part.setJavaType(this.getTypeFromHolder(clazz));
    }

    private Class getTypeFromHolder(Class clazz) {
        if ((class$javax$xml$rpc$holders$Holder == null ? (class$javax$xml$rpc$holders$Holder = PortMapper.class$("javax.xml.rpc.holders.Holder")) : class$javax$xml$rpc$holders$Holder).isAssignableFrom(clazz)) {
            try {
                Field field = clazz.getField("value");
                clazz = field.getType();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new JAXRPCException("no 'value' field defined in the holder class:" + clazz, noSuchFieldException);
            }
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

