/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core;

import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import weblogic.utils.AssertionError;
import weblogic.webservice.HandlerChain;
import weblogic.webservice.TargetInvocationException;
import weblogic.webservice.WLMessageContext;
import weblogic.webservice.WebServiceLogger;
import weblogic.webservice.monitoring.HandlerStats;
import weblogic.webservice.util.FaultUtil;

public class HandlerChainImpl
implements HandlerChain {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    private Handler[] handlers;
    private HandlerStats[] mStats = null;
    private int index;

    public HandlerChainImpl() {
    }

    public HandlerChainImpl(HandlerInfo handlerInfo) {
        this(new HandlerInfo[]{handlerInfo});
    }

    public HandlerChainImpl(HandlerInfo[] handlerInfoArray) {
        this.init(handlerInfoArray);
    }

    public HandlerChainImpl(HandlerInfo[] handlerInfoArray, HandlerStats[] handlerStatsArray) {
        this.init(handlerInfoArray);
        this.mStats = handlerStatsArray;
    }

    public void init(HandlerInfo[] handlerInfoArray) {
        this.handlers = new Handler[handlerInfoArray.length];
        for (int i = 0; i < handlerInfoArray.length; ++i) {
            Class clazz = handlerInfoArray[i].getHandlerClass();
            try {
                this.handlers[i] = (Handler)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                if (this.mStats != null && this.mStats.length > i && this.mStats[i] != null) {
                    this.mStats[i].reportInitError((Throwable)instantiationException);
                }
                throw new JAXRPCException("Exception in handler:" + clazz.getName(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError(illegalAccessException);
            }
            try {
                this.handlers[i].init(handlerInfoArray[i]);
                continue;
            }
            catch (Throwable throwable) {
                int n = i;
                while (--n >= 0) {
                    try {
                        this.handlers[n].destroy();
                    }
                    catch (Throwable throwable2) {}
                }
                if (throwable instanceof JAXRPCException) {
                    throw (JAXRPCException)throwable;
                }
                throw new JAXRPCException("Exception while calling Handler:" + clazz.getName() + "'s init method.", throwable);
            }
        }
    }

    public void destroy() {
        for (int i = 0; i < this.handlers.length; ++i) {
            try {
                this.handlers[i].destroy();
                continue;
            }
            catch (Throwable throwable) {
                WebServiceLogger.logIgnoringDestroyException(this.handlers[i].getClass().getName(), throwable);
            }
        }
    }

    public boolean handleRequest(MessageContext messageContext) {
        this.index = 0;
        while (this.index < this.handlers.length) {
            try {
                if (!this.handlers[this.index].handleRequest(messageContext)) {
                    if (this.mStats != null && this.mStats.length > this.index && this.mStats[this.index] != null) {
                        this.mStats[this.index].reportRequestTermination();
                    }
                    return false;
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof SOAPFaultException)) {
                    WebServiceLogger.logExceptionInRequestHandler(this.handlers[this.index].getClass().getName(), throwable);
                    if (this.mStats != null && this.mStats.length > this.index && this.mStats[this.index] != null) {
                        this.mStats[this.index].reportRequestError(throwable);
                    }
                } else if (this.mStats != null && this.mStats.length > this.index && this.mStats[this.index] != null) {
                    this.mStats[this.index].reportRequestSOAPFault((SOAPFaultException)throwable);
                }
                if (throwable instanceof JAXRPCException && ((JAXRPCException)throwable).getLinkedCause() instanceof TargetInvocationException) {
                    return false;
                }
                ((WLMessageContext)messageContext).setMessage(FaultUtil.exception2Fault(throwable));
                ((WLMessageContext)messageContext).setFault(true);
                messageContext.setProperty("weblogic.webservice.handler.exception", throwable);
                return false;
            }
            ++this.index;
        }
        --this.index;
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        WLMessageContext wLMessageContext = (WLMessageContext)messageContext;
        while (this.index >= 0) {
            if (wLMessageContext.hasFault()) {
                try {
                    if (!this.handlers[this.index].handleFault(messageContext)) {
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    WebServiceLogger.logExceptionInFaultHandler(this.handlers[this.index].getClass().getName(), throwable);
                }
            } else {
                try {
                    if (!this.handlers[this.index].handleResponse(messageContext)) {
                        if (this.mStats != null && this.mStats.length > this.index) {
                            this.mStats[this.index].reportResponseTermination();
                        }
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof SOAPFaultException)) {
                        WebServiceLogger.logExceptionInResponseHandler(this.handlers[this.index].getClass().getName(), throwable);
                        if (this.mStats != null && this.mStats.length > this.index && this.mStats[this.index] != null) {
                            this.mStats[this.index].reportResponseError(throwable);
                        }
                    } else if (this.mStats != null && this.mStats.length > this.index && this.mStats[this.index] != null) {
                        this.mStats[this.index].reportResponseSOAPFault((SOAPFaultException)throwable);
                    }
                    wLMessageContext.setMessage(FaultUtil.exception2Fault(throwable));
                    ((WLMessageContext)messageContext).setFault(true);
                    messageContext.setProperty("weblogic.webservice.handler.exception", throwable);
                }
            }
            --this.index;
        }
        return true;
    }
}

