/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import weblogic.utils.Debug;
import weblogic.webservice.HandlerChain;
import weblogic.webservice.Message;
import weblogic.webservice.Operation;
import weblogic.webservice.Part;
import weblogic.webservice.ReliableDelivery;
import weblogic.webservice.TargetInvocationException;
import weblogic.webservice.WLMessageContext;
import weblogic.webservice.WLSOAPMessage;
import weblogic.webservice.WebServiceLogger;
import weblogic.webservice.async.AsyncInfo;
import weblogic.webservice.async.FutureResult;
import weblogic.webservice.async.FutureResultImpl;
import weblogic.webservice.async.InvokeCompletedEvent;
import weblogic.webservice.async.ThreadPool;
import weblogic.webservice.binding.Binding;
import weblogic.webservice.binding.BindingFactory;
import weblogic.webservice.binding.BindingInfo;
import weblogic.webservice.context.WebServiceContext;
import weblogic.webservice.core.DefaultMessageContext;
import weblogic.webservice.core.DefaultOperation;
import weblogic.webservice.core.soap.NameImpl;
import weblogic.xml.schema.binding.util.StdNamespace;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;

public class ClientDispatcher {
    private static ThreadPool threadPool = null;
    private Operation operation;
    private Map outParams;
    private PrintStream logStream;
    private HandlerChain chain;
    private FutureResultImpl futureResult;
    private AsyncInfo async;
    private WLMessageContext messageContext;
    private WebServiceContext wsContext;

    public ClientDispatcher(Operation operation, Map map, PrintStream printStream) {
        Debug.assertion(operation != null);
        Debug.assertion(map != null);
        this.operation = operation;
        this.outParams = map;
        this.logStream = printStream;
    }

    public synchronized ThreadPool getThreadPool() {
        if (threadPool == null) {
            threadPool = new ThreadPool(2);
        }
        return threadPool;
    }

    public FutureResult asyncDispatch(Object[] objectArray, AsyncInfo asyncInfo) throws SOAPException, IOException {
        this.async = asyncInfo;
        this.futureResult = new FutureResultImpl();
        this.futureResult.setAsyncInfo(asyncInfo);
        this.send(objectArray);
        if (asyncInfo == null || !asyncInfo.isReliableDelivery()) {
            this.getThreadPool().addTask(new Runnable(){

                public void run() {
                    ClientDispatcher.this.callReceive(ClientDispatcher.this.messageContext);
                }
            });
        }
        return this.futureResult;
    }

    public void callReceive(WLMessageContext wLMessageContext) {
        Object object;
        Object object2;
        try {
            object2 = this.receive(wLMessageContext);
            this.futureResult.setResult(object2);
        }
        catch (Throwable throwable) {
            object = WebServiceLogger.logClientDispatcherException();
            WebServiceLogger.logStackTrace((String)object, throwable);
            this.futureResult.setError(throwable);
        }
        if (this.async != null && (object2 = this.async.getResultListener()) != null) {
            object = new InvokeCompletedEvent(this.async.getCaller());
            ((InvokeCompletedEvent)object).setFutureResult(this.futureResult);
            object2.onCompletion((InvokeCompletedEvent)object);
        }
    }

    public Object dispatch(Object[] objectArray) throws SOAPException, IOException, TargetInvocationException {
        this.send(objectArray);
        return this.receive(this.messageContext);
    }

    public void send(Object[] objectArray) throws SOAPException, IOException {
        Object object;
        AsyncInfo asyncInfo;
        this.messageContext = new DefaultMessageContext(this.operation);
        this.messageContext.setProperty("__BEA_PRIVATE_WEBSERVICE_RUNTIME_PROP", this.operation.getPort().getService());
        BindingFactory bindingFactory = BindingFactory.getInstance();
        Binding binding = bindingFactory.create(this.operation.getPort().getBindingInfo());
        boolean bl = false;
        if (this.futureResult != null && (asyncInfo = this.futureResult.getAsyncInfo()) != null && asyncInfo.isReliableDelivery()) {
            bl = true;
            this.messageContext.setProperty("weblogic.webservice.core.client-dispatcher", this);
            this.messageContext.setProperty("__BEA_PRIVATE_FUTURE_RESULT_PROP", this.futureResult);
            object = asyncInfo.getResultListener();
            if (object != null && object instanceof ReliableDelivery) {
                this.messageContext.setProperty("__BEA_PRIVATE_RELIABLE_PROP", object);
            }
        }
        this.wsContext = this.operation.getPort().getService().context();
        this.messageContext.setProperty("weblogic.webservice.context", this.wsContext);
        boolean bl2 = false;
        if (this.wsContext.getSession().getAttribute("weblogic.webservice.security.request") != null || this.operation.getPort().getService().getSecurity() != null) {
            bl2 = true;
        }
        object = this.messageContext.getMessage();
        if ("SOAP1.2".equals(this.operation.getPort().getBindingInfo().getType())) {
            ((WLSOAPMessage)object).setSOAP12();
        }
        MimeHeaders mimeHeaders = ((SOAPMessage)object).getMimeHeaders();
        ((DefaultOperation)this.operation).fillInHeaders(mimeHeaders);
        this.operation.getInput().toXML((SOAPMessage)object, objectArray, this.wsContext);
        this.chain = ((DefaultOperation)this.operation).getClientHandlerChain(bl, bl2);
        this.messageContext.setProperty("__BEA_PRIVATE_BINDING_PROP", binding);
        BindingInfo bindingInfo = binding.getBindingInfo();
        if (bindingInfo != null) {
            int n;
            String string = bindingInfo.getAddress();
            if (string != null) {
                this.messageContext.setProperty("javax.xml.rpc.service.endpoint.address", string);
            }
            if ((n = bindingInfo.getTimeout()) > -1) {
                this.messageContext.setProperty("weblogic.webservice.rpc.timeoutsecs", String.valueOf(n));
            }
        }
        this.messageContext.setProperty("__BEA_PRIVATE_ONEWAY_PROP", this.operation.isOneway() ? "true" : "false");
        this.chain.handleRequest(this.messageContext);
        this.dumpRequest(this.messageContext, this.logStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object receive(WLMessageContext wLMessageContext) throws SOAPException, TargetInvocationException {
        Object object;
        Object object2;
        block15: {
            block16: {
                try {
                    if (this.chain == null) break block15;
                    this.chain.handleResponse(wLMessageContext);
                    object2 = this.operation.getPort().getBindingInfo();
                    if (object2 != null) {
                        object = (String)wLMessageContext.getProperty("javax.xml.rpc.service.endpoint.address");
                        if (object != null) {
                            ((BindingInfo)object2).setAddress((String)object);
                        }
                        if ((object = (String)wLMessageContext.getProperty("weblogic.webservice.rpc.timeoutsecs")) != null) {
                            ((BindingInfo)object2).setTimeout(Integer.parseInt((String)object));
                        }
                    }
                    if (!this.operation.isOneway()) break block16;
                    object = null;
                    Object var5_4 = null;
                    if (this.chain != null) {
                        this.chain.destroy();
                    }
                    return object;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (this.chain != null) {
                        this.chain.destroy();
                    }
                    throw throwable;
                }
            }
            object = (String)wLMessageContext.getProperty("SessionID");
            if (object == null) break block15;
            this.operation.getPort().setSessionID((String)object);
        }
        QName qName = null;
        if (this.chain != null) {
            this.chain.destroy();
        }
        this.dumpResponse(wLMessageContext, this.logStream);
        object2 = wLMessageContext.getMessage().getSOAPPart().getEnvelope();
        object = object2.getBody();
        if (object == null) {
            return null;
        }
        if (object.hasFault()) {
            Object object3;
            Object object4;
            SOAPFault sOAPFault = object.getFault();
            qName = new QName("Server");
            String string = sOAPFault.getFaultCode();
            if (string != null) {
                if (string.indexOf(":") != -1) {
                    object4 = string.substring(0, string.indexOf(":"));
                    object3 = string.substring(string.indexOf(":") + 1);
                    String string2 = sOAPFault.getNamespaceURI((String)object4);
                    qName = string2 == null ? new QName(string) : new QName(string2, (String)object3);
                } else {
                    qName = new QName(string);
                }
            }
            object4 = new SOAPFaultException(qName, sOAPFault.getFaultString(), sOAPFault.getFaultActor(), sOAPFault.getDetail());
            object3 = this.deserializeFault(wLMessageContext.getMessage(), (SOAPFaultException)object4);
            if (object3 != null) {
                throw object3;
            }
            throw object4;
        }
        Object object5 = this.operation.getOutput().toJava(this.outParams, wLMessageContext.getMessage(), this.wsContext);
        return object5;
    }

    private TargetInvocationException deserializeFault(SOAPMessage sOAPMessage, SOAPFaultException sOAPFaultException) throws SOAPException {
        Part part;
        Object object;
        Object object2;
        Detail detail = sOAPMessage.getSOAPPart().getEnvelope().getBody().getFault().getDetail();
        if (detail == null) {
            return null;
        }
        SOAPElement sOAPElement = null;
        Object object3 = detail.getChildElements();
        while (object3.hasNext()) {
            object2 = object3.next();
            if (!(object2 instanceof SOAPElement)) continue;
            sOAPElement = (SOAPElement)object2;
            break;
        }
        if (sOAPElement == null) {
            return null;
        }
        object3 = this.findXsiType(sOAPElement);
        object2 = new QName(sOAPElement.getElementName().getURI(), sOAPElement.getElementName().getLocalName());
        Object object4 = null;
        boolean bl = false;
        int n = 0;
        Object object5 = this.operation.getFaults();
        while (object5.hasNext()) {
            object = (Message)object5.next();
            part = (Part)object.getParts().next();
            if (part.isElement()) {
                if (!part.getXMLType().equals(object2)) continue;
                bl = true;
                object4 = object;
                break;
            }
            if (!sOAPElement.getElementName().getLocalName().equals(part.getName())) continue;
            ++n;
            object4 = object;
        }
        if (!bl && n > 1) {
            object4 = null;
            object5 = this.operation.getFaults();
            while (object5.hasNext()) {
                object = (Message)object5.next();
                part = (Part)object.getParts().next();
                if (!part.getXMLType().equals(object3)) continue;
                object4 = object;
                break;
            }
        }
        if (object4 != null) {
            object5 = object4.toJava(null, sOAPMessage, null);
            if (!(object5 instanceof Exception)) {
                return null;
            }
            object = (Exception)object5;
            try {
                ((Throwable)object).initCause(sOAPFaultException);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return new TargetInvocationException("Service specific exception " + object, (Throwable)object);
        }
        return null;
    }

    private QName findXsiType(SOAPElement sOAPElement) {
        NameImpl nameImpl = new NameImpl("type", null, StdNamespace.instance().schemaInstance());
        String string = sOAPElement.getAttributeValue(nameImpl);
        if (string == null) {
            return null;
        }
        if (string.indexOf(":") != -1) {
            String string2 = string.substring(0, string.indexOf(":"));
            String string3 = string.substring(string.indexOf(":") + 1);
            String string4 = sOAPElement.getNamespaceURI(string2);
            if (string4 == null) {
                return new QName(string);
            }
            return new QName(string4, string3);
        }
        return new QName(string);
    }

    private void dumpRequest(WLMessageContext wLMessageContext, PrintStream printStream) {
        this.dumpMessage("REQUEST", wLMessageContext.getMessage(), printStream);
    }

    private void dumpResponse(WLMessageContext wLMessageContext, PrintStream printStream) {
        this.dumpMessage("RESPONSE", wLMessageContext.getMessage(), printStream);
    }

    private void dumpMessage(String string, SOAPMessage sOAPMessage, PrintStream printStream) {
        if (printStream != null) {
            if (printStream == null) {
                printStream = System.out;
            }
            printStream.println("\n<!--" + string + ".................-->");
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                sOAPMessage.writeTo(byteArrayOutputStream);
                byteArrayOutputStream.flush();
                try {
                    XMLInputStream xMLInputStream = XMLInputStreamFactory.newInstance().newInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                    XMLOutputStream xMLOutputStream = XMLOutputStreamFactory.newInstance().newDebugOutputStream(printStream);
                    xMLOutputStream.add(xMLInputStream);
                    xMLOutputStream.flush();
                }
                catch (Exception exception) {
                    printStream.println(new String(byteArrayOutputStream.toByteArray()));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(printStream);
            }
        }
    }
}

