/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.client;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.Socket;
import weblogic.common.ProxyAuthenticator;
import weblogic.utils.StringUtils;
import weblogic.utils.encoders.BASE64Encoder;

public class SSLUtil {
    private static final int MAX_TRIES = 3;
    private static String proxyAuthStr = null;
    private static boolean debug = Boolean.getBoolean("weblogic.webservice.client.verbose");

    protected static Socket doTunnelHandshake(String string, int n, String string2, int n2) throws IOException {
        Socket socket;
        block19: {
            String string3;
            block20: {
                if (n2 < 0) {
                    n2 = 443;
                }
                socket = null;
                if (proxyAuthStr == null) {
                    try {
                        proxyAuthStr = SSLUtil.getAuthInfo(string, n, "Basic");
                        proxyAuthStr = "Proxy-Authorization: " + proxyAuthStr;
                        if (debug) {
                            System.out.println("SSLSocket: proxyAuthStr = " + proxyAuthStr);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                int n3 = 0;
                if (debug) {
                    System.out.println("Tunneling SSL via proxy: " + string + ":" + n);
                }
                while (true) {
                    String[] stringArray;
                    socket = new Socket(string, n);
                    String string4 = null;
                    string4 = proxyAuthStr == null ? "CONNECT " + string2 + ":" + n2 + " HTTP/1.0\r\n\r\n" : "CONNECT " + string2 + ":" + n2 + " HTTP/1.0\r\n" + proxyAuthStr + "\r\n\r\n";
                    if (debug) {
                        System.out.println("SSLSocket::" + string4);
                    }
                    socket.getOutputStream().write(string4.getBytes());
                    DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                    string3 = dataInputStream.readLine();
                    if (string3 == null) {
                        socket.close();
                        throw new IOException("No data when attempting to read from Proxy Server, more than likely the Proxy Server closed the socket.  Check Proxy Server error log.");
                    }
                    if (debug) {
                        System.out.println("First line: " + string3);
                    }
                    if ((stringArray = StringUtils.splitCompletely(string3)).length < 2) break;
                    if (!stringArray[0].equals("HTTP/1.0") && !stringArray[0].equals("HTTP/1.1")) {
                        socket.close();
                        throw new ProtocolException("unrecognized response from SSL proxy: '" + string3 + "'");
                    }
                    if (stringArray[1].equals("200")) {
                        while ((string3 = dataInputStream.readLine()) != null && string3.length() > 0) {
                        }
                        if (debug) {
                            System.out.println("success");
                        }
                        break block19;
                    }
                    if (stringArray[1].equals("407")) {
                        if (n3 > 3) {
                            throw new ProtocolException("Server redirected too many times (" + n3 + ")");
                        }
                        while ((string3 = dataInputStream.readLine()) != null && string3.length() > 0) {
                            String[] stringArray2 = StringUtils.split(string3, ':');
                            if (!stringArray2[0].equalsIgnoreCase("Proxy-Authenticate")) continue;
                            if (debug) {
                                System.out.println(stringArray2[0] + ": " + stringArray2[1]);
                            }
                            if ((proxyAuthStr = SSLUtil.getAuthInfo(string, n, stringArray2[1])) == null) {
                                throw new IOException("Proxy Authentication required (407)");
                            }
                            proxyAuthStr = "Proxy-Authorization: " + proxyAuthStr;
                            if (!debug) continue;
                            System.out.println(proxyAuthStr);
                        }
                        ++n3;
                        continue;
                    }
                    break block20;
                    break;
                }
                socket.close();
                throw new ProtocolException("unrecognized response from SSL proxy: '" + string3 + "'");
            }
            throw new ProtocolException("unrecognized response from SSL proxy: '" + string3 + "'");
        }
        return socket;
    }

    public static String getAuthInfo(String string, int n, String string2) throws IOException {
        String string3 = System.getProperty("weblogic.net.proxyAuthenticatorClassName");
        if (debug) {
            System.out.println("\ngetAuthInfo(" + string + ", " + n + ", " + string2 + ") called");
        }
        if (string3 == null || string2 == null) {
            throw new IOException("Proxy or Server Authentication Required");
        }
        if (debug) {
            System.out.println(" using ProxyAuthenticator = " + string3);
        }
        ProxyAuthenticator proxyAuthenticator = null;
        String string4 = null;
        String string5 = null;
        String string6 = string2.trim();
        int n2 = string6.indexOf(32);
        if (n2 == -1) {
            string4 = string6;
            string5 = "Login to Proxy";
        } else {
            string4 = string6.substring(0, n2);
            string5 = string6.substring(n2 + 1);
            if ((n2 = string5.indexOf(61)) != -1) {
                string5 = string5.substring(n2 + 1);
            }
        }
        try {
            proxyAuthenticator = (ProxyAuthenticator)Class.forName(string3).newInstance();
        }
        catch (Exception exception) {
            throw new IOException("Proxy authenticator " + string3 + " failed: " + exception);
        }
        proxyAuthenticator.init(string, n, string4, string5);
        String[] stringArray = proxyAuthenticator.getLoginAndPassword();
        if (stringArray == null || stringArray.length != 2) {
            throw new IOException("Proxy authentication failed");
        }
        String string7 = stringArray[0] + ':' + stringArray[1];
        byte[] byArray = string7.getBytes();
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        String string8 = "Basic " + bASE64Encoder.encodeBuffer(byArray);
        if (debug) {
            System.out.println(" getAuthString() returning '" + string8 + "'");
        }
        return string8;
    }
}

