/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.client;

import weblogic.webservice.client.SSLAdapter;
import weblogic.webservice.client.SSLConfigurationException;

public class SSLAdapterFactory {
    private static boolean verbose = false;
    private static SSLAdapterFactory defaultFactory = new SSLAdapterFactory();
    private SSLAdapter defaultAdapter = null;
    private boolean useDefault = false;
    private boolean sslUnavailable = false;
    private Class adapterClass = null;
    private static final String[] adapterClasses = new String[]{"weblogic.webservice.client.WLSSLAdapter", "weblogic.webservice.client.JSSEAdapter", "weblogic.webservice.client.CDC.WLSSLAdapter", "weblogic.webservice.client.NullSSLAdapter"};
    public static final String SSL_ADAPTER_PROPERTY = "weblogic.webservice.client.ssl.adapterclass";
    private static final String userClassName = System.getProperty("weblogic.webservice.client.ssl.adapterclass");
    private String adapterClassName = null;

    public static final void setDefaultFactory(SSLAdapterFactory sSLAdapterFactory) {
        if (sSLAdapterFactory == null) {
            throw new IllegalArgumentException("DefaultFactory cannot be set to null");
        }
        defaultFactory = sSLAdapterFactory;
    }

    public static final SSLAdapterFactory getDefaultFactory() {
        return defaultFactory;
    }

    public final SSLAdapter getDefaultAdapter() {
        if (this.defaultAdapter == null) {
            this.defaultAdapter = defaultFactory.createSSLAdapter();
        }
        return this.defaultAdapter;
    }

    public final void setDefaultAdapter(SSLAdapter sSLAdapter) {
        this.defaultAdapter = sSLAdapter;
    }

    public final void setUseDefaultAdapter(boolean bl) {
        this.useDefault = bl;
    }

    public final SSLAdapter getSSLAdapter() {
        if (this.useDefault) {
            return this.getDefaultAdapter();
        }
        return this.createSSLAdapter();
    }

    public SSLAdapter createSSLAdapter() {
        if (this.sslUnavailable) {
            throw new SSLConfigurationException("No SSLAdapter class could be found.  The likely cause of this is an incomplete web service client libarary.  If no SSL implementation is available, the client should use NullSSLAdapter");
        }
        Class clazz = this.getAdapterClass();
        if (verbose) {
            System.out.println("Using SSLAdapter class " + this.adapterClassName);
        }
        Object object = null;
        try {
            object = clazz.newInstance();
            return (SSLAdapter)object;
        }
        catch (ClassCastException classCastException) {
            this.sslUnavailable = true;
            throw new IllegalArgumentException("Adapter " + this.adapterClassName + " did not return an instance of" + " SSLAdapter as required (returned " + object.getClass().getName() + " instead)");
        }
        catch (InstantiationException instantiationException) {
            this.sslUnavailable = true;
            throw new IllegalArgumentException("Adapter " + this.adapterClassName + " failed to return an instance" + " of SSLAdapter as required: " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.sslUnavailable = true;
            throw new IllegalArgumentException("Adapter " + this.adapterClassName + " failed to return an instance" + " of SSLAdapter as required: " + illegalAccessException.getMessage());
        }
    }

    private Class getAdapterClass() {
        if (this.adapterClass != null) {
            return this.adapterClass;
        }
        if (userClassName != null) {
            try {
                this.adapterClassName = userClassName;
                this.adapterClass = Class.forName(userClassName);
                return this.adapterClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SSLConfigurationException("Could not find user specified SSLAdapter class " + this.adapterClassName);
            }
        }
        for (int i = 0; i < adapterClasses.length; ++i) {
            try {
                this.adapterClassName = adapterClasses[i];
                this.adapterClass = Class.forName(this.adapterClassName);
                return this.adapterClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!verbose) continue;
                System.out.println("failed to load " + this.adapterClassName);
                continue;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (!verbose) continue;
                System.out.println("failed to load " + this.adapterClassName);
            }
        }
        this.sslUnavailable = true;
        this.adapterClassName = null;
        throw new SSLConfigurationException("No SSLAdapter class could be found.  The likely cause of this is an incomplete web service client libarary.  If no SSL implementation is available, the client should use NullSSLAdapter");
    }

    public static void main(String[] stringArray) {
        SSLAdapterFactory sSLAdapterFactory = SSLAdapterFactory.getDefaultFactory();
        System.out.println("Got default factory: " + sSLAdapterFactory);
        if (sSLAdapterFactory == sSLAdapterFactory.getDefaultFactory()) {
            System.out.println("Got the same adapter the second time");
        } else {
            System.out.println("!! Did not get same adapter the second time");
        }
        SSLAdapter sSLAdapter = sSLAdapterFactory.getDefaultAdapter();
        if (sSLAdapter == null) {
            System.out.println("!! Got null for adapter!");
        }
        System.out.println("Got defaultAdapter: " + sSLAdapter);
        if (sSLAdapter == sSLAdapterFactory.getDefaultAdapter()) {
            System.out.println("Got the same adapter the second time");
        } else {
            System.out.println("!! Did not get same adapter the second time");
        }
        sSLAdapterFactory.setUseDefaultAdapter(true);
        System.out.println("Factory set to use DefaultAdapter always");
        if (sSLAdapter == sSLAdapterFactory.getSSLAdapter()) {
            System.out.println("Got the same adapter when 'useDefault' enabled.");
        } else {
            System.out.println("!! Did not get same adapter with useDefault");
        }
        SSLAdapterFactory.setDefaultFactory(new SSLAdapterFactory());
        sSLAdapterFactory = SSLAdapterFactory.getDefaultFactory();
        System.out.println("Re-set the default factory");
        if (sSLAdapter != sSLAdapterFactory.getSSLAdapter()) {
            System.out.println("Got a new adapter from the new factory");
        } else {
            System.out.println("!! Got the old Adapter instead of one from the new factory");
        }
        sSLAdapter = sSLAdapterFactory.getDefaultAdapter();
        if (sSLAdapter == null) {
            System.out.println("!! Got null for adapter!");
        }
        System.out.println("Got defaultAdapter: " + sSLAdapter);
        if (sSLAdapter == sSLAdapterFactory.getDefaultAdapter()) {
            System.out.println("Got the same adapter the second time");
        } else {
            System.out.println("!! Did not get same adapter the second time");
        }
        sSLAdapterFactory.setUseDefaultAdapter(false);
        System.out.println("Factory set to create new Adapters each time");
        sSLAdapter = sSLAdapterFactory.getDefaultAdapter();
        System.out.println("Got defaultAdapter: " + sSLAdapter);
        if (sSLAdapter != sSLAdapterFactory.getSSLAdapter()) {
            System.out.println("Did not get same adapter the second time");
        } else {
            System.out.println("!! Got the same adapter the second time");
        }
    }
}

