/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.binding.soap;

import java.net.Socket;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import weblogic.webservice.WebServiceLogger;

public final class HttpSocketPool
extends TimerTask {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    private static final HttpSocketPool theOne = new HttpSocketPool(16);
    private static final long DEFAULT_KEEP_ALIVE_TIMEOUT = 15L;
    private static final String KEEP_ALIVE_PROP = "weblogic.http.KeepAliveTimeoutSeconds";
    private SocketNode[] socketPool;
    private boolean useKeepAlive = true;

    private HttpSocketPool(int n) {
        this.socketPool = new SocketNode[n];
        long l = 15L;
        String string = System.getProperty(KEEP_ALIVE_PROP);
        if (string != null) {
            try {
                l = new Long(string);
            }
            catch (NumberFormatException numberFormatException) {
                WebServiceLogger.logInvalidKeepAlive(KEEP_ALIVE_PROP, string, "15 seconds");
            }
        }
        if ((l *= 500L) == 0L) {
            this.useKeepAlive = false;
        }
        if (this.useKeepAlive) {
            new Timer(true).scheduleAtFixedRate((TimerTask)this, l, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SocketNode[] socketNodeArray = this.socketPool;
        synchronized (this.socketPool) {
            for (int i = 0; i < this.socketPool.length; ++i) {
                SocketNode socketNode = this.socketPool[i];
                if (socketNode == null) continue;
                if (socketNode.mark) {
                    Socket socket = socketNode.socket;
                    this.cleanup(socket);
                    this.socketPool[i] = null;
                    continue;
                }
                socketNode.mark = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void cleanup(Socket socket) {
        try {
            socket.getOutputStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            socket.getInputStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static HttpSocketPool getHttpSocketPool() {
        return theOne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket getSocket(URL uRL) {
        if (!this.useKeepAlive) {
            return null;
        }
        SocketNode[] socketNodeArray = this.socketPool;
        synchronized (this.socketPool) {
            for (int i = 0; i < this.socketPool.length; ++i) {
                SocketNode socketNode = this.socketPool[i];
                if (socketNode == null || !socketNode.url.equals(uRL)) continue;
                this.socketPool[i] = null;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return socketNode.socket;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseSocket(URL uRL, Socket socket) {
        if (!this.useKeepAlive) {
            this.cleanup(socket);
            return false;
        }
        SocketNode socketNode = new SocketNode(uRL, socket);
        SocketNode[] socketNodeArray = this.socketPool;
        synchronized (this.socketPool) {
            for (int i = 0; i < this.socketPool.length; ++i) {
                if (this.socketPool[i] != null) continue;
                this.socketPool[i] = socketNode;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.cleanup(socket);
            return false;
        }
    }

    private static class SocketNode {
        private URL url;
        private Socket socket;
        private volatile boolean mark;
        private SocketNode next;

        private SocketNode(URL uRL, Socket socket) {
            this.url = uRL;
            this.socket = socket;
            this.mark = false;
        }
    }
}

