/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.binding.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.TextMessage;
import javax.naming.NamingException;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.webservice.binding.AbstractBinding;
import weblogic.webservice.binding.BindingInfo;
import weblogic.webservice.binding.jms.ConnectionPool;
import weblogic.webservice.binding.jms.JMSBindingInfo;
import weblogic.webservice.binding.jms.JMSConnection;
import weblogic.webservice.util.WLMessageFactory;

public class JMSClientBinding
extends AbstractBinding {
    private static final boolean verbose = Boolean.getBoolean("weblogic.webservice.verbose");
    public static final String URI = "URI";
    private String url;
    private JMSBindingInfo bindingInfo;
    private MessageFactory messageFactory = WLMessageFactory.getInstance().getMessageFactory();
    private JMSConnection connection;

    public void init(BindingInfo bindingInfo) throws IOException {
        if (bindingInfo == null) {
            throw new NullPointerException("info can not be null");
        }
        if (!(bindingInfo instanceof JMSBindingInfo)) {
            throw new IllegalArgumentException("info is not a JMSBindingInfo");
        }
        this.bindingInfo = (JMSBindingInfo)bindingInfo;
    }

    public void receive(MessageContext messageContext) throws IOException, SOAPException {
        if (!(messageContext instanceof SOAPMessageContext)) {
            throw new SOAPException("This binding only supports SOAPMessageContext. " + messageContext);
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        try {
            QueueReceiver queueReceiver = this.connection.getReceiver();
            Message message = queueReceiver.receive();
            if (message instanceof TextMessage) {
                String string = ((TextMessage)message).getText();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                sOAPMessageContext.setMessage(this.messageFactory.createMessage(null, byteArrayInputStream));
            }
            this.connection.release();
        }
        catch (JMSException jMSException) {
            throw new SOAPException("Failed to receive message:" + jMSException, jMSException);
        }
    }

    public void send(MessageContext messageContext) throws IOException, SOAPException {
        if (!(messageContext instanceof SOAPMessageContext)) {
            throw new JAXRPCException("This binding only supports SOAPMessageContext. " + messageContext);
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
        MimeHeaders mimeHeaders = sOAPMessage.getMimeHeaders();
        sOAPMessage.writeTo(byteArrayOutputStream);
        byteArrayOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            this.sendToQueue(byArray);
        }
        catch (NamingException namingException) {
            this.failed(namingException);
        }
        catch (JMSException jMSException) {
            this.sendAgain(byArray);
        }
    }

    private void sendAgain(byte[] byArray) {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            this.sendToQueue(byArray);
        }
        catch (JMSException jMSException) {
            this.failed(jMSException);
        }
        catch (NamingException namingException) {
            this.failed(namingException);
        }
    }

    private void failed(Throwable throwable) {
        throw new JAXRPCException("unable to send the message to JMS Queue at: " + this.bindingInfo + "\n due to :" + throwable, throwable);
    }

    private void sendToQueue(byte[] byArray) throws NamingException, JMSException {
        this.connection = ConnectionPool.getInstance().getConnection(this.bindingInfo);
        TextMessage textMessage = this.connection.getMessage();
        textMessage.setStringProperty(URI, this.bindingInfo.getServiceURI());
        textMessage.setJMSReplyTo((Destination)this.connection.getResponseQueue());
        textMessage.setText(new String(byArray));
        QueueSender queueSender = this.connection.getSender();
        queueSender.send(textMessage);
    }
}

