/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.binding.jms;

import javax.xml.rpc.JAXRPCException;
import weblogic.webservice.binding.BindingInfo;

public class JMSBindingInfo
extends BindingInfo {
    private String host;
    private int port;
    private String factoryName;
    private String queueName;
    private String serviceURI;
    private static final boolean verbose = Boolean.getBoolean("weblogic.webservice.verbose");
    public static final String TRANSPORT = "http://www.openuri.org/2002/04/soap/jms/";

    public String getTransport() {
        return "jms";
    }

    public void setAddress(String string) {
        this.parseAddress(string);
        super.setAddress(string);
    }

    public String getAddress() {
        return "jms://" + this.host + ":" + this.port + "/" + this.factoryName + "/" + this.queueName + "?URI=" + this.serviceURI;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getServiceURI() {
        return this.serviceURI;
    }

    public void setServiceURI(String string) {
        this.serviceURI = string;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public String getQueueName() {
        return this.queueName;
    }

    private void throwParseError(String string) {
        throw new JAXRPCException("the address [" + string + "] is not " + "a JMS valid address. It should be of the from " + "'jms://host:port/factoryName/queueName?URI=serviceURI");
    }

    private void parseAddress(String string) {
        String string2;
        int n;
        if (!string.startsWith("jms://")) {
            this.throwParseError(string);
        }
        if ((n = (string2 = string.substring("jms://".length(), string.length())).indexOf(":")) == -1) {
            this.throwParseError(string);
        }
        this.host = string2.substring(0, n);
        if ((n = (string2 = string2.substring(n + 1, string2.length())).indexOf("/")) == -1) {
            this.throwParseError(string);
        }
        try {
            this.port = Integer.parseInt(string2.substring(0, n));
        }
        catch (NumberFormatException numberFormatException) {
            if (verbose) {
                numberFormatException.printStackTrace();
            }
            this.throwParseError(string);
        }
        string2 = string2.substring(n + 1, string2.length());
        n = string2.indexOf("/");
        if (n == -1) {
            this.throwParseError(string);
        }
        this.factoryName = string2.substring(0, n);
        if ((n = (string2 = string2.substring(n + 1, string2.length())).indexOf("?")) == -1) {
            this.throwParseError(string);
        }
        this.queueName = string2.substring(0, n);
        if (!(string2 = string2.substring(n + 1, string2.length())).startsWith("URI=")) {
            this.throwParseError(string);
        }
        this.serviceURI = string2.substring("URI=".length());
    }
}

