/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.binding.https;

import java.net.Socket;
import weblogic.webservice.binding.BindingInfo;
import weblogic.webservice.client.SSLAdapter;
import weblogic.webservice.client.SSLAdapterFactory;

public class HttpsBindingInfo
extends BindingInfo {
    private SSLAdapter sslAdapter = SSLAdapterFactory.getDefaultFactory().getSSLAdapter();
    private boolean pooling = false;
    private Socket secureSocket = null;
    private String secureHost = null;
    private int securePort = 0;
    private long secureTimeOK = 0L;
    private long secureTimeKO = 15000L;
    private static final String HTTPS_SOCKET_SHARING = "https.sharedsocket";
    private boolean socketSharingEnabled = Boolean.getBoolean("https.sharedsocket");

    public String getTransport() {
        return "https";
    }

    public SSLAdapter getSSLAdapter() {
        return this.sslAdapter;
    }

    public void setSSLAdapter(SSLAdapter sSLAdapter) {
        this.sslAdapter = sSLAdapter;
        this.setSSLSecureSocket(null, null, 0);
    }

    public void setSSLSocketPooling(boolean bl) {
        this.pooling = bl;
        if (!this.pooling) {
            this.setSSLSecureSocket(null, null, 0);
        }
    }

    public boolean getSSLSocketPooling() {
        return this.pooling;
    }

    void setSSLSecureSocket(Socket socket, String string, int n) {
        this.secureSocket = socket;
        this.secureHost = string;
        this.securePort = n;
        this.secureTimeOK = System.currentTimeMillis() + this.secureTimeKO;
    }

    Socket getSSLSecureSocket(String string, int n) {
        if (this.secureSocket != null) {
            if (this.secureHost.equals(string) && this.securePort == n && this.secureSocket.isConnected() && this.secureSocket.isBound() && !this.secureSocket.isClosed() && !this.secureSocket.isInputShutdown() && !this.secureSocket.isOutputShutdown() && this.secureTimeOK > System.currentTimeMillis()) {
                this.secureTimeOK = System.currentTimeMillis() + this.secureTimeKO;
            } else {
                this.closeSharedSocket();
            }
        }
        return this.secureSocket;
    }

    void setSSLSecureSocketTimeOut() {
        this.secureTimeOK = System.currentTimeMillis() + this.secureTimeKO;
    }

    public void closeSharedSocket() {
        try {
            this.secureSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setSSLSecureSocket(null, null, 0);
    }

    public void setSharedSocketTimeout(long l) {
        this.secureTimeKO = l * 1000L;
    }

    public long getSharedSocketTimeout() {
        return this.secureTimeKO / 1000L;
    }

    public void setSocketSharing(boolean bl) {
        this.socketSharingEnabled = bl;
        if (!this.socketSharingEnabled) {
            this.setSSLSecureSocket(null, null, 0);
        }
    }

    public boolean getSocketSharing() {
        return this.socketSharingEnabled;
    }
}

