/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.binding.http11;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.webservice.WLSOAPMessage;
import weblogic.webservice.binding.AbstractBinding;
import weblogic.webservice.binding.BindingInfo;
import weblogic.webservice.util.AccessException;
import weblogic.webservice.util.WLMessageFactory;

public class Http11ClientBinding
extends AbstractBinding {
    private URL url;
    private HttpURLConnection connection;
    private InputStream inputStream;
    private OutputStream outputStream;
    private PrintStream out;
    private int bufferSize = 4000;
    private static final String WEBSERVICE_VERBOSE = "weblogic.webservice.verbose";
    private static final String HTTP_FULL_URL = "weblogic.webservice.transport.http.full-url";
    private static boolean verbose = Boolean.getBoolean("weblogic.webservice.verbose");
    private static final boolean fullUrl = Boolean.getBoolean("weblogic.webservice.transport.http.full-url");
    private MessageFactory messageFactory = WLMessageFactory.getInstance().getMessageFactory();

    public void init(BindingInfo bindingInfo) throws IOException {
        this.url = new URL(bindingInfo.getAddress());
        this.out = System.out;
        this.setBindingInfo(bindingInfo);
    }

    private boolean validContentType(String string) throws IOException {
        if (string == null) {
            return false;
        }
        String string2 = null;
        try {
            string2 = new ContentType(string).getBaseType();
        }
        catch (ParseException parseException) {
            return false;
        }
        string2 = string2.trim().toLowerCase();
        return "text/xml".startsWith(string2) || "application/soap+xml".startsWith(string2) || "multipart/related".startsWith(string2);
    }

    private void handleErrorResponse() throws IOException {
        int n = this.connection.getResponseCode();
        switch (n) {
            case 500: {
                throw new IOException("The server at " + this.url.toString() + " returned a 500 error code (Internal Server Error).  Please ensure" + " that your URL is correct, and the web service has deployed. ");
            }
            case 404: {
                throw new IOException("The server at " + this.url.toString() + " returned a 404 error code (Not Found).  Please ensure that your" + " URL is correct, and the web service has deployed " + "without error.");
            }
            case 403: {
                throw new AccessException("The server at " + this.url.toString() + " returned a 403 error code (Forbidden).  Please ensure that your " + "URL is correct and that the correct protocol is in use.");
            }
            case 401: {
                throw new AccessException("The server at " + this.url.toString() + " returned a 401 error code (Unauthorized).  Please check that" + " username and password are set correctly and that you have" + " permission to access the requested method.");
            }
            case 301: 
            case 302: {
                throw new IOException("Redirection not supported: The server at " + this.url.toString() + " returned a " + n + " response code indicating this resource has moved.");
            }
        }
        throw new IOException("Received a response from url: " + this.url + " which did not have a valid SOAP content-type: " + this.connection.getContentType() + ".");
    }

    private InputStream getStream() throws IOException {
        InputStream inputStream;
        try {
            inputStream = this.connection.getInputStream();
        }
        catch (IOException iOException) {
            inputStream = this.connection.getErrorStream();
        }
        return inputStream;
    }

    private boolean isVerbose() {
        return verbose || this.getBindingInfo().isVerbose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(MessageContext messageContext) throws IOException, SOAPException {
        if (!(messageContext instanceof SOAPMessageContext)) {
            throw new JAXRPCException("This binding only supports SOAPMessageContext. " + messageContext);
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        boolean bl = "true".equals(sOAPMessageContext.getProperty("__BEA_PRIVATE_ONEWAY_PROP"));
        if (!this.validContentType(this.connection.getContentType())) {
            if (this.isVerbose()) {
                this.dumpResponse(this.getStream());
            }
            if (this.connection.getResponseCode() == 400) {
                throw new IOException("Received a response from url: " + this.url + " which did not have a valid SOAP content-type: " + this.connection.getContentType() + ". ");
            }
            this.handleErrorResponse();
        }
        if (bl) {
            return;
        }
        String string = this.connection.getHeaderField("set-cookie");
        if (string != null && string.startsWith("JSESSIONID")) {
            sOAPMessageContext.setProperty("SessionID", string);
        }
        try {
            this.inputStream = this.getStream();
            if (this.isVerbose()) {
                this.inputStream = this.dumpResponse(this.inputStream);
            }
            sOAPMessageContext.setMessage(this.messageFactory.createMessage(this.getMimeHeaders(), this.inputStream));
        }
        catch (IOException iOException) {
            throw new IOException("Error reading the response from: " + this.url + ".  Please ensure that this is a " + "valid SOAP response.");
        }
    }

    private MimeHeaders getMimeHeaders() {
        String string;
        MimeHeaders mimeHeaders = new MimeHeaders();
        int n = 1;
        while ((string = this.connection.getHeaderFieldKey(n)) != null) {
            String string2;
            if ((string2 = this.connection.getHeaderField(n++)) == null || string2.length() == 0) continue;
            mimeHeaders.setHeader(string, string2);
        }
        return mimeHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void send(MessageContext messageContext) throws IOException, SOAPException {
        if (!(messageContext instanceof SOAPMessageContext)) {
            throw new JAXRPCException("This binding only supports SOAPMessageContext. " + messageContext);
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
        WLSOAPMessage wLSOAPMessage = (WLSOAPMessage)((Object)sOAPMessage);
        MimeHeaders mimeHeaders = sOAPMessage.getMimeHeaders();
        if (this.getBindingInfo().getCharset() != null) {
            wLSOAPMessage.setCharset(this.getBindingInfo().getCharset());
        }
        try {
            Object object;
            Object object2;
            String string = (String)sOAPMessageContext.getProperty("javax.xml.rpc.service.endpoint.address");
            if (string != null) {
                this.url = new URL(string);
            }
            this.connection = (HttpURLConnection)this.url.openConnection();
            this.connection.setDoOutput(true);
            this.connection.setDoInput(true);
            if (this.connection instanceof weblogic.net.http.HttpURLConnection) {
                object2 = (weblogic.net.http.HttpURLConnection)this.connection;
                object = (String)sOAPMessageContext.getProperty("weblogic.webservice.rpc.timeoutsecs");
                if (object != null) {
                    int n = Integer.parseInt((String)object) * 1000;
                    ((weblogic.net.http.HttpURLConnection)object2).setTimeout(n);
                }
            }
            object2 = wLSOAPMessage.getContentType();
            if (wLSOAPMessage.getCharset() != null) {
                object2 = (String)object2 + "; charset=" + wLSOAPMessage.getCharset();
            }
            this.connection.setRequestProperty("Content-Type", (String)object2);
            if (this.getBindingInfo().getAcceptCharset() != null) {
                this.connection.setRequestProperty("Accept-Charset", this.getBindingInfo().getAcceptCharset());
            }
            if (mimeHeaders != null) {
                object = mimeHeaders.getAllHeaders();
                while (object.hasNext()) {
                    MimeHeader mimeHeader = (MimeHeader)object.next();
                    if ("Content-Type".equals(mimeHeader.getName())) continue;
                    this.connection.setRequestProperty(mimeHeader.getName(), mimeHeader.getValue());
                }
            }
            if (this.isVerbose()) {
                object = new ByteArrayOutputStream();
                sOAPMessage.writeTo((OutputStream)object);
                ((OutputStream)object).flush();
                byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
                this.dumpRequest(this.connection, byArray);
                this.outputStream = this.connection.getOutputStream();
                this.outputStream.write(byArray);
            } else {
                this.outputStream = this.connection.getOutputStream();
                sOAPMessage.writeTo(this.outputStream);
            }
            Object var11_12 = null;
            if (this.outputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (this.outputStream == null) throw throwable;
            this.outputStream.close();
            throw throwable;
        }
        this.outputStream.close();
    }

    private void dumpRequest(HttpURLConnection httpURLConnection, byte[] byArray) {
        this.out.println("<!-------------------- REQUEST FROM CLIENT ---------------->");
        this.out.println("URL        :  " + this.url);
        this.out.println("Headers    :");
        Map<String, List<String>> map = httpURLConnection.getRequestProperties();
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            this.out.println("  " + string + ": " + map.get(string));
        }
        this.out.println("");
        this.out.println(new String(byArray));
        this.out.println("<!-------------------- END REQUEST FROM CLIENT ------------>");
    }

    private InputStream dumpResponse(InputStream inputStream) throws IOException {
        int n;
        this.out.println("<!-------------------- RESPONSE TO CLIENT --------------->");
        this.out.println("URL           : " + this.url);
        this.out.println("Response Code :" + this.connection.getResponseCode());
        this.out.println("Headers       :");
        Object object = this.getMimeHeaders().getAllHeaders();
        while (object.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)object.next();
            this.out.println("  " + mimeHeader.getName() + "=" + mimeHeader.getValue());
        }
        object = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != -1) {
            ((ByteArrayOutputStream)object).write(n);
        }
        this.out.println("Envelope   :");
        this.out.println(new String(((ByteArrayOutputStream)object).toByteArray()));
        this.out.println("<!-------------------- END RESPONSE TO CLIENT ----------->");
        return new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
    }

    private String makeContentType() {
        String string = "SOAP1.1".equals(this.getBindingInfo().getType()) ? "text/xml" : "application/soap+xml";
        if (this.getBindingInfo().getCharset() != null) {
            string = string + "; charset=" + this.getBindingInfo().getCharset();
        }
        return string;
    }

    private String getContentType(MimeHeaders mimeHeaders) {
        String[] stringArray = mimeHeaders.getHeader("Content-Type");
        if (stringArray == null || stringArray.length == 0) {
            return this.makeContentType();
        }
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private void writeToStream(OutputStream outputStream, byte[] byArray) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        bufferedOutputStream.write(byArray);
        bufferedOutputStream.flush();
        outputStream.flush();
    }

    private int getPort(URL uRL) {
        return uRL.getPort() == -1 ? 80 : uRL.getPort();
    }
}

