/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.binding;

import weblogic.webservice.binding.BindingExtension;

public class BindingInfo {
    public static final String SOAP11 = "SOAP1.1";
    public static final String SOAP12 = "SOAP1.2";
    public static final String DEFAULT_TRANSPORT = "http11";
    private String transport;
    private String address;
    private String type = "SOAP1.1";
    private String acceptCharset;
    private String charset = null;
    private int timeout = -1;
    private boolean verbose;
    private BindingExtension[] allBindings = new BindingExtension[2];

    public BindingInfo() {
        this(DEFAULT_TRANSPORT);
    }

    public BindingInfo(String string) {
        this.transport = string;
    }

    public String getTransport() {
        return this.transport;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public boolean isSoap12() {
        return SOAP12.equals(this.getType());
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public String getAcceptCharset() {
        return this.acceptCharset;
    }

    public void setAcceptCharset(String string) {
        this.acceptCharset = string;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public BindingExtension getExtension(int n) {
        if (n < 0 || n >= 2) {
            throw new IllegalArgumentException("Binding key is out of range");
        }
        return this.allBindings[n];
    }

    public void addExtension(BindingExtension bindingExtension) {
        if (bindingExtension == null) {
            throw new IllegalArgumentException("ext cannot be null");
        }
        int n = bindingExtension.getKey();
        if (n < 0 || n >= 2) {
            throw new IllegalArgumentException("Binding key is out of range");
        }
        this.allBindings[n] = bindingExtension;
    }
}

