/*
 * Decompiled with CFR 0.152.
 */
package weblogic.webservice.async;

import java.util.ArrayList;
import weblogic.webservice.async.KernelFeeder;

public class ThreadPool
implements Runnable {
    private ArrayList tasks = new ArrayList();
    protected static boolean DEBUG = false;
    private boolean isRunningOnServer;
    private KernelFeeder kernelFeeder;

    public ThreadPool(int n) {
        this.findRunningOnServer();
        if (!this.isRunningOnServer) {
            this.startThreads(n);
        }
    }

    private void startThreads(int n) {
        for (int i = 0; i < n; ++i) {
            Thread thread = new Thread((Runnable)this, "Web Service Client Thread #" + i);
            thread.setDaemon(true);
            thread.start();
        }
    }

    private void findRunningOnServer() {
        block2: {
            try {
                Class.forName("weblogic.kernel.Kernel");
                this.kernelFeeder = (KernelFeeder)Class.forName("weblogic.webservice.async.KernelFeederImpl").newInstance();
                this.isRunningOnServer = this.kernelFeeder.isServer();
            }
            catch (Throwable throwable) {
                this.isRunningOnServer = false;
                if (!DEBUG) break block2;
                throwable.printStackTrace();
            }
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Runnable runnable = this.getTask();
                    runnable.run();
                }
            }
            catch (Throwable throwable) {
                if (!DEBUG) continue;
                throwable.printStackTrace(System.out);
                continue;
            }
            break;
        }
    }

    private Runnable getTask() {
        ArrayList arrayList = this.tasks;
        synchronized (arrayList) {
            while (true) {
                if (this.tasks.size() != 0) {
                    return (Runnable)this.tasks.remove(0);
                }
                if (this.tasks.size() != 0) continue;
                try {
                    this.tasks.wait();
                }
                catch (InterruptedException interruptedException) {
                    if (!DEBUG) continue;
                    interruptedException.printStackTrace(System.out);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Runnable runnable) {
        if (this.isRunningOnServer) {
            this.kernelFeeder.addTask(runnable);
        } else {
            ArrayList arrayList = this.tasks;
            synchronized (arrayList) {
                this.tasks.add(runnable);
                this.tasks.notifyAll();
            }
        }
    }
}

