/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import weblogic.utils.io.Chunk;

public class NoFlushOutputStreamWriter
extends Writer {
    private CharToByteConverter ctb;
    private OutputStream out;
    private byte[] bb;
    private int nextByte = 0;
    private int nBytes = 0;
    private static boolean doNotConvert = CharToByteConverter.getDefault().getCharacterEncoding().equals("Cp1252");
    private boolean doConvert = false;
    private Chunk chunk;

    public NoFlushOutputStreamWriter(OutputStream outputStream, String string, boolean bl) throws UnsupportedEncodingException {
        this(outputStream, string);
        this.doConvert = bl;
    }

    public NoFlushOutputStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this(outputStream, CharToByteConverter.getConverter((String)string));
    }

    public NoFlushOutputStreamWriter(OutputStream outputStream) {
        this(outputStream, doNotConvert ? null : CharToByteConverter.getDefault());
    }

    private NoFlushOutputStreamWriter(OutputStream outputStream, CharToByteConverter charToByteConverter) {
        super(outputStream);
        if (outputStream == null) {
            throw new NullPointerException("out is null");
        }
        this.out = outputStream;
        this.ctb = charToByteConverter;
        this.chunk = Chunk.getChunk();
        this.bb = this.chunk.buf;
        this.nBytes = Chunk.CHUNK_SIZE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEncoding() {
        Object object = this.lock;
        synchronized (object) {
            if (this.ctb != null) {
                return this.ctb.getCharacterEncoding();
            }
            return null;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    public void write(int n) throws IOException {
        char[] cArray = new char[]{(char)n};
        this.write(cArray, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            if (doNotConvert && !this.doConvert) {
                for (int i = n; i < n2; ++i) {
                    this.out.write(cArray[i]);
                }
                return;
            }
            int n3 = n;
            int n4 = n + n2;
            boolean bl = false;
            while (n3 < n4) {
                boolean bl2 = false;
                try {
                    this.nextByte += this.ctb.convertAny(cArray, n3, n4, this.bb, this.nextByte, this.nBytes);
                    n3 = n4;
                }
                catch (ConversionBufferFullException conversionBufferFullException) {
                    int n5 = this.ctb.nextCharIndex();
                    if (n5 == n3 && bl) {
                        throw new CharConversionException("Output buffer too small");
                    }
                    n3 = n5;
                    bl2 = true;
                    this.nextByte = this.ctb.nextByteIndex();
                }
                if (this.nextByte < this.nBytes && !bl2) continue;
                this.out.write(this.bb, 0, this.nextByte);
                this.nextByte = 0;
                bl = true;
            }
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        char[] cArray = new char[n2];
        string.getChars(n, n + n2, cArray, 0);
        this.write(cArray, 0, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (doNotConvert && !this.doConvert) {
                return;
            }
            while (true) {
                try {
                    this.nextByte += this.ctb.flushAny(this.bb, this.nextByte, this.nBytes);
                }
                catch (ConversionBufferFullException conversionBufferFullException) {
                    this.nextByte = this.ctb.nextByteIndex();
                }
                if (this.nextByte == 0) break;
                if (this.nextByte <= 0) continue;
                this.out.write(this.bb, 0, this.nextByte);
                this.nextByte = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        block7: {
            block6: {
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.out == null) {
                            // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                            Object var4_2 = null;
                            if (this.chunk == null) return;
                            break block6;
                        }
                        this.flush();
                        this.out = null;
                        this.bb = null;
                        this.ctb = null;
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (this.chunk == null) throw throwable;
                    Chunk.releaseChunk(this.chunk);
                    throw throwable;
                }
            }
            Chunk.releaseChunk(this.chunk);
            return;
        }
        Object var4_3 = null;
        if (this.chunk == null) return;
        Chunk.releaseChunk(this.chunk);
    }
}

