/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import weblogic.utils.collections.IdentityHashMap;

public class IdentityHashMap
extends AbstractMap
implements Map,
Serializable,
Cloneable {
    static final long serialVersionUID = -33836225047284283L;
    private static final int DEFAULT_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x20000000;
    private transient Object[] table;
    private int size;
    private volatile transient int modCount;
    private transient int threshold;
    private static final Object NULL_KEY = new Object();
    private transient Set entrySet = null;
    volatile transient Set keySet = null;
    volatile transient Collection values = null;

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    private static Object unmaskNull(Object object) {
        return object == NULL_KEY ? null : object;
    }

    public IdentityHashMap() {
        this.init(32);
    }

    public IdentityHashMap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("expectedMaxSize is negative: " + n);
        }
        this.init(this.capacity(n));
    }

    private int capacity(int n) {
        int n2;
        int n3 = 3 * n / 2;
        if (n3 > 0x20000000 || n3 < 0) {
            n2 = 0x20000000;
        } else {
            for (n2 = 4; n2 < n3; n2 <<= 1) {
            }
        }
        return n2;
    }

    private void init(int n) {
        this.threshold = n * 2 / 3;
        this.table = new Object[2 * n];
    }

    public IdentityHashMap(Map map) {
        this((int)((double)(1 + map.size()) * 1.1));
        this.putAll(map);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private static int hash(Object object, int n) {
        int n2 = System.identityHashCode(object);
        return (n2 << 1) - (n2 << 8) & n - 1;
    }

    private static int nextKeyIndex(int n, int n2) {
        return n + 2 < n2 ? n + 2 : 0;
    }

    public Object get(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object2, n);
        Object object3;
        while ((object3 = objectArray[n2]) != object2) {
            if (object3 == null) {
                return object3;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
        return objectArray[n2 + 1];
    }

    public boolean containsKey(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object2, n);
        Object object3;
        while ((object3 = objectArray[n2]) != object2) {
            if (object3 == null) {
                return false;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
        return true;
    }

    public boolean containsValue(Object object) {
        Object[] objectArray = this.table;
        for (int i = 1; i < objectArray.length; i += 2) {
            if (objectArray[i] != object) continue;
            return true;
        }
        return false;
    }

    private boolean containsMapping(Object object, Object object2) {
        Object object3 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object3, n);
        Object object4;
        while ((object4 = objectArray[n2]) != object3) {
            if (object4 == null) {
                return false;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
        return objectArray[n2 + 1] == object2;
    }

    public Object put(Object object, Object object2) {
        Object object3;
        Object object4 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object4, n);
        while ((object3 = objectArray[n2]) != null) {
            if (object3 == object4) {
                Object object5 = objectArray[n2 + 1];
                objectArray[n2 + 1] = object2;
                return object5;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
        ++this.modCount;
        objectArray[n2] = object4;
        objectArray[n2 + 1] = object2;
        if (++this.size >= this.threshold) {
            this.resize(n);
        }
        return null;
    }

    private void resize(int n) {
        int n2 = n * 2;
        Object[] objectArray = this.table;
        int n3 = objectArray.length;
        if (n3 == 0x40000000) {
            if (this.threshold == 0x1FFFFFFF) {
                throw new IllegalStateException("Capacity exhausted.");
            }
            this.threshold = 0x1FFFFFFF;
            return;
        }
        if (n3 >= n2) {
            return;
        }
        Object[] objectArray2 = new Object[n2];
        this.threshold = n2 / 3;
        for (int i = 0; i < n3; i += 2) {
            Object object = objectArray[i];
            if (object == null) continue;
            Object object2 = objectArray[i + 1];
            objectArray[i] = null;
            objectArray[i + 1] = null;
            int n4 = IdentityHashMap.hash(object, n2);
            while (objectArray2[n4] != null) {
                n4 = IdentityHashMap.nextKeyIndex(n4, n2);
            }
            objectArray2[n4] = object;
            objectArray2[n4 + 1] = object2;
        }
        this.table = objectArray2;
    }

    public void putAll(Map map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            this.resize(this.capacity(n));
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object2, n);
        while (true) {
            Object object3;
            if ((object3 = objectArray[n2]) == object2) {
                ++this.modCount;
                --this.size;
                Object object4 = objectArray[n2 + 1];
                objectArray[n2 + 1] = null;
                objectArray[n2] = null;
                this.closeDeletion(n2);
                return object4;
            }
            if (object3 == null) {
                return null;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
    }

    private boolean removeMapping(Object object, Object object2) {
        Object object3 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object3, n);
        while (true) {
            Object object4;
            if ((object4 = objectArray[n2]) == object3) {
                if (objectArray[n2 + 1] != object2) {
                    return false;
                }
                ++this.modCount;
                --this.size;
                objectArray[n2] = null;
                objectArray[n2 + 1] = null;
                this.closeDeletion(n2);
                return true;
            }
            if (object4 == null) {
                return false;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
    }

    private void closeDeletion(int n) {
        Object object;
        Object[] objectArray = this.table;
        int n2 = objectArray.length;
        int n3 = IdentityHashMap.nextKeyIndex(n, n2);
        while ((object = objectArray[n3]) != null) {
            int n4 = IdentityHashMap.hash(object, n2);
            if (n3 < n4 && (n4 <= n || n <= n3) || n4 <= n && n <= n3) {
                objectArray[n] = object;
                objectArray[n + 1] = objectArray[n3 + 1];
                objectArray[n3] = null;
                objectArray[n3 + 1] = null;
                n = n3;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
    }

    public void clear() {
        ++this.modCount;
        Object[] objectArray = this.table;
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = null;
        }
        this.size = 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IdentityHashMap) {
            IdentityHashMap identityHashMap = (IdentityHashMap)object;
            if (identityHashMap.size() != this.size) {
                return false;
            }
            Object[] objectArray = identityHashMap.table;
            for (int i = 0; i < objectArray.length; i += 2) {
                Object object2 = objectArray[i];
                if (object2 == null || this.containsMapping(object2, objectArray[i + 1])) continue;
                return false;
            }
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return ((Object)this.entrySet()).equals(map.entrySet());
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        Object[] objectArray = this.table;
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            if (object == null) continue;
            Object object2 = IdentityHashMap.unmaskNull(object);
            n += System.identityHashCode(object2) ^ System.identityHashCode(objectArray[i + 1]);
        }
        return n;
    }

    public Object clone() {
        try {
            IdentityHashMap identityHashMap = (IdentityHashMap)super.clone();
            identityHashMap.entrySet = null;
            identityHashMap.table = (Object[])this.table.clone();
            return identityHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Set keySet() {
        Set set = this.keySet;
        if (set != null) {
            return set;
        }
        this.keySet = new KeySet(this, null);
        return this.keySet;
    }

    public Collection values() {
        Collection collection = this.values;
        if (collection != null) {
            return collection;
        }
        this.values = new Values(this, null);
        return this.values;
    }

    public Set entrySet() {
        Set set = this.entrySet;
        if (set != null) {
            return set;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Object[] objectArray = this.table;
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            if (object == null) continue;
            objectOutputStream.writeObject(IdentityHashMap.unmaskNull(object));
            objectOutputStream.writeObject(objectArray[i + 1]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.init(this.capacity(n * 4 / 3));
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return IdentityHashMap.this.containsMapping(entry.getKey(), entry.getValue());
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return IdentityHashMap.this.removeMapping(entry.getKey(), entry.getValue());
        }

        public int size() {
            return IdentityHashMap.this.size;
        }

        public void clear() {
            IdentityHashMap.this.clear();
        }

        public boolean removeAll(Collection collection) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        public Object[] toArray() {
            ArrayList<SimpleEntry> arrayList = new ArrayList<SimpleEntry>(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new SimpleEntry((Map.Entry)iterator.next()));
            }
            return arrayList.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            ArrayList<SimpleEntry> arrayList = new ArrayList<SimpleEntry>(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new SimpleEntry((Map.Entry)iterator.next()));
            }
            return arrayList.toArray(objectArray);
        }
    }

    private class EntryIterator
    extends IdentityHashMapIterator
    implements Map.Entry {
        private EntryIterator() {
        }

        public Object next() {
            this.nextIndex();
            return this;
        }

        public Object getKey() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            return IdentityHashMap.unmaskNull(this.traversalTable[this.lastReturnedIndex]);
        }

        public Object getValue() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            return this.traversalTable[this.lastReturnedIndex + 1];
        }

        public Object setValue(Object object) {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            Object object2 = this.traversalTable[this.lastReturnedIndex + 1];
            this.traversalTable[this.lastReturnedIndex + 1] = object;
            if (this.traversalTable != IdentityHashMap.this.table) {
                IdentityHashMap.this.put(this.traversalTable[this.lastReturnedIndex], object);
            }
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return entry.getKey() == this.getKey() && entry.getValue() == this.getValue();
        }

        public int hashCode() {
            return System.identityHashCode(this.getKey()) ^ System.identityHashCode(this.getValue());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private abstract class IdentityHashMapIterator
    implements Iterator {
        int index;
        int expectedModCount;
        int lastReturnedIndex;
        boolean indexValid;
        Object[] traversalTable;

        private IdentityHashMapIterator() {
            this.index = IdentityHashMap.this.size != 0 ? 0 : IdentityHashMap.this.table.length;
            this.expectedModCount = IdentityHashMap.this.modCount;
            this.lastReturnedIndex = -1;
            this.traversalTable = IdentityHashMap.this.table;
        }

        public boolean hasNext() {
            Object[] objectArray = this.traversalTable;
            for (int i = this.index; i < objectArray.length; i += 2) {
                Object object = objectArray[i];
                if (object == null) continue;
                this.index = i;
                this.indexValid = true;
                return true;
            }
            this.index = objectArray.length;
            return false;
        }

        protected int nextIndex() {
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.indexValid && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexValid = false;
            this.lastReturnedIndex = this.index;
            this.index += 2;
            return this.lastReturnedIndex;
        }

        public void remove() {
            Object object;
            if (this.lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.expectedModCount = ++IdentityHashMap.this.modCount;
            int n = this.lastReturnedIndex;
            this.lastReturnedIndex = -1;
            IdentityHashMap.this.size--;
            this.index = n;
            this.indexValid = false;
            Object[] objectArray = this.traversalTable;
            int n2 = objectArray.length;
            int n3 = n;
            Object object2 = objectArray[n3];
            objectArray[n3] = null;
            objectArray[n3 + 1] = null;
            if (objectArray != IdentityHashMap.this.table) {
                IdentityHashMap.this.remove(object2);
                this.expectedModCount = IdentityHashMap.this.modCount;
                return;
            }
            int n4 = IdentityHashMap.nextKeyIndex(n3, n2);
            while ((object = objectArray[n4]) != null) {
                int n5 = IdentityHashMap.hash(object, n2);
                if (n4 < n5 && (n5 <= n3 || n3 <= n4) || n5 <= n3 && n3 <= n4) {
                    if (n4 < n && n3 >= n && this.traversalTable == IdentityHashMap.this.table) {
                        int n6 = n2 - n;
                        Object[] objectArray2 = new Object[n6];
                        System.arraycopy(objectArray, n, objectArray2, 0, n6);
                        this.traversalTable = objectArray2;
                        this.index = 0;
                    }
                    objectArray[n3] = object;
                    objectArray[n3 + 1] = objectArray[n4 + 1];
                    objectArray[n4] = null;
                    objectArray[n4 + 1] = null;
                    n3 = n4;
                }
                n4 = IdentityHashMap.nextKeyIndex(n4, n2);
            }
        }
    }
}

