/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CombinedIterator
implements Iterator {
    private final Iterator[] iterators;
    private int i = 0;

    public CombinedIterator(Iterator[] iteratorArray) {
        this.iterators = iteratorArray;
    }

    public CombinedIterator(Iterator iterator, Iterator iterator2) {
        this(new Iterator[]{iterator, iterator2});
    }

    public CombinedIterator(Collection collection) {
        this(collection.toArray(new Iterator[collection.size()]));
    }

    public boolean hasNext() {
        while (this.i < this.iterators.length && !this.iterators[this.i].hasNext()) {
            this.iterators[this.i++] = null;
        }
        return this.i < this.iterators.length;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.iterators[this.i].next();
    }

    public void remove() {
        this.iterators[this.i].remove();
    }
}

