/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Iterator;

public final class CircularQueue
extends AbstractCollection {
    private static final int MAX_CAPACITY = 0x40000000;
    private static final int DEFAULT_CAPACITY = 256;
    private int size = 0;
    private int producerIndex = 0;
    private int consumerIndex = 0;
    private int capacity;
    private int maxCapacity;
    private int bitmask;
    private Object[] q;

    public CircularQueue() {
        this(256);
    }

    public CircularQueue(int n) {
        this(n, 0x40000000);
    }

    public CircularQueue(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("Capacity greater than maximum");
        }
        if (n2 > 0x40000000) {
            throw new IllegalArgumentException("Maximum capacity greater than allowed");
        }
        this.capacity = 1;
        while (this.capacity < n) {
            this.capacity <<= 1;
        }
        this.maxCapacity = 1;
        while (this.maxCapacity < n2) {
            this.maxCapacity <<= 1;
        }
        this.bitmask = this.capacity - 1;
        this.q = new Object[this.capacity];
    }

    private CircularQueue(CircularQueue circularQueue) {
        this.size = circularQueue.size;
        this.producerIndex = circularQueue.producerIndex;
        this.consumerIndex = circularQueue.consumerIndex;
        this.capacity = circularQueue.capacity;
        this.maxCapacity = circularQueue.maxCapacity;
        this.bitmask = circularQueue.bitmask;
        this.q = new Object[circularQueue.q.length];
        System.arraycopy(circularQueue.q, 0, this.q, 0, this.q.length);
    }

    private boolean expandQueue() {
        if (this.capacity == this.maxCapacity) {
            return false;
        }
        int n = this.capacity;
        Object[] objectArray = this.q;
        this.capacity += this.capacity;
        this.bitmask = this.capacity - 1;
        this.q = new Object[this.capacity];
        System.arraycopy(objectArray, this.consumerIndex, this.q, 0, n - this.consumerIndex);
        if (this.consumerIndex != 0) {
            System.arraycopy(objectArray, 0, this.q, n - this.consumerIndex, this.consumerIndex);
        }
        this.consumerIndex = 0;
        this.producerIndex = this.size;
        return true;
    }

    public boolean add(Object object) {
        if (this.size == this.capacity && !this.expandQueue()) {
            return false;
        }
        ++this.size;
        this.q[this.producerIndex] = object;
        this.producerIndex = this.producerIndex + 1 & this.bitmask;
        return true;
    }

    public Object remove() {
        if (this.size == 0) {
            return null;
        }
        --this.size;
        Object object = this.q[this.consumerIndex];
        this.q[this.consumerIndex] = null;
        this.consumerIndex = this.consumerIndex + 1 & this.bitmask;
        return object;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public Object peek() {
        if (this.size == 0) {
            return null;
        }
        return this.q[this.consumerIndex];
    }

    public void clear() {
        Arrays.fill(this.q, null);
        this.size = 0;
        this.producerIndex = 0;
        this.consumerIndex = 0;
    }

    public Object clone() {
        return new CircularQueue(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString() + " - capacity: '" + this.capacity() + "' size: '" + this.size() + "'");
        if (this.size > 0) {
            stringBuffer.append(" elements:");
            for (int i = 0; i < this.size; ++i) {
                stringBuffer.append('\n');
                stringBuffer.append('\t');
                stringBuffer.append(this.q[this.consumerIndex + i & this.bitmask].toString());
            }
        }
        return stringBuffer.toString();
    }

    public Iterator iterator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ int access$000(CircularQueue circularQueue) {
        return circularQueue.consumerIndex;
    }

    static /* synthetic */ int access$100(CircularQueue circularQueue) {
        return circularQueue.producerIndex;
    }

    static /* synthetic */ int access$200(CircularQueue circularQueue) {
        return circularQueue.size;
    }

    static /* synthetic */ Object[] access$300(CircularQueue circularQueue) {
        return circularQueue.q;
    }

    static /* synthetic */ int access$400(CircularQueue circularQueue) {
        return circularQueue.bitmask;
    }
}

