/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import weblogic.utils.AssertionError;
import weblogic.utils.BadOptionException;
import weblogic.utils.Getopt2;
import weblogic.utils.StringUtils;
import weblogic.utils.string.Sprintf;

public final class Getopt2
implements Cloneable {
    public static final boolean debug = false;
    private static final int ARG = 0;
    private static final int BOOL_FLAG = 1;
    private static final int ARG_FLAG = 2;
    private static final int COMPOSITE = 3;
    private static final int MULTI_FLAG = 4;
    private static final int ARG_N_FLAG = 5;
    private Hashtable options = new Hashtable();
    private Vector order = new Vector();
    private Hashtable optionNameMap = new Hashtable();
    private Hashtable alias2real = new Hashtable();
    private Hashtable real2alias = new Hashtable();
    private Hashtable values = new Hashtable();
    private String[] args;
    private int numCompound = 0;
    private boolean failOnUnrecognizedOpts = false;
    private static final String EOL = System.getProperty("line.separator");
    private String usageFooter = null;
    private String usageHeader = null;
    private String java = "java";
    private String usageArgs = null;

    public void setFailOnUnrecognizedOpts(boolean bl) {
        this.failOnUnrecognizedOpts = bl;
    }

    public String asCommandLine() {
        return this.asCommandLine(null, null);
    }

    public String[] asCommandArray() {
        return this.asCommandArray(null, null);
    }

    public String asCommandLine(String string) {
        return this.asCommandLine(null, string);
    }

    public String[] asCommandArray(String string) {
        return this.asCommandArray(null, string);
    }

    public String argsToString() {
        return StringUtils.join(this.args, " ");
    }

    public Object clone() {
        try {
            Getopt2 getopt2 = (Getopt2)super.clone();
            getopt2.options = this.options != null ? (Hashtable)this.options.clone() : null;
            getopt2.order = this.order != null ? (Vector)this.order.clone() : null;
            getopt2.optionNameMap = this.optionNameMap != null ? (Hashtable)this.optionNameMap.clone() : null;
            getopt2.alias2real = this.alias2real != null ? (Hashtable)this.alias2real.clone() : null;
            getopt2.real2alias = this.real2alias != null ? (Hashtable)this.real2alias.clone() : null;
            getopt2.values = this.values != null ? (Hashtable)this.values.clone() : null;
            getopt2.numCompound = this.numCompound;
            getopt2.failOnUnrecognizedOpts = this.failOnUnrecognizedOpts;
            if (this.args != null) {
                getopt2.args = new String[this.args.length];
                System.arraycopy(this.args, 0, getopt2.args, 0, this.args.length);
            } else {
                getopt2.args = null;
            }
            return getopt2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError("Clone not supported due to -- " + cloneNotSupportedException.getMessage());
        }
    }

    public Getopt2 grok(String[] stringArray) throws IllegalArgumentException {
        Option option;
        String string;
        Vector<String> vector = new Vector<String>();
        block14: for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            option = null;
            String string2 = null;
            String string3 = null;
            if (string.startsWith("-")) {
                string3 = string.substring(1);
                string2 = this.resolveName(string3);
                if (string2 != null) {
                    option = (Option)this.options.get(string2);
                } else if (this.failOnUnrecognizedOpts) {
                    throw new IllegalArgumentException("Unrecognized option or flag, " + string);
                }
            }
            if (option == null) {
                if (string.trim().equals("")) continue;
                vector.addElement(string);
                continue;
            }
            switch (option.type) {
                case 0: {
                    try {
                        option.value = stringArray[++i];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new IllegalArgumentException("Expecting arg after " + string);
                    }
                    this.values.put(string2, option);
                    continue block14;
                }
                case 1: {
                    option.value = "true";
                    this.values.put(string2, option);
                    continue block14;
                }
                case 2: {
                    option.value = string3.substring(string2.length());
                    this.values.put(string2, option);
                    continue block14;
                }
                case 3: {
                    String string4;
                    Option option2 = (Option)this.values.get("compiler");
                    if (option2 != null && option2.value.indexOf("javac") < 0 && option2.value.indexOf("sj") < 0) {
                        string4 = (Option)this.values.get(string2);
                        option.value = string4 != null && ((Option)string4).value != null ? ((Option)string4).value + " " + string3.substring(1) : string3.substring(1);
                        this.values.put(string2, option);
                        continue block14;
                    }
                    if (string3.length() == string2.length()) {
                        throw new IllegalArgumentException(string3 + " needs a valid option.");
                    }
                    string4 = string3.substring(string2.length());
                    if (!string4.startsWith("-")) {
                        string4 = "-" + string4;
                    }
                    option.subOptArgs.addElement(string4);
                    String string5 = option.subOpt.resolveName(string4.substring(1));
                    if (string5 == null) {
                        throw new IllegalArgumentException(string3 + " isn't a valid flag option.");
                    }
                    Option option3 = (Option)option.subOpt.options.get(string5);
                    if (option3 != null && option3.type == 0) {
                        try {
                            option.subOptArgs.addElement(stringArray[++i]);
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            throw new IllegalArgumentException("Expecting arg after " + string);
                        }
                    }
                    this.values.put(string2, option);
                    continue block14;
                }
                case 4: {
                    option.multiValue.addElement(stringArray[++i]);
                    continue block14;
                }
                case 5: {
                    try {
                        for (int j = 0; j < option.multiArgCount; ++j) {
                            option.multiValue.addElement(stringArray[++i]);
                        }
                        continue block14;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new IllegalArgumentException("Expecting arg after " + string);
                    }
                }
            }
        }
        this.args = new String[vector.size()];
        vector.copyInto(this.args);
        Enumeration enumeration = this.options.elements();
        while (enumeration.hasMoreElements()) {
            string = (Option)enumeration.nextElement();
            if (((Option)string).type != 3) continue;
            option = new String[((Option)string).subOptArgs.size()];
            ((Option)string).subOptArgs.copyInto((Object[])option);
            ((Option)string).subOpt.grok((String[])option);
        }
        return this;
    }

    public boolean hasAdvancedOptions() {
        Iterator iterator = this.options.values().iterator();
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            if (!option.isAdvanced || option.isPrivate) continue;
            return true;
        }
        return false;
    }

    public void addFlag(String string, String string2) {
        if (!this.options.containsKey(string)) {
            this.options.put(string, new Option(1, string, string2));
            this.optionNameMap.put(string.toLowerCase(), string);
            this.order.addElement(string);
        }
    }

    public void addAdvancedFlag(String string, String string2) {
        this.addFlag(string, string2);
        this.markAdvanced(string);
    }

    public void addOption(String string, String string2, String string3) {
        if (!this.options.containsKey(string)) {
            this.options.put(string, new Option(0, string, string3, string2));
            this.optionNameMap.put(string.toLowerCase(), string);
            this.order.addElement(string);
        }
    }

    public void addAdvancedOption(String string, String string2, String string3) {
        this.addOption(string, string2, string3);
        this.markAdvanced(string);
    }

    public void addArgFlag(String string, String string2, String string3) {
        if (!this.options.containsKey(string)) {
            this.options.put(string, new Option(2, string, string3, string2));
            this.optionNameMap.put(string.toLowerCase(), string);
            this.order.addElement(string);
            ++this.numCompound;
        }
    }

    public void addAdvancedArgFlag(String string, String string2, String string3) {
        this.addArgFlag(string, string2, string3);
        this.markAdvanced(string);
    }

    public void addMultiOption(String string, String string2, String string3) {
        if (!this.options.containsKey(string)) {
            this.options.put(string, new Option(4, string, string3, string2));
            this.optionNameMap.put(string.toLowerCase(), string);
            this.order.addElement(string);
            ++this.numCompound;
        }
    }

    public void addAdvancedMultiOption(String string, String string2, String string3) {
        this.addMultiOption(string, string2, string3);
        this.markAdvanced(string);
    }

    public void addNOption(String string, String string2, int n, String string3) {
        if (!this.options.containsKey(string)) {
            this.options.put(string, new Option(5, n, string, string2, string3));
            this.optionNameMap.put(string.toLowerCase(), string);
            this.order.addElement(string);
            ++this.numCompound;
        }
    }

    public void addAdvancedNOption(String string, String string2, int n, String string3) {
        this.addNOption(string, string2, n, string3);
        this.markAdvanced(string);
    }

    public void addSubOpt(String string, Getopt2 getopt2, String string2) {
        if (!this.options.containsKey(string)) {
            this.options.put(string, new Option(3, string, string2, null, getopt2));
            this.optionNameMap.put(string.toLowerCase(), string);
            this.order.addElement(string);
            ++this.numCompound;
        }
    }

    public void addAdvancedSubOpt(String string, Getopt2 getopt2, String string2) {
        this.addSubOpt(string, getopt2, string2);
        this.markAdvanced(string);
    }

    public void addAlias(String string, String string2) {
        this.alias2real.put(string, string2);
        this.real2alias.put(string2, string);
        this.optionNameMap.put(string.toLowerCase(), string);
    }

    public void markPrivate(String string) {
        ((Option)this.options.get((Object)string)).isPrivate = true;
    }

    public void markAdvanced(String string) {
        ((Option)this.options.get((Object)string)).isAdvanced = true;
    }

    public void addFlagsAndOptions(String[][] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = stringArray[i];
            if (stringArray2.length == 2) {
                this.addFlag(stringArray2[0], stringArray2[1]);
                continue;
            }
            this.addOption(stringArray2[0], stringArray2[1], stringArray2[2]);
        }
    }

    public void removeOption(String string) {
        this.optionNameMap.remove(string.toLowerCase());
        Option option = (Option)this.options.remove(string);
        if (option.type == 2) {
            --this.numCompound;
        }
        this.order.removeElement(string);
        this.values.remove(string);
        String string2 = (String)this.real2alias.remove(string);
        if (string2 != null) {
            this.alias2real.remove(string2);
        }
    }

    public void removeAlias(String string) {
        this.optionNameMap.remove(string.toLowerCase());
        String string2 = (String)this.alias2real.remove(string);
        if (string2 != null) {
            this.real2alias.remove(string2);
        }
    }

    public String[] args() {
        return this.args;
    }

    public boolean hasOption(String string) {
        return this.values.containsKey(this.dealias(string));
    }

    public boolean containsOption(String string) {
        if (this.values.containsKey(string)) {
            return true;
        }
        String string2 = (String)this.real2alias.get(string);
        return string2 != null && string2.length() > 0 && this.values.containsKey(string2);
    }

    public boolean hasOptions() {
        return !this.values.isEmpty();
    }

    public String getOption(String string) {
        return this.getOption(string, null);
    }

    public String getOption(String string, String string2) {
        String string3 = this.getOptValue(string);
        return string3 != null ? string3 : string2;
    }

    public String[] getMultiOption(String string, String[] stringArray) {
        Object[] objectArray = stringArray;
        Option option = (Option)this.options.get(this.dealias(string));
        Vector vector = null;
        if (null != option && null != (vector = option.multiValue)) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public String[] getNOption(String string, String[] stringArray) {
        return this.getMultiOption(string, stringArray);
    }

    public Getopt2 getSubOpt(String string) throws IllegalArgumentException {
        Option option = (Option)this.options.get(string);
        return option == null ? null : option.subOpt;
    }

    public boolean getBooleanOption(String string) {
        return this.getBooleanOption(string, false);
    }

    public boolean getBooleanOption(String string, boolean bl) {
        String string2 = this.getOptValue(string);
        if (string2 != null) {
            return Boolean.valueOf(string2);
        }
        return bl;
    }

    public int getIntegerOption(String string) throws IllegalArgumentException {
        return this.getIntegerOption(string, 0);
    }

    public int getIntegerOption(String string, int n) throws IllegalArgumentException {
        String string2 = this.getOptValue(string);
        if (string2 != null) {
            try {
                return Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Couldn't get integer value for " + string + ": " + numberFormatException);
            }
        }
        return n;
    }

    public void setFlag(String string, boolean bl) throws BadOptionException {
        Option option = (Option)this.options.get(this.dealias(string));
        if (option == null) {
            throw new BadOptionException("Can't set undeclared option " + string);
        }
        if (option.type != 1) {
            throw new BadOptionException(string + " isn't a flag option.");
        }
        if (bl) {
            option.value = "true";
            this.values.put(string, option);
        } else {
            option.value = null;
            this.values.remove(string);
        }
    }

    public void setOption(String string, String string2) throws BadOptionException {
        Option option = (Option)this.options.get(this.dealias(string));
        if (option == null) {
            throw new BadOptionException("Can't set undeclared option " + string);
        }
        option.value = string2;
        this.values.put(string, option);
    }

    public void setUsageHeader(String string) {
        while (string.endsWith("\n") || string.endsWith("\r")) {
            string = string.substring(0, string.length() - 1);
        }
        this.usageHeader = string;
    }

    public String getUsageHeader() {
        return this.usageHeader;
    }

    public String getUsageArgs() {
        return this.usageArgs;
    }

    public void setUsageFooter(String string) {
        this.usageFooter = string;
    }

    public void setJava(String string) {
        this.java = string;
    }

    public void setUsageArgs(String string) {
        this.usageArgs = string;
    }

    public void usageError(String string) {
        System.out.println(this.fullUsageMessage(string));
    }

    public void usageError(String string, boolean bl) {
        System.out.println(this.fullUsageMessage(string, bl));
    }

    public void usageAndExit(String string) {
        System.err.println(this.fullUsageMessage(string));
        System.exit(1);
    }

    public void usageAndExit(String string, boolean bl) {
        System.err.println(this.fullUsageMessage(string, bl));
        System.exit(1);
    }

    public String fullUsageMessage(String string) {
        return this.fullUsageMessage(string, false);
    }

    public String fullUsageMessage(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.usageHeader != null) {
            stringBuffer.append(this.usageHeader).append(EOL).append(EOL);
        }
        stringBuffer.append("Usage: ").append(this.java).append(" ").append(string).append(" [options] ");
        if (this.usageArgs != null) {
            stringBuffer.append(this.usageArgs);
        }
        stringBuffer.append(EOL).append(EOL).append("where options include:").append(EOL).append(this.usageMessage(bl)).toString();
        if (this.usageFooter != null) {
            stringBuffer.append(this.usageFooter);
        }
        return stringBuffer.toString();
    }

    public String usageMessage() {
        return this.usageMessage(false);
    }

    public String usageMessage(boolean bl) {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "    -%-16s %-45s" + string;
        String string3 = "%-21s %-45s" + string;
        Object[] objectArray = new Object[2];
        int n = this.order.size();
        for (int i = 0; i < n; ++i) {
            String string4 = (String)this.order.elementAt(i);
            Option option = (Option)this.options.get(string4);
            if (option.isPrivate || option.isAdvanced && !bl) continue;
            String string5 = option.paramName;
            String string6 = option.docString;
            objectArray[0] = string4 + option.paramString();
            int n2 = 67 - ((String)objectArray[0]).length();
            if (n2 > 45) {
                n2 = 45;
            }
            string2 = "    -%-16s %-" + n2 + "s" + string;
            if (string6.length() <= n2) {
                objectArray[1] = string6;
                stringBuffer.append(Sprintf.sprintf((String)string2, (Object[])objectArray));
                continue;
            }
            String string7 = this.getFront(string6, n2);
            objectArray[1] = string7.trim();
            stringBuffer.append(Sprintf.sprintf((String)string2, (Object[])objectArray));
            objectArray[0] = "";
            while (string6.length() > 0) {
                if ((string7 = this.getFront(string6 = string6.substring(string7.length()).trim(), 45)).length() <= 0) continue;
                objectArray[1] = string7;
                stringBuffer.append(Sprintf.sprintf((String)string3, (Object[])objectArray));
            }
        }
        return stringBuffer.toString();
    }

    private String getOptValue(String string) {
        Option option = (Option)this.values.get(this.dealias(string));
        return option == null ? null : option.value;
    }

    private String getFront(String string, int n) {
        if (n > string.length()) {
            return string;
        }
        BreakIterator breakIterator = BreakIterator.getLineInstance();
        breakIterator.setText(string);
        int n2 = breakIterator.first();
        int n3 = breakIterator.next();
        while (n3 != n && n3 != -1) {
            if (n3 - n2 > n) {
                n3 = breakIterator.previous();
                break;
            }
            n3 = breakIterator.next();
        }
        if (n3 != 0 && string.charAt(n3 - 1) == '-') {
            n3 = breakIterator.previous();
        }
        return n2 == n3 ? string : string.substring(n2, n3);
    }

    private String resolveName(String string) {
        Object object;
        String string2 = string.toLowerCase();
        String string3 = (String)this.optionNameMap.get(string2);
        if (string3 != null) {
            if (this.options.containsKey(string3)) {
                return string3;
            }
            object = (String)this.alias2real.get(string3);
            if (object != null) {
                return object;
            }
        }
        if (this.numCompound > 0) {
            object = this.options.elements();
            while (object.hasMoreElements()) {
                Option option = (Option)object.nextElement();
                String string4 = option.name;
                if (!string2.startsWith(string4.toLowerCase()) || option.type != 2 && option.type != 3 && option.type != 4) continue;
                return string4;
            }
        }
        return null;
    }

    private String dealias(String string) {
        if (this.options.containsKey(string)) {
            return string;
        }
        String string2 = (String)this.alias2real.get(string);
        return string2 == null ? string : string2;
    }

    private String[] asCommandArray(String string, String string2) {
        Enumeration<Object> enumeration = string2 != null ? new StringTokenizer(string2, ",") : this.values.keys();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            Option option = (Option)this.options.get(string3);
            if (string != null) {
                arrayList.add("-" + string);
            }
            String[] stringArray = option.toArgArray();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String asCommandLine(String string, String string2) {
        Enumeration<Object> enumeration = string2 != null ? new StringTokenizer(string2, ",") : this.values.keys();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            Option option = (Option)this.options.get(string3);
            if (string != null) {
                stringBuffer.append("-").append(string);
            }
            stringBuffer.append(option.toCommandLine());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ String access$000(Getopt2 getopt2, String string, String string2) {
        return getopt2.asCommandLine(string, string2);
    }

    static /* synthetic */ String[] access$100(Getopt2 getopt2, String string, String string2) {
        return getopt2.asCommandArray(string, string2);
    }
}

