/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Map;
import weblogic.common.ProxyAuthenticator;
import weblogic.net.http.ContentLengthOutputStream;
import weblogic.net.http.HttpClient;
import weblogic.net.http.HttpOutputStream;
import weblogic.net.http.HttpUnauthorizedException;
import weblogic.net.http.MessageHeader;
import weblogic.utils.encoders.BASE64Encoder;
import weblogic.utils.http.HttpReasonPhraseCoder;
import weblogic.utils.io.NullInputStream;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    private static final String version = System.getProperty("java.version");
    public static String userAgent;
    public static final boolean debug = false;
    private String httpVersion = "HTTP/1.0";
    private static final String acceptString = "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2";
    private static final int MAX_REDIRECTS = 5;
    private static final int MAX_TRIES = 3;
    private static final boolean KEEP_ALIVE = true;
    protected HttpClient http;
    protected HttpOutputStream ps = null;
    protected MessageHeader requests = new MessageHeader();
    protected MessageHeader responses = new MessageHeader();
    protected InputStream inputStream = null;
    protected ContentLengthOutputStream clenOS = null;
    protected UnsyncByteArrayOutputStream poster = null;
    protected boolean setRequests = false;
    private IOException rememberedException = null;
    protected int timeout = -1;
    private boolean wroteRequests = false;
    private static String proxyAuthString;

    protected String getProtocol() {
        return "http";
    }

    public HttpURLConnection(URL uRL) {
        super(uRL);
    }

    protected synchronized void writeRequests() throws IOException {
        if (this.wroteRequests) {
            return;
        }
        this.wroteRequests = true;
        if (!this.setRequests) {
            this.doSetRequests();
        }
        this.requests.print(this.ps);
        this.ps.flush();
        if (this.http != null) {
            this.http.setLastUsed(System.currentTimeMillis());
        }
        if (this.poster != null) {
            this.poster.writeTo((OutputStream)this.ps);
            this.ps.flush();
        }
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.http = HttpClient.New((URL)this.url, null, null, (int)this.timeout);
        this.ps = this.http.getOutputStream();
        this.connected = true;
    }

    protected HttpClient getHttpClient() throws IOException {
        return new HttpClient(this.url, null, null, this.timeout);
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        try {
            if (!this.doOutput) {
                throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
            }
            if (this.method.equals("GET")) {
                this.setRequestMethod("POST");
            }
            if (!"POST".equals(this.method) && !"PUT".equals(this.method) && this.getProtocol().equals(this.url.getProtocol())) {
                throw new ProtocolException("HTTP method " + this.method + " doesn't support output");
            }
            if (this.inputStream != null) {
                throw new ProtocolException("Cannot write output after reading input.");
            }
            this.connect();
            this.ps = this.http.getOutputStream();
            String string = this.getRequestProperty("Content-Length");
            if (string != null) {
                int n = Integer.parseInt(string);
                this.clenOS = new ContentLengthOutputStream((OutputStream)this.ps, n);
                this.writeRequests();
                return this.clenOS;
            }
            if (this.poster == null) {
                this.poster = new UnsyncByteArrayOutputStream();
            } else {
                this.poster.reset();
            }
            return this.poster;
        }
        catch (RuntimeException runtimeException) {
            this.disconnect();
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
    }

    protected static String getProxyAuthString() {
        return proxyAuthString;
    }

    public static String getAuthInfo(String string, int n, String string2) throws IOException {
        String string3 = System.getProperty("weblogic.net.proxyAuthenticatorClassName");
        if (string3 == null || string2 == null) {
            throw new HttpUnauthorizedException("Proxy or Server Authentication Required");
        }
        ProxyAuthenticator proxyAuthenticator = null;
        String string4 = null;
        String string5 = null;
        String string6 = string2.trim();
        int n2 = string6.indexOf(32);
        if (n2 == -1) {
            string4 = string6;
            string5 = "Login to Proxy";
        } else {
            string4 = string6.substring(0, n2);
            string5 = string6.substring(n2 + 1);
            if ((n2 = string5.indexOf(61)) != -1) {
                string5 = string5.substring(n2 + 1);
            }
        }
        try {
            proxyAuthenticator = (ProxyAuthenticator)Class.forName(string3).newInstance();
        }
        catch (Exception exception) {
            throw new HttpUnauthorizedException("Proxy authenticator " + string3 + " failed: " + exception);
        }
        proxyAuthenticator.init(string, n, string4, string5);
        String[] stringArray = proxyAuthenticator.getLoginAndPassword();
        if (stringArray == null || stringArray.length != 2) {
            throw new HttpUnauthorizedException("Proxy authentication failed");
        }
        String string7 = stringArray[0] + ':' + stringArray[1];
        byte[] byArray = string7.getBytes();
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        String string8 = "Basic " + bASE64Encoder.encodeBuffer(byArray);
        return string8;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Cannot read from URLConnection if doInput=false (call setDoInput(true))");
        }
        if (this.responseCode >= 400 && this.rememberedException != null) {
            throw this.rememberedException;
        }
        if (this.inputStream != null) {
            if (this.http != null) {
                this.http.setLastUsed(System.currentTimeMillis());
            }
            return this.inputStream;
        }
        if (this.clenOS != null) {
            try {
                this.clenOS.close();
            }
            catch (IOException iOException) {
                this.disconnect();
                throw iOException;
            }
        }
        int n = 0;
        int n2 = 0;
        int n3 = 3;
        String string = this.url.getFile();
        if (string != null && string.startsWith("/__iiop")) {
            n3 <<= 1;
        }
        do {
            String string2;
            try {
                this.connect();
                this.ps = this.http.getOutputStream();
                this.writeRequests();
                this.http.parseHTTP(this.responses, this.httpVersion.equals("HTTP/1.1"));
            }
            catch (HttpUnauthorizedException httpUnauthorizedException) {
                this.disconnect();
                this.wroteRequests = false;
                this.setRequests = false;
                this.requests = new MessageHeader();
                string2 = new String("-Authenticate: Basic Realm=WebLogic Realm");
                proxyAuthString = HttpURLConnection.getAuthInfo(this.getURL().getHost(), this.getURL().getPort(), httpUnauthorizedException.getMessage() + string2);
                continue;
            }
            catch (ConnectException connectException) {
                throw connectException;
            }
            catch (InterruptedIOException interruptedIOException) {
                throw interruptedIOException;
            }
            catch (IOException iOException) {
                if (++n2 >= n3) {
                    throw iOException;
                }
                this.wroteRequests = false;
                if (this.http != null) {
                    this.http.closeServer();
                }
                try {
                    Thread.sleep(n2 * 100);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.connected = false;
                this.http = this.getHttpClient();
                this.connected = true;
                continue;
            }
            this.inputStream = new /* Unavailable Anonymous Inner Class!! */;
            if (this.followRedirect()) {
                this.wroteRequests = false;
                ++n;
                if (this.url.getProtocol().startsWith("http")) continue;
                if (this.http != null) {
                    this.http.setLastUsed(System.currentTimeMillis());
                }
                return this.url.openStream();
            }
            if (this.method.equals("HEAD") || this.method.equals("TRACE")) {
                this.disconnect();
                if (this.http != null) {
                    this.http.setLastUsed(System.currentTimeMillis());
                }
                this.inputStream = new NullInputStream();
                return this.inputStream;
            }
            int n4 = this.getResponseCode();
            if (n4 == 407) {
                this.disconnect();
                this.wroteRequests = false;
                proxyAuthString = HttpURLConnection.getAuthInfo(HttpClient.proxyHost, HttpClient.proxyPort, this.responses.findValue("Proxy-Authenticate"));
                if (proxyAuthString == null) continue;
                this.requests.set("Proxy-Authorization", proxyAuthString);
                continue;
            }
            string2 = this.url.getFile();
            if (n4 >= 400) {
                String string3 = HttpReasonPhraseCoder.getReasonPhrase((int)n4);
                throw new FileNotFoundException("Response: '" + n4 + ": " + string3 + "' for url: '" + this.url.toString() + "'");
            }
            if (this.http != null) {
                this.http.setLastUsed(System.currentTimeMillis());
            }
            return this.inputStream;
        } while (n < 5);
        throw new ProtocolException("Server redirected too many times (" + n + ")");
    }

    public InputStream getErrorStream() {
        if (this.http != null) {
            this.http.setLastUsed(System.currentTimeMillis());
        }
        if (this.connected && this.responseCode >= 400) {
            return this.inputStream;
        }
        return null;
    }

    protected boolean followRedirect() throws IOException {
        if (!this.getInstanceFollowRedirects()) {
            return false;
        }
        int n = this.getResponseCode();
        if (n < 300 || n > 305 || n == 304) {
            return false;
        }
        String string = this.getHeaderField("Location");
        if (string == null) {
            return false;
        }
        this.disconnect();
        MessageHeader messageHeader = this.responses;
        this.responses = new MessageHeader();
        int n2 = 0;
        while (true) {
            String string2 = messageHeader.getKey(n2);
            String string3 = messageHeader.getValue(n2);
            if (string2 == null && string3 == null) break;
            if (string2 != null && string3 != null && string2.equalsIgnoreCase("Set-Cookie")) {
                this.responses.add(string2, string3);
            }
            ++n2;
        }
        if (n == 305) {
            URL uRL = new URL(string);
            this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + this.httpVersion, null);
            this.connected = true;
        } else {
            this.url = new URL(this.url, string);
            if (!this.url.getProtocol().startsWith(this.getProtocol())) {
                return true;
            }
            if (this.method.equals("POST") && !Boolean.getBoolean("http.strictPostRedirect")) {
                this.requests = new MessageHeader();
                this.setRequests = false;
                this.setRequestMethod("GET");
                this.poster = null;
                this.connect();
            } else {
                this.connect();
                this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + this.httpVersion, null);
                this.requests.set("Host", this.url.getHost() + (this.url.getPort() == -1 || this.url.getPort() == 80 ? "" : ":" + String.valueOf(this.url.getPort())));
            }
        }
        return true;
    }

    public void disconnect() {
        this.responseCode = -1;
        if (this.http != null) {
            this.http.closeServer();
            this.http = null;
            this.connected = false;
        }
    }

    public boolean usingProxy() {
        if (this.http != null) {
            return this.http.usingProxy;
        }
        return false;
    }

    public String getHeaderField(String string) {
        block2: {
            try {
                this.getInputStream();
            }
            catch (IOException iOException) {
                if (!(iOException instanceof SocketTimeoutException)) break block2;
                this.rememberedException = iOException;
            }
        }
        return this.responses.findValue(string);
    }

    public Map getHeaderFields() {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.getHeaders();
    }

    public String getHeaderField(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.getValue(n);
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.getKey(n);
    }

    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (string.length() > 0 && string2.length() > 0) {
            if ("Set-Cookie".equalsIgnoreCase(string)) {
                this.requests.add(string, string2);
            } else {
                this.requests.set(string, string2);
            }
        }
    }

    public void setEmptyRequestProperty(String string) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (string.length() > 0) {
            if ("Set-Cookie".equalsIgnoreCase(string)) {
                this.requests.add(string, "");
            } else {
                this.requests.set(string, "");
            }
        }
    }

    public String getRequestProperty(String string) {
        return this.requests.findValue(string);
    }

    String getMethod() {
        return this.method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetRequests() {
        this.requests.prepend(this.method + " " + this.http.getURLFile() + " " + this.httpVersion, null);
        this.requests.setIfNotSet("User-Agent", userAgent);
        int n = this.url.getPort();
        String string = this.url.getHost();
        if (n != -1 && n != 80) {
            string = string + ":" + String.valueOf(n);
        }
        this.requests.setIfNotSet("Host", string);
        this.requests.setIfNotSet("Accept", acceptString);
        if (proxyAuthString != null) {
            this.requests.set("Proxy-Authorization", proxyAuthString);
        }
        if (this.http.usingProxy) {
            this.requests.setIfNotSet("Proxy-Connection", "Keep-Alive");
        } else {
            this.requests.setIfNotSet("Connection", "Keep-Alive");
        }
        if (this.poster != null) {
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = this.poster;
            synchronized (unsyncByteArrayOutputStream) {
                this.requests.setIfNotSet("Content-Type", "application/x-www-form-urlencoded");
                this.requests.set("Content-Length", String.valueOf(this.poster.size()));
            }
        }
        this.setRequests = true;
    }

    public void setTimeout(int n) {
        this.timeout = n;
        if (this.http != null) {
            this.http.setTimeout(n);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getResponseCode() throws IOException {
        if (this.responseCode != -1) {
            return this.responseCode;
        }
        if (this.rememberedException != null && this.rememberedException instanceof SocketTimeoutException) {
            throw this.rememberedException;
        }
        IOException iOException = null;
        try {
            this.getInputStream();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.rememberedException = socketTimeoutException;
            throw socketTimeoutException;
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        String string = this.getHeaderField(0);
        if (string == null && iOException != null) {
            throw iOException;
        }
        this.rememberedException = iOException;
        try {
            int n = string.indexOf(32);
            while (string.charAt(n) == ' ') {
                ++n;
            }
            this.responseCode = Integer.parseInt(string.substring(n, n + 3));
            this.responseMessage = string.substring(n + 4).trim();
            return this.responseCode;
        }
        catch (Exception exception) {
            return this.responseCode;
        }
    }

    public void u11() {
        this.httpVersion = "HTTP/1.1";
    }

    static {
        try {
            userAgent = System.getProperty("http.agent", "Java" + version);
        }
        catch (SecurityException securityException) {
            userAgent = "Java" + version;
        }
        proxyAuthString = null;
    }
}

