/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.rpc;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;

public abstract class ServiceFactory {
    public static final String SERVICEFACTORY_PROPERTY = "javax.xml.rpc.ServiceFactory";
    private static final String DEFAULT_SERVICEFACTORY = "com.sun.xml.rpc.client.ServiceFactoryImpl";

    protected ServiceFactory() {
    }

    public static ServiceFactory newInstance() throws ServiceException {
        String factoryImplName = System.getProperty(SERVICEFACTORY_PROPERTY, DEFAULT_SERVICEFACTORY);
        try {
            Class<?> clazz = Class.forName(factoryImplName);
            return (ServiceFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException(e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException(e);
        }
        catch (InstantiationException e) {
            throw new ServiceException(e);
        }
    }

    public abstract Service createService(URL var1, QName var2) throws ServiceException;

    public abstract Service createService(QName var1) throws ServiceException;
}

