/*
 * Decompiled with CFR 0.152.
 */
package o75d.exe.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public final class O75PostHttpUrlConnection {
    private String url = null;
    private HttpURLConnection conexion = null;
    private OutputStream output = null;
    private ObjectOutputStream objectOutputStream = null;
    private InputStream input = null;
    private ObjectInputStream objectInputStream = null;
    private boolean conexionCerrada = false;

    public O75PostHttpUrlConnection() {
    }

    public O75PostHttpUrlConnection(String url) throws Exception {
        this.setUrl(url);
        this.crearConexionHttp();
    }

    public O75PostHttpUrlConnection(String url, String sesionHttp) throws Exception {
        this.setUrl(url);
        this.crearConexionHttp(sesionHttp);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setConexion(HttpURLConnection conexion) {
        this.conexion = conexion;
    }

    public void setOutputStream(OutputStream output) {
        this.output = output;
    }

    public void setObjectOutputStream(ObjectOutputStream objectOutputStream) {
        this.objectOutputStream = objectOutputStream;
    }

    public void setInputStream(InputStream input) {
        this.input = input;
    }

    public void setObjectInputStream(ObjectInputStream objectInputStream) {
        this.objectInputStream = objectInputStream;
    }

    private void setConexionCerrada(boolean conexionCerrada) {
        this.conexionCerrada = conexionCerrada;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpURLConnection getConexion() {
        return this.conexion;
    }

    public OutputStream getOutputStream() {
        return this.output;
    }

    public ObjectOutputStream getObjectOutputStream() {
        return this.objectOutputStream;
    }

    public InputStream getInputStream() {
        return this.input;
    }

    public ObjectInputStream getObjectInputStream() {
        return this.objectInputStream;
    }

    public boolean getConexionCerrada() {
        return this.conexionCerrada;
    }

    private void crearConexionHttp() throws Exception {
        URL urlDestino = null;
        HttpURLConnection connection = null;
        urlDestino = new URL(this.getUrl());
        connection = (HttpURLConnection)urlDestino.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(true);
        HttpURLConnection.setFollowRedirects(false);
        this.setConexion(connection);
        urlDestino = null;
        connection = null;
    }

    private void crearConexionHttp(String sesion) throws Exception {
        URL urlDestino = null;
        HttpURLConnection connection = null;
        urlDestino = new URL(this.getUrl());
        connection = (HttpURLConnection)urlDestino.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(true);
        HttpURLConnection.setFollowRedirects(false);
        connection.setRequestProperty("Cookie", "WebLogicSession=" + sesion);
        this.setConexion(connection);
        urlDestino = null;
        connection = null;
    }

    public boolean enviarObjeto(Object objeto) throws Exception {
        if (this.getOutputStream() == null) {
            this.setOutputStream(this.getConexion().getOutputStream());
        }
        if (this.getObjectOutputStream() == null) {
            this.setObjectOutputStream(new ObjectOutputStream(this.getOutputStream()));
        }
        this.getObjectOutputStream().writeObject(objeto);
        return this.getConexion().getResponseCode() == 200;
    }

    private boolean enviarArrayBytes(byte[] arrayBytes) throws Exception {
        this.getConexion().setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        this.getConexion().setRequestProperty("Content-length", Integer.toString(arrayBytes.length));
        if (this.getOutputStream() == null) {
            this.setOutputStream(this.getConexion().getOutputStream());
        }
        this.getOutputStream().write(arrayBytes);
        arrayBytes = null;
        return this.getConexion().getResponseCode() == 200;
    }

    public boolean enviarString(String envio) throws Exception {
        return this.enviarArrayBytes(envio.getBytes());
    }

    public Object recibirObjeto() throws Exception {
        if (this.getInputStream() == null) {
            this.setInputStream(this.getConexion().getInputStream());
        }
        if (this.getObjectInputStream() == null) {
            this.setObjectInputStream(new ObjectInputStream(this.getInputStream()));
        }
        Object recibido = this.getObjectInputStream().readObject();
        return recibido;
    }

    public String recibirTexto() throws Exception {
        StringBuffer texto = null;
        BufferedReader bufferedReader = null;
        String linea = null;
        if (this.getInputStream() == null) {
            this.setInputStream(this.getConexion().getInputStream());
        }
        bufferedReader = new BufferedReader(new InputStreamReader(this.getInputStream()));
        texto = new StringBuffer();
        while ((linea = bufferedReader.readLine()) != null) {
            texto.append(linea);
        }
        return texto.toString();
    }

    public void cerrarConexionHttp() throws Exception {
        if (this.getObjectOutputStream() != null) {
            this.getObjectOutputStream().close();
        }
        if (this.getOutputStream() != null) {
            this.getOutputStream().close();
        }
        if (this.getObjectInputStream() != null) {
            this.getObjectInputStream().close();
        }
        if (this.getInputStream() != null) {
            this.getInputStream().close();
        }
        if (this.getConexion() != null) {
            this.getConexion().disconnect();
        }
        this.setConexionCerrada(true);
    }
}

