/*
 * Decompiled with CFR 0.152.
 */
package o75d.exe;

import java.io.StringWriter;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import n38c.exe.N38API;
import o75d.exe.O75Fichero;
import o75d.exe.O75Listado;
import o75d.exe.O75Peticion;
import o75d.exe.utils.O75APIParserXML;
import o75d.exe.utils.O75Cfg;
import o75d.exe.utils.O75Constantes;
import o75d.exe.utils.O75Errores;
import o75d.exe.utils.O75PostHttpUrlConnection;
import o75d.exe.utils.O75Resultado;
import org.w3c.dom.Document;

public class O75API {
    public static final String TIPO_BATCH = "B";
    public static final String TIPO_DIRECTO = "D";
    public static final String SUBTIPO_RELANZABLE = "R";
    public static final String SUBTIPO_NORELANZABLE = "N";
    public static final String TIPOPET_USUARIO = "U";
    public static final String TIPOPET_ROLTIPO = "T";
    public static final int PRIORIDAD_NORMAL = 1;
    public static final int PRIORIDAD_ALTA = 0;
    public static final String RUNTIME_SH = "sh";
    public static final String ESTADO_FINALIZADA = "FI";
    public static final String ESTADO_EJECUCION = "EJ";
    public static final String ESTADO_PREPARADA = "PR";
    public static final String ESTADO_PENDIENTE = "PE";
    public static final String ESTADO_CANCELADA = "CA";
    public static final String ESTADO_ERRORSISTEMA = "ES";
    public static final String ESTADO_ERRORAPLICACION = "ER";
    public static final String ESTADO_IMPRIMIENDO = "IM";
    public static final String ESTADO_IMPRESO = "PS";
    public static final String TIPOEJ_INMEDIATO = "*";
    public static final String DISPOSICION_SALVAR = "1";
    public static final String DISPOSICION_ELIMINAR = "0";
    private String O75DCFG = "/config/o75d/o75d.properties";
    private O75Resultado result = null;
    private String sXMLSesion = null;
    private O75Constantes ctes = null;
    private String URLAPISERVLET = null;

    private void Configuracion() {
        this.ctes = new O75Constantes();
        O75Constantes.CargarVariables();
        String sO75DCfg = System.getProperty("O75DCFG");
        if (null == sO75DCfg) {
            sO75DCfg = this.O75DCFG;
        }
        O75Cfg O75Dcfg = new O75Cfg(sO75DCfg);
        this.URLAPISERVLET = O75Dcfg.O75VarConfiguracion("URLAPISERVLET");
    }

    public O75API(HttpServletRequest req) {
        this.Configuracion();
        N38API n38api = new N38API(req);
        this.XMLSesionDeDoc(n38api.n38ItemSesion());
    }

    public O75API(String sxmlses) {
        this.Configuracion();
        this.sXMLSesion = sxmlses;
        this.result = new O75Resultado(O75Errores.O75API_ERRINDET, "O75API(String sxmlses)");
    }

    public O75API(Document doc) {
        this.Configuracion();
        this.XMLSesionDeDoc(doc);
    }

    private void XMLSesionDeDoc(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "no");
            transformer.transform(domSource, result);
            this.sXMLSesion = stringWriter.toString();
            this.result = new O75Resultado(O75Errores.O75API_CORRECTO, "O75API(HttpServletRequest req)");
        }
        catch (TransformerException e) {
            this.sXMLSesion = null;
            this.result = new O75Resultado(O75Errores.ERR_DOC_SESION, "O75API(HttpServletRequest req) " + e.getMessage());
            System.out.println("XMLSesionDeDoc: " + e.getMessage());
        }
        catch (Exception e) {
            this.sXMLSesion = null;
            this.result = new O75Resultado(O75Errores.ERR_DOC_SESION, "O75API(HttpServletRequest req) " + e.getMessage());
            System.out.println("XMLSesionDeDoc: " + e.getMessage());
        }
    }

    private int APIHTTPEjecutar(Object obj, int nTipoOp) {
        Object objapi;
        if (null == obj) {
            this.result = new O75Resultado(O75Errores.O75API_OBJ_NULO, "APIHTTPEjecutar");
            return this.GetCodigoError();
        }
        if (null == this.sXMLSesion) {
            this.result = new O75Resultado(O75Errores.ERR_XMLSESION_NULO, "APIHTTPEjecutar");
            return this.GetCodigoError();
        }
        String sXML = null;
        int nTipo = 0;
        if (obj instanceof O75Peticion) {
            objapi = (O75Peticion)obj;
            sXML = ((O75Peticion)objapi).GetXML(nTipoOp);
            nTipo = 1;
        } else if (obj instanceof O75Listado) {
            objapi = (O75Listado)obj;
            sXML = ((O75Listado)objapi).GetXML(nTipoOp);
            nTipo = 2;
        } else if (obj instanceof O75Fichero) {
            objapi = (O75Fichero)obj;
            sXML = ((O75Fichero)objapi).GetXML(nTipoOp);
            nTipo = 3;
        } else {
            this.result = new O75Resultado(O75Errores.ERR_API_OBJ_DESC, "O75.Consultar. Objeto inv\u00e1lido: " + obj.getClass().getName());
            return this.GetCodigoError();
        }
        try {
            System.out.println("APIHTTPEjecutar. sXML - > \n" + sXML);
            System.out.println("------------------");
            O75PostHttpUrlConnection conexion = new O75PostHttpUrlConnection(this.URLAPISERVLET);
            conexion.enviarString("XML=1&XMLSESION=" + this.sXMLSesion + "&XMLAPI=" + sXML);
            String recibido = conexion.recibirTexto();
            System.out.println("------------------");
            System.out.println("O75API. recibido:" + recibido);
            O75APIParserXML apiparser = new O75APIParserXML(recibido);
            this.result = apiparser.ParsearXMLResultado(nTipo, obj);
            conexion.cerrarConexionHttp();
        }
        catch (Exception e) {
            System.out.println("EXCEPCION - > " + e.getMessage());
            e.printStackTrace();
            this.result = new O75Resultado(O75Errores.O75API_ERRINDET, "APIHTTPEjecutar. Excepcion: " + e.getMessage());
        }
        return this.GetCodigoError();
    }

    public int Alta(Object obj) {
        return this.APIHTTPEjecutar(obj, 1);
    }

    public int Consultar(Object obj) {
        return this.APIHTTPEjecutar(obj, 3);
    }

    public int Eliminar(Object obj) {
        return this.APIHTTPEjecutar(obj, 2);
    }

    public int Lanzar(O75Peticion Pet) {
        return this.APIHTTPEjecutar(Pet, 4);
    }

    public int PrepPte(O75Peticion Pet) {
        return this.APIHTTPEjecutar(Pet, 5);
    }

    public int Ejecutar(O75Peticion Pet) {
        return this.APIHTTPEjecutar(Pet, 6);
    }

    public int GetCodigoError() {
        return this.result.GetCodigoError();
    }

    public String GetDec() {
        return this.result.GetDec();
    }

    public String GetDee() {
        return this.result.GetDee();
    }

    public String GetMotivo() {
        return this.result.GetMotivo();
    }

    public int GetCodigoErrorSQL() {
        return this.result.GetCodigoErrorSQL();
    }
}

