<?php
// $Id: views-view-table.tpl.php,v 1.8.2.2 2010/12/08 23:17:31 merlinofchaos Exp $
/**
 * @file views-view-table.tpl.php
 * Template to display a view as a table.
 *
 * - $title : The title of this group of rows.  May be empty.
 * - $header: An array of header labels keyed by field id.
 * - $header_classes: An array of header classes keyed by field id.
 * - $fields: An array of CSS IDs to use for each field id.
 * - $class: A class or classes to apply to the table, based on settings.
 * - $row_classes: An array of classes to apply to each row, indexed by row
 *   number. This matches the index in $rows.
 * - $rows: An array of row items. Each row is an array of content.
 *   $rows are keyed by row number, fields within rows are keyed by field ID.
 * - $field_classes: An array of classes to apply to each field, indexed by
 *   field id, then row number. This matches the index in $rows.
 * @ingroup views_templates
 */
?>
<ul id="dqhList">
    <?php foreach ($rows as $count => $row): ?>
        <?php foreach ($row as $field => $content): ?>
			<li>
				<span class="dqhTitle"><?php print $header[$field]; ?>:</span><span class="dqhValue"> <?php print $content; ?></span>
			</li>
        <?php endforeach; ?>
   <?php endforeach; ?>
</ul>

