<?php
/*
   Copyright 2009-2011 United States Government. 

   This software is licensed under the GNU General Public License
   version 2 (see the file LICENSE for details)
*/

//Add current page to the end of breadcrumbs
function opendashboard_breadcrumb($breadcrumb) {
  if (!empty($breadcrumb)) {
    $title = drupal_get_title();
	$breadcrumb[] = '<div class="breadcrumb-current">'. $title .'</div>';
    return '<div class="breadcrumb">' . implode(' &raquo ', $breadcrumb) . '</div>';
  }
}

function opendashboard_preprocess_views_exposed_form(&$vars, $hook) {
  // only alter the search view exposed filter form
  //if ($vars['form']['#id'] == 'views-exposed-form-performance-metrics-page-1') {
	//add image button to pager form
    $vars['form']['button']['submit']['#value'] = 'Go';
    $vars['form']['button']['submit']['#name'] = 'Go';
	$vars['form']['button']['submit']['#type'] = 'image_button';
	$vars['form']['button']['submit']['#src'] = drupal_get_path('theme', 'opendashboard') . '/images/go_bg.gif';
	$vars['form']['button']['submit']['#prefix'] ='<div class="go-button">';
	$vars['form']['button']['submit']['#suffix'] ='</div>';
    $vars['button'] = drupal_render($vars['form']['button']['submit']);
  //}

}


function opendashboard_pager($tags = array(), $limit = 10, $element = 0, $parameters = array(), $quantity = 9) {
	global $pager_page_array, $pager_total_items, $pager_total;
    $my_view = views_get_current_view();

    $items_per_page = isset($my_view->exposed_input['items_per_page']) ? $my_view->exposed_input['items_per_page'] : $my_view->exposed_data['items_per_page'];

    if($items_per_page == 'All') {
        $totalItems = count($my_view->result);
        $overview = "Mostrando registros: 1- $totalItems  de $totalItems registros.";
    }
    else if ($pager_total_items[0] > 0) {
        if ($pager_total[0] == 1) {
          $overview = "Mostrando registros: 1-$pager_total_items[0] de $pager_total_items[0] registros.";
        } else {
            $start = 1 + (($pager_page_array[0]) * $items_per_page);
            $end = (1 + $pager_page_array[0]) * $items_per_page;
            if ($end > $pager_total_items[0]) $end = $pager_total_items[0];
            $overview = "Mostrando registros: $start-$end de $pager_total_items[0] registros.";
        }
    }

  // Calculate various markers within this pager piece:
  // Middle is used to "center" pages around the current page.
  $pager_middle = ceil($quantity / 2);
  // current is the page we are currently paged to
  $pager_current = $pager_page_array[$element] + 1;
  // max is the maximum page number
  $pager_max = $pager_total[$element];
  // first is the first page listed by this pager piece (re quantity)
  $pager_first = $pager_current - $pager_middle + 1;
  // last is the last page listed by this pager piece (re quantity)
  $pager_last = $pager_current + $quantity - $pager_middle;
  // End of marker calculations.
	
	//add overview to items array. 
	$items[] = array(
		'class' => 'overview',
		'data' => $overview,
	);
	
  $li_first = theme('pager_first', (isset($tags[0]) ? $tags[0] : t('Primero')), $limit, $element, $parameters);
  $li_previous = theme('pager_previous', (isset($tags[1]) ? $tags[1] : t('Anterior')), $limit, $element, 1, $parameters);
  $li_next = theme('pager_next', (isset($tags[3]) ? $tags[3] : t('Siguiente')), $limit, $element, 1, $parameters);
  $li_last = theme('pager_last', (isset($tags[4]) ? $tags[4] : t('Ultimo')), $limit, $element, $parameters);
  
  // When there is more than one page, create the pager list.
  if($pager_max > 1){
	    if ($i != $pager_max) {
	    	$items[] = array(
		      'class' => 'pager-first',
		      'data' => $li_first,
		    );
			
	    	$items[] = array(
		      'class' => 'pager-previous',
		      'data' => $li_previous,
		    );
	
	      // Now generate the actual pager piece.
	      for (; $i <= $pager_last && $i <= $pager_max; $i++) {
	        if ($i < $pager_current) {
	          $items[] = array(
	            'class' => 'pager-item',
	            'data' => theme('pager_previous', $i, $limit, $element, ($pager_current - $i), $parameters),
	          );
	        }
	        if ($i == $pager_current) {
	                                
	          $items[] = array(
	            'class' => 'pager-current',
	            'data' => $i,
	          );
	        }
	        if ($i > $pager_current) {
	        	$items[] = array(
	           'class' => 'pager-item',
	            'data' => theme('pager_next', $i, $limit, $element, ($i - $pager_current), $parameters),
	          );
	
	        }
	      }
	
			$items[] = array(
		      'class' => 'pager-next',
		      'data' => $li_next,
		    );
			
			$items[] = array(
		      'class' => 'pager-last',
		      'data' => $li_last,
		    );
	    }
	  else {
	      $items[] = array(
	        'class' => 'pager-previous',
	        'data' => $li_previous,
	      );
	  }
   }
	return theme('item_list', $items, NULL, 'ul', array('class' => 'pager'));
}