<?php
/*
   Copyright 2009-2011 United States Government. 

   This software is licensed under the GNU General Public License
   version 2 (see the file LICENSE for details)
*/

/*
Purpose: Module to update data quality repots. Needs to be run as a cron once in a day
Parameters: Unknown
*/

$resultArray = array();
foreach($view->result as $row){
	$resultArray[$row->node_data_field_business_case_id_field_metric_type_value]=$row->node_data_field_business_case_id_field_metric_value_value;
}

$incomplete_inaccurate_data = array();
$incomplete_inaccurate_data[] = array("Number of milestones missing a planned completion date:",
									data_quality_detail_report_apply_asterisk($resultArray['sum_milestones_no_plannedcompletiondate'],FALSE));
$incomplete_inaccurate_data[] = array("Number of milestones missing a planned start date:",
									data_quality_detail_report_apply_asterisk($resultArray['sum_milestones_no_plannedstartdate'],FALSE));
$incomplete_inaccurate_data[] = array("Number of milestones with a planned completion date in the past but without planned percent complete at 100%:",
									data_quality_detail_report_apply_asterisk($resultArray['sum_milestones_past_plannedcompdate_plannedperccomp_not100'],FALSE));
$incomplete_inaccurate_data[] = array("Number of milestones with no planned costs:",
									data_quality_detail_report_apply_asterisk($resultArray['sum_milestones_no_currentplannedtotalcost'],FALSE));
$incomplete_inaccurate_data[] = array("Is the overall investment categorized as operations and maintenance, but plans to conduct development and modernization spending?:",
									data_quality_detail_report_apply_asterisk($resultArray['om_with_dmecosts'],TRUE));
$incomplete_inaccurate_data[] = array("Number of baseline events, such as changing the investment's milestone's planned costs, missing a comment from the agency:",
									data_quality_detail_report_apply_asterisk($resultArray['sum_baselines_nocomments'],FALSE));
$incomplete_inaccurate_data[] = array("Number of milestones where planned start date is in the past but planned percent complete is still 0%:",
									data_quality_detail_report_apply_asterisk($resultArray['sum_milestones_past_plannedstartdate_plannedperccomp_0'],FALSE));
$incomplete_inaccurate_data[] = array("Number of milestones with an actual completion date but without planned percent complete at 100%:",
									data_quality_detail_report_apply_asterisk($resultArray['sum_milestones_actualcompletiondate_plannedperccomp_not100'],FALSE));
$incomplete_inaccurate_data[] = array("Number of milestones with planned percent complete at 100% but without an actual completion date:",
									data_quality_detail_report_apply_asterisk($resultArray['sum_milestones_plannedperccomp100_no_actualcompdate'],FALSE));

$long_large_milestones = array();
$long_large_milestones[] = array("Does the investment have any milestones with a duration greater than a year?:",
								data_quality_detail_report_apply_asterisk($resultArray['ms_duration_greater_than_year'],TRUE));
$long_large_milestones[] = array("Does the investment have a milestone whose planned cost is greater than 25% of the investment's milestones' planned total planned costs?:",
								data_quality_detail_report_apply_asterisk($resultArray['ms_planned_cost_more_25perc_total_planned_cost'],TRUE));
$long_large_milestones[] = array("Average duration of milestones for this investment(days):",round($resultArray['avg_milestone_duration'],0));
$long_large_milestones[] = array("Duration of the longest milestone for this investment(days):",$resultArray['max_milestone_duration']);

$poor_contract_data_quality = array();
$poor_contract_data_quality[] = array("Total number of contracts listed:",$resultArray['sum_contracts']);
$poor_contract_data_quality[] = array("Number of awarded contracts listed:",$resultArray['sum_awarded_contracts']);
$poor_contract_data_quality[] = array("Number of awarded contracts with valid links to USASpending.gov data:",$resultArray['sum_usaspendingmatch_awarded_contracts']);
$poor_contract_data_quality[] = array("Percent of awarded contracts with valid links to USASpending.gov data:",
									data_quality_detail_report_apply_asterisk(number_format($resultArray['percent_usaspendingmatch_awarded_contracts'],2)."%",FALSE,"contracts_match_perc"));

$milestones_fraction_costs[] = array("Do the total costs in the milestones table add up to less than 75% of the total lifecycle cost in the investment's yearly summary of funding table?:",
									data_quality_detail_report_apply_asterisk($resultArray['totalms_plannedcost_less75perc_lifecyclecost'],TRUE));
$milestones_fraction_costs[] = array("Do the costs in the milestones table add up to more than 200% of the total lifecycle cost in the investment's yearly summary of funding table?:",
									data_quality_detail_report_apply_asterisk($resultArray['totalms_plannedcost_more200perc_lifecyclecost'],TRUE));
$milestones_fraction_costs[] = array("Sum of the costs in the milestones table (\$M):","\$".number_format($resultArray['milestones_totalplannedcost'],2));
$milestones_fraction_costs[] = array("Sum of the total lifecycle costs in the summary of funding table (\$M):","\$".number_format($resultArray['lifecycle_totalcost'],2));
$milestones_fraction_costs[] = array("Milestone costs as a percentage of lifecycle costs:",number_format($resultArray['mscost_perc_lifecycle_totalcost'],2)."%");

$majority_milestones_perfect = array();
$majority_milestones_perfect[] = array("Number of milestones listed:",$resultArray['sum_milestones']);
$majority_milestones_perfect[] = array("Number of completed milestones:",$resultArray['sum_completed_milestones']);
$majority_milestones_perfect[] = array("Number of completed milestones where actual number of dollars spent precisely equaled the planned number of dollars:",$resultArray['sum_completed_perfectcost_milestones']);
$majority_milestones_perfect[] = array("Number of milestones which completed on exactly the day planned for completion:",$resultArray['sum_completed_perfectschedule_milestones']);
$majority_milestones_perfect[] = array("Number of completed milestones with perfect cost variance AND perfect schedule variance:",
									data_quality_detail_report_apply_asterisk($resultArray['sum_perfect_completed_milestones'],FALSE,"perfect_completed",
										array('perfect_completed_ms' => $resultArray['sum_perfect_completed_milestones'],'completed_ms' => $resultArray['sum_completed_milestones'])));

$frequent_rebaselines = array();
$frequent_rebaselines[] = array("Number of days with a baseline event, such as changing the investment's milestone's planned costs:",
								data_quality_detail_report_apply_asterisk($resultArray['sum_frequent_baselines'],FALSE));

$cio_eval_without_details = array();
$cio_eval_without_details[] = array("Is the CIO comment information up-to-date?:<br/>(If the CIO comment has not changed since the last change to the Evaluation by Agency CIO, or if no comment has been provided, then this is not up-to-date)",
									data_quality_detail_report_apply_asterisk($resultArray['cio_comment_dataquality_reason'],FALSE,"cio_comments"));

print "<div id='dataQualityDetailReport' class='clearfix'>";
print theme('table',array(),$incomplete_inaccurate_data,array(),"Incomplete/Inaccurate Data");
print theme('table',array(),$long_large_milestones,array(),"Long/Large Milestones");
print theme('table',array(),$poor_contract_data_quality,array(),"Poor Contract Data Quality");
print theme('table',array(),$milestones_fraction_costs,array(),"Milestones Account for Fraction of Costs");
print theme('table',array(),$majority_milestones_perfect,array(),"Majority of Milestones Perfect");
print theme('table',array(),$frequent_rebaselines,array(),"Frequent Rebaselines");
print theme('table',array(),$cio_eval_without_details,array(),"CIO Evaluations Without Details");
print "</div>";


print "<p><span id=\"dataQualityDetailReportAsterisk\"><b>*</b></span>Indicates the metric which caused the data quality issue.</p>";

function data_quality_detail_report_apply_asterisk($str,$yes_no,$special_cases = NULL,$additional_value_array = NULL)
{
	if($str == 0 AND $yes_no){
		$display_str = "No";
	}elseif($yes_no){
		$display_str = "Yes";
	}else{
		$display_str = $str;
	}
	
	if($special_cases == "contracts_match_perc"){
		if($str == 100){
			return $display_str;
		}else{
			return $display_str."<span id=\"dataQualityDetailReportAsterisk\">*</span>";
		}
	}
	
	if($special_cases == "cio_comments"){
		if($str == "no_issue"){
			return "Yes";
		}else{
			return "No<span id=\"dataQualityDetailReportAsterisk\">*</span>";
		}
	}
	
	if($special_cases == "perfect_completed"){
		$sum_perfect_completed = (integer)$additional_value_array['perfect_completed_ms'];
		$sum_completed = (integer)$additional_value_array['completed_ms'];
		
		if($sum_completed == 0 OR $sum_perfect_completed/$sum_completed < 0.5){
			return $display_str;
		}else{
			return $display_str."<span id=\"dataQualityDetailReportAsterisk\">*</span>";
		}
	}

	if($str == 0){
		return $display_str;
	}else{
		return $display_str."<span id=\"dataQualityDetailReportAsterisk\">*</span>";
	}
}