<?php

/*
   Copyright 2009-2011 United States Government. 

   This software is licensed under the GNU General Public License
   version 2 (see the file LICENSE for details)
*/

/*
Purpose : used to render treemap
URL : http://it.usaspending.gov/content/current-year-fy2011-continuing-resolution
Parameter: NA
*/
header("Content-type: text/xml");


include_once("common.inc");

$PREQUEST = purify_n_prepare();

	$agency=getUserAgency();

if(isset($PREQUEST['id1']))
	$id1=$PREQUEST['id1'];
if(isset($PREQUEST['id2']))
	$id2=$PREQUEST['id2'];
if(isset($PREQUEST['id3']))
	$id3=$PREQUEST['id3'];

if(isset($PREQUEST['path1']))
	$path1=$PREQUEST['path1'];
if(isset($PREQUEST['path2']))
	$path2=$PREQUEST['path2'];
if(isset($PREQUEST['path3']))
	$path3=$PREQUEST['path3'];


if(isset($PREQUEST['path3']))
	$path3=$PREQUEST['path3'];

if($path1=='agency' || $path1=='bureau' || $path1=='servicegroup')
	$name1=$path1.'Name';
if($path2=='agency' || $path2=='bureau' || $path2=='servicegroup')
	$name2=$path2.'Name';
if($path3=='agency' || $path3=='bureau' || $path3=='servicegroup')
	$name3=$path3.'Name';

if($path1=='ModeofDeliveryLOB')
	$name1='lobName';
if($path2=='ModeofDeliveryLOB')
	$name2='lobName';
if($path3=='ModeofDeliveryLOB')
	$name3='lobName';

if($path1=='ModeofDeliverySub_Function')
	$name1='subFunctionName';
if($path2=='ModeofDeliverySub_Function')
	$name2='subFunctionName';
if($path3=='ModeofDeliverySub_Function')
	$name3='subFunctionName';

$cnt=0;

if((!isset($id1)) && (!isset($id2)) && (!isset($id3)))
{
		$param_array=array();
		$param_array1=array();
		$sql1='SELECT P.Nombre AS title, D.Nombre AS agencyName, (B.Actual) AS totCY, P.Descripcion AS description, NULL AS DMECY, NULL AS SSCY, P.IdPrograma AS businessCaseID, P.Codigo AS uniqueProjectIdentifier, P.IdDepartamento AS agency, P.IdEntidad AS bureau, P.IdTipo AS ModeofDeliveryLOB, P.IdFuncion AS ModeofDeliverySub_Function, 0 AS servicegroup FROM programas P INNER JOIN presupuestos B ON P.IdPrograma = B.IdPrograma AND B.Periodo = '.date('Y').' INNER JOIN departamentos D ON P.IdDepartamento = D.IdDepartamento';
		$sql='SELECT count( * ) AS cnt FROM programas P INNER JOIN presupuestos B ON P.IdPrograma = B.IdPrograma AND B.Periodo = '.date('Y');

}

ConnectionUtil::setActiveConnection(DB_ALIAS_STAGING);
$res=db_query($sql,$param_array);
ConnectionUtil::releaseActiveConnection();

$xx=0;
$row=mysql_fetch_array($res);
$rowsToDisplay=$row['cnt'];

global $conf;
global $language;

	$fiscalyearLocalCRText = ($conf['ITDashboard']['fiscalYearCRText'] ? "(".$conf['ITDashboard']['fiscalYearCRText'].") " : "");


if( $rowsToDisplay > 0) {

	ConnectionUtil::setActiveConnection(DB_ALIAS_STAGING);
	$res1=db_query($sql1,$param_array1);
	ConnectionUtil::releaseActiveConnection();

	if ($language->language == "eu") {
		$xml.='<doc><headers><header>Saila</header><header>Izena</header><header></header><header>Gastua Urtea '.date('Y').'</header></headers><count>'.$rowsToDisplay.'</count>';
	} else {
		$xml.='<doc><headers><header>Departamento43</header><header>Nombre</header><header></header><header>Gasto Año '.date('Y').'</header></headers><count>'.$rowsToDisplay.'</count>';
	}
	

	while ($row1=mysql_fetch_array($res1))
	{

		$xml.='<itInvestment>';
		$xml.='<agency>'.utf8_decode($row1['agencyName']).'</agency>';
		$xml.='<businessCaseID>'.$row1['businessCaseID'].'</businessCaseID>';
		$xml.='<title>'.utf8_decode($row1['title']).'</title>';
		if($row1['businessCaseID']!='')
			$xml.='<investmentType>Mayor</investmentType>';
		else
			$xml.='<investmentType>Menor</investmentType>';
		$xml.='<totCY>'.(number_format($row1['totCY'],0,',','.').' €').'</totCY>';
		if($path1!='' || $path2!='' || $path3!='' || $id1!='' || $id2!='' || $id3!='')
		{
			if($path1!='' && $id1!='')
			{
				$xml.='<path1>'.$path1.'</path1>';
				$xml.='<id1>'.$id1.'</id1>';
			}
			if($path2!='' && $id2!='')
			{
				$xml.='<path2>'.$path2.'</path2>';
				$xml.='<id2>'.$id2.'</id2>';
			}
			if($path3!='' && $id3!='')
			{
				$xml.='<path3>'.$path3.'</path3>';
				$xml.='<id3>'.$id3.'</id3>';
			}
		}
		else
		{
			$xml.='<path1>agency</path1>';
			$xml.='<id1>'.$row1['agency'].'</id1>';

			$xml.='<path2>bureau</path2>';
			$xml.='<id2>'.$row1['bureau'].'</id2>';

			$xml.='<path3>servicegroup</path3>';
			$xml.='<id3>'.$row1['servicegroup'].'</id3>';

			$xml.='<path4>ModeofDeliveryLOB</path4>';
			$xml.='<id4>'.$row1['ModeofDeliveryLOB'].'</id4>';

			$xml.='<path5>ModeofDeliverySub_Function</path5>';
			$xml.='<id5>'.$row1['ModeofDeliverySub_Function'].'</id5>';
		}
		$xml.='</itInvestment>';
	}
	$xml.='</doc>';
}

else {

	if ($language->language == "eu") {
		$xml.='<doc><headers><header>Saila</header><header>Izena</header><header></header><header>Gastua Urtea '. date('Y') .'</header></headers></doc>';
	} else {
		$xml.='<doc><headers><header>Departamento43</header><header>Nombre</header><header></header><header>Gasto Año '. date('Y') .'</header></headers></doc>';
	}
	

}

echo $xml;


function clean_allx($str)
{
	$translation_table = get_html_translation_table(HTML_ENTITIES);
	$str = clean_str($str);
	$str = replaceNewLinex($str);
	$str = replaceXMLSensitiveChars($str);
	$str = utf8_decode($str);
	$str = strtr($str,$translation_table);
	$str = htmlspecialchars($str, ENT_QUOTES);
	$str = htmlentities($str);
	$str = str_replace("&nbsp;"," ",$str);
	$str = str_replace("& nbsp;"," ", $str);

	return $str;
}


function replaceNewLinex($str)
{
	$str=str_replace(","," ",$str);
	$str=str_replace("\n"," ",$str);
	$str=str_replace("\r\n"," ",$str);
	$str=str_replace("\n\n"," ",$str);
	$str=str_replace("\\n"," ",$str);
	$str=str_replace("\\r\n"," ",$str);
	$str=str_replace("\\n\n"," ",$str);
	$str=str_replace("\r"," ",$str);

	return $str;
}

?>