<?php
/*
   Copyright 2009-2011 United States Government. 

   This software is licensed under the GNU General Public License
   version 2 (see the file LICENSE for details)
*/

/*
 Purpose: Generates CSV for treemap data
 URL : http://it.usaspending.gov/content/current-year-fy2011-likely-enacted
 Parameters : NA
 */
	include_once("common.inc");
	$PREQUEST = purify_n_prepare();

	if($PREQUEST['type']=='csv')
	{
		header("Content-Type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=Data_Feed.csv");
		header("Pragma: cache");
		header("Expires: -1");
	}

	$agency=getUserAgency();

	include_once('customcode/dbUtility.php');

	if($agency=='100')
	{
		$param_array=array();
		$sql="SELECT a.title, a.agencyName, a.totalInvestmentsCY AS totCY, a.description, a.DMECY AS DMECY, a.SteadyStateCY AS SSCY, b.businessCaseID,a.uniqueProjectIdentifier, a.agency, a.bureau, a.ModeofDeliveryLOB, a.ModeofDeliverySub_Function, a.servicegroup  FROM majorAgencyAllInvestmentsMV a LEFT OUTER JOIN businessCasesMV b ON a.uniqueProjectIdentifier = b.uniqueProjectIdentifier where totalInvestmentsCY!=0 or totalInvestmentsBY!=0 OR totalInvestmentsBY IS NULL";
	}
	else
	{
		$param_array=array();
		$sql="SELECT a.title, a.agencyName, a.totalInvestmentsCY AS totCY, a.description, a.DMECY AS DMECY, a.SteadyStateCY AS SSCY, b.businessCaseID,a.uniqueProjectIdentifier, a.agency, a.bureau, a.ModeofDeliveryLOB, a.ModeofDeliverySub_Function, a.servicegroup  FROM majorAgencyAllInvestmentsMV a LEFT OUTER JOIN businessCasesMV b ON a.uniqueProjectIdentifier = b.uniqueProjectIdentifier where totalInvestmentsCY!=0 or totalInvestmentsBY!=0 OR totalInvestmentsBY IS NULL";
	}

	$disp='';

	if($PREQUEST['type']=='csv')
		$disp=getCSVData($sql,$param_array);
	else if($PREQUEST['type']=='html')
		$disp=getTableData($sql,$param_array);

	echo $disp;

?>

<?php

function getTableData($sql,$param_array)
{

	global $conf;
	$fiscalyearLocalCRText = ($conf['ITDashboard']['fiscalYearCRText'] ? "<br />(".$conf['ITDashboard']['fiscalYearCRText'].")<br />" : "");

?>
<link type="text/css" rel="stylesheet" media="all" href="/sites/all/themes/itdash_new/style.css" />
<div class="clearfix" id="homePageContainer">
<div id="dbcontentContainer" class="export_Pages">
<h1><a href="/"><img border="0" src="/sites/all/themes/itdash_new/images/site_title.gif" alt="IT DashBoard"></a></h1>
<?

	$ret.='<table class="datatable_table">';

	$ret.='<thead><tr><th style="width:250px;">Agency</th><th style="width:410px;">Title</th><th style="width:150px;">Major Investment</th><th style="width:150px;">FY2011 '. $fiscalyearLocalCRText .'Spending</th></tr></thead>';
	ConnectionUtil::setActiveConnection(DB_ALIAS_STAGING);
	$res=db_query($sql,$param_array);
	ConnectionUtil::releaseActiveConnection();
	$csv.='"Agency","Title","Major Investment","FY2011 Spending"';

	while($row=mysql_fetch_array($res))
	{
		$ret.='<tr>';
		$ret.='<td>'.$row['agencyName'].'</td>';
		$ret.='<td>'.clean_str($row['title']).'</td>';
		if($row['businessCaseID']!='')
			$ret.='<td>Yes</td>';
		else
			$ret.='<td>No</td>';
		$ret.='<td>'.$row['totCY'].'</td>';
		$ret.='</tr>';
	}

	$ret.='</table></div></div>';
	return $ret;

}

function getCSVData($sql,$param_array)
{
	global $conf;
	$fiscalyearLocalCRText = ($conf['ITDashboard']['fiscalYearCRText'] ? "(".$conf['ITDashboard']['fiscalYearCRText'].") " : "");

	ConnectionUtil::setActiveConnection(DB_ALIAS_STAGING);
	$res=db_query($sql,$param_array);
	ConnectionUtil::releaseActiveConnection();
	$csv.='"Agency","Title","Unique Project Identifier","Major Investment","FY2011 '. $fiscalyearLocalCRText .'Spending"';

	while($row=mysql_fetch_array($res))
	{
		$csv.="\n";
		$csv.='"'.$row['agencyName'].'",';
		$csv.='"'.str_replace('"',"'",$row['title']).'",';
  		$csv.='"'.$row['uniqueProjectIdentifier'].'",';
		if($row['businessCaseID']!='')
			$csv.='"Yes",';
		else
			$csv.='"No",';
		$csv.='"'.$row['totCY'].'"';
	}

	return $csv;
}
?>

