<?php
    drupal_add_css("formularios/dhtmlx/dhtmlx.css");	  
    drupal_add_css("modulos/css/template.css");	  
    drupal_add_js("formularios/dhtmlx/dhtmlx.js");
    drupal_add_js("formularios/dhtmlx/dhtmlxgrid_pgn.js");
    drupal_add_js("formularios/dhtmlx/format-number.js");
	
	global $base_url;
	$urlxmls = $base_url."/modulos/data/";
	$base_img = $base_url."/";

?>

<div id="form-mp"></div>
<div id="paginacion"></div>
<div id="grid"></div>
<div id="ayuda-enlace" href="#">Laguntza</div>
<div id="ayuda">
	<h4>Nire Programak-en gaineko gehiago</h4>
	<p>Nire Programak Orrialdeak programak eguneratzea baimentzen dio. Gainera informazioa eguneratuta manten daiteke aurrerabidearen gainean.</p>
	<p>Iragazte-erremintak erabil ditzake programak bere betetzera ados bilatzeko </p>
</div>

<script type="text/javascript">

	$("#ayuda-enlace").click(function () {
		if($("#ayuda").is(":hidden")) {
			$("#ayuda").slideDown("slow");
		} 
		else {
			$("#ayuda").hide();
		}
	});

	var struc = [
		{type:"combo", name:"departamento", label:"Saila:", inputWidth:240, labelWidth:135},
		{type:"combo", name:"entidad", label:"Erakundea:", inputWidth:240, labelWidth:135},
		{type:"input", name:"nombre", label:"Izena programa:", inputWidth:240, labelWidth:135},
		{type:"block", className:"chevaluaciones", list:[
			{type:"label", label:"Ebaluaketa orokorra"},
			{type:"fieldset", name:"fdgeneral", width:180, list:[
				{type:"checkbox", name:"egR", className:"evR"},
				{type:"newcolumn"},
				{type:"checkbox", name:"egA", className:"evA"},
				{type:"newcolumn"},
				{type:"checkbox", name:"egV", className:"evV"}
			]},
			{type:"newcolumn", offset:30},
			{type:"label", label:"Kostua"},
			{type:"fieldset", name:"fdcosto", width:180, list:[
				{type:"checkbox", name:"ecR", className:"evR"},
				{type:"newcolumn"},
				{type:"checkbox", name:"ecA", className:"evA"},
				{type:"newcolumn"},
				{type:"checkbox", name:"ecV", className:"evV"}
			]},
			{type:"newcolumn", offset:30},
			{type:"label", label:"Plana"},
			{type:"fieldset", name:"fdplan", width:180, list:[
				{type:"checkbox", name:"epR", className:"evR"},
				{type:"newcolumn"},
				{type:"checkbox", name:"epA", className:"evA"},
				{type:"newcolumn"},
				{type:"checkbox", name:"epV", className:"evV"}
			]},
			{type:"newcolumn", offset:30},
			{type:"label", label:"Arduradunaren ebaluazioa"},
			{type:"fieldset", name:"fdresponsable", width:180, list:[
				{type:"checkbox", name:"erR", className:"evR"},
				{type:"newcolumn"},
				{type:"checkbox", name:"erA", className:"evA"},
				{type:"newcolumn"},
				{type:"checkbox", name:"erV", className:"evV"}
			]}
		]},
		{type:"block", list:[
			{type:"label", label:'<span class="mensaje-ir">Aukeratutako kategoriei dagozkien inbertsioak erakusten ditu</span>'},
			{type:"newcolumn"},
			{type:"button", name:"ir", value:"Joan"}
		]}
	];
	form = new dhtmlXForm("form-mp",struc);
	with(form)
   	{
		attachEvent("onButtonClick", function(id){
    	    switch(id)
    	    {
				case "ir":
					var data = form.getFormData();
					grid.clearAndLoad("<?=$urlxmls?>misprogramas.php?depto="+data['departamento']+"&ente="+data['entidad']+"&nombre="+data['nombre']+"&egR="+data['egR']+"&egA="+data['egA']+"&egV="+data['egV']+"&ecR="+data['ecR']+"&ecA="+data['ecA']+"&ecV="+data['ecV']+"&epR="+data['epR']+"&epA="+data['epA']+"&epV="+data['epV']+"&erR="+data['erR']+"&erA="+data['erA']+"&erV="+data['erV']);
					break;
		    }
        });

		var inicio = true;
		var optDepartamentos = getCombo("departamento");
		with(optDepartamentos)
		{
			loadXML("/formularios/data/opciones.php?op=agencia&oculta=true", function(){
				selectOption(0);
			});
			
			attachEvent("onChange", function(){
				var v_a = getSelectedValue();
				if(v_a)
					optEntidades.loadXML("/formularios/data/opciones.php?op=entidad&oculta=true&agencia="+v_a, function(){
						optEntidades.selectOption(0);
						if(inicio)
						{
							inicio = false;
							var data = form.getFormData();
							grid.clearAndLoad("<?=$urlxmls?>misprogramas.php?depto="+data['departamento']+"&ente="+data['entidad']);
						}
					});
			});
		}
	
		var optEntidades = form.getCombo("entidad");
	}
	
	grid = new dhtmlXGridObject("grid");
	with(grid)
	{
		setImagePath("../formularios/dhtmlx/imgs/");
		setHeader("Izenburua,Arduraduna,Evaluazio Arduraduna,Azken eguneraketa");
		setInitWidths("*,300,150,150");
		setColAlign("left,left,center,center");
		setColTypes("ro,ro,img,ro");
		setColSorting("str,str,int,date");
		enableAutoHeight(true);
		enableMultiline(true);
		init();
	}

</script>