<?php
    drupal_add_css("formularios/dhtmlx/dhtmlx.css");	  
    drupal_add_css("modulos/css/template.css");	  
    drupal_add_js("formularios/dhtmlx/dhtmlx.js");
    drupal_add_js("formularios/dhtmlx/dhtmlxgrid_pgn.js");
    drupal_add_js("formularios/dhtmlx/format-number.js");
	
	
	//$urlxmls = "http://drupal6.betapruebas.com/modulos/data/";
	global $base_url;
	$urlxmls = $base_url."/modulos/data/";
?>

<div id="form-mp"></div>
<div id="paginacion"></div>
<div id="grid"></div>
<div id="ayuda-enlace" href="#">Ayuda</div>
<div id="ayuda">
	<h4>Más sobre Mis Programas</h4>
	<p>La Página Mis Programas le permite actualizar los programas. Además se puede mantener actualizada la información sobre el progreso.</p>
	<p>Puede utilizar las herramientas de filtrado para buscar los programas de acuerdo a su desempeño	</p>
</div>

<script type="text/javascript">

	$("#ayuda-enlace").click(function () {
		if($("#ayuda").is(":hidden")) {
			$("#ayuda").slideDown("slow");
		} 
		else {
			$("#ayuda").hide();
		}
	});

	var struc = [
		{type:"combo", name:"departamento", label:"Departamento:", inputWidth:240, labelWidth:135},
		{type:"combo", name:"entidad", label:"Entidad:", inputWidth:240, labelWidth:135},
		{type:"input", name:"nombre", label:"Nombre del Programa:", inputWidth:240, labelWidth:135},
		{type:"block", className:"chevaluaciones", list:[
			{type:"label", label:"Evaluaci&oacute;n General"},
			{type:"fieldset", name:"fdgeneral", width:170, list:[
				{type:"checkbox", name:"egR", className:"evR"},
				{type:"newcolumn"},
				{type:"checkbox", name:"egA", className:"evA"},
				{type:"newcolumn"},
				{type:"checkbox", name:"egV", className:"evV"}
			]},
			{type:"newcolumn", offset:25},
			{type:"label", label:"Evaluaci&oacute;n de Costo"},
			{type:"fieldset", name:"fdcosto", width:170, list:[
				{type:"checkbox", name:"ecR", className:"evR"},
				{type:"newcolumn"},
				{type:"checkbox", name:"ecA", className:"evA"},
				{type:"newcolumn"},
				{type:"checkbox", name:"ecV", className:"evV"}
			]},
			{type:"newcolumn", offset:25},
			{type:"label", label:"Evaluaci&oacute;n  de Plan"},
			{type:"fieldset", name:"fdplan", width:170, list:[
				{type:"checkbox", name:"epR", className:"evR"},
				{type:"newcolumn"},
				{type:"checkbox", name:"epA", className:"evA"},
				{type:"newcolumn"},
				{type:"checkbox", name:"epV", className:"evV"}
			]},
			{type:"newcolumn", offset:25},
			{type:"label", label:"Evaluaci&oacute;n  por Responsable"},
			{type:"fieldset", name:"fdresponsable", width:170, list:[
				{type:"checkbox", name:"erR", className:"evR"},
				{type:"newcolumn"},
				{type:"checkbox", name:"erA", className:"evA"},
				{type:"newcolumn"},
				{type:"checkbox", name:"erV", className:"evV"}
			]}
		]},
		{type:"block", list:[
			{type:"label", label:'<span class="mensaje-ir">Muestra inversiones de las categorias seleccionadas</span>'},
			{type:"newcolumn"},
			{type:"button", name:"ir", value:"Ir"}
		]}
	];
	var form = new dhtmlXForm("form-mp",struc);
	with(form)
   	{
		attachEvent("onButtonClick", function(id){
    	    switch(id)
    	    {
				case "ir":
					var data = form.getFormData();
					grid.clearAndLoad("<?=$urlxmls?>misprogramas.php?depto="+data['departamento']+"&ente="+data['entidad']+"&nombre="+data['nombre']+"&egR="+data['egR']+"&egA="+data['egA']+"&egV="+data['egV']+"&ecR="+data['ecR']+"&ecA="+data['ecA']+"&ecV="+data['ecV']+"&epR="+data['epR']+"&epA="+data['epA']+"&epV="+data['epV']+"&erR="+data['erR']+"&erA="+data['erA']+"&erV="+data['erV']);
					break;
		    }
        });

		var inicio = true;
		var optDepartamentos = getCombo("departamento");
		with(optDepartamentos)
		{
			loadXML("formularios/data/opciones.php?op=agencia&oculta=true", function(){
				selectOption(0);
			});
			
			attachEvent("onChange", function(){
				var v_a = getSelectedValue();
				if(v_a)
					optEntidades.loadXML("formularios/data/opciones.php?op=entidad&oculta=true&agencia="+v_a, function(){
						optEntidades.selectOption(0);
						if(inicio)
						{
							inicio = false;
							var data = form.getFormData();
							grid.clearAndLoad("<?=$urlxmls?>misprogramas.php?depto="+data['departamento']+"&ente="+data['entidad']);
						}
					});
			});
		}
	
		var optEntidades = form.getCombo("entidad");
	}
	
	var grid = new dhtmlXGridObject("grid");
	with(grid)
	{
		setImagePath("../formularios/dhtmlx/imgs/");
		setHeader("Titulo,Responsable,Evaluaci&oacute;n por Responsable,&Uacute;ltima Actualizaci&oacute;n");
		setInitWidths("*,300,150,150");
		setColAlign("left,left,center,center");
		setColTypes("ro,ro,img,ro");
		setColSorting("str,str,int,date");
		enableAutoHeight(true);
		enableMultiline(true);
		init();
	}

</script>