
///////////////////////////////////
//      FUNCIONES DEL FORM       //
///////////////////////////////////

//Form.OnButtonClick - Case Cancelar
function clickCancelar()
{
	with(form)
	{
		clickLimpiar();
		showItem("frbuscar");
		hideItem("frinversion");
		hideItem("contratos");
		hideItem("proyectos");
	}
}

//Form.OnButtonClick - Case ProyectoIni
function clickContratoIni()
{
	with(gdContratos)
	{
		rowId = getSelectedRowId();
		if(rowId > 0)
		{
			if(!contratoIniciado(rowId))
			{
				if(confirm("Esta seguro que desea Iniciar el contrato?"))
				{
					var xml = dhtmlxAjax.getSync(urlxmls + "formularios/data/contratos.php?&op=ini&id=" + rowId);
					codb = form.getCombo("codigob").getSelectedValue();
					gdContratos = new dhtmlXGridObject(form.getContainer('contratosgrid'));
					cargaGridContratos();
					gdContratos.clearAndLoad(urlxmls + "formularios/data/contratos.php?op=load&id=" + codb);
				}
			}
			else
				dhtmlx.alert("El contrato ya fue Iniciado");
		}
		else
			dhtmlx.alert("Seleccione el contrato que desea Iniciar");
	}
}

//Form.OnButtonClick - Case ProyectoFin
function clickContratoFin()
{
	with(gdContratos)
	{
		rowId = getSelectedRowId();
		if(rowId > 0)
		{
			if(contratoIniciado(rowId))
			{
				if(!contratoFinalizado(rowId))
				{
					if(confirm("Esta seguro que desea Finalizar el contrato?"))
					{
						var xml = dhtmlxAjax.getSync(urlxmls + "formularios/data/contratos.php?&op=fin&id=" + rowId);
						codb = form.getCombo("codigob").getSelectedValue();
						gdContratos = new dhtmlXGridObject(form.getContainer('contratosgrid'));
						cargaGridContratos();
						gdContratos.clearAndLoad(urlxmls + "formularios/data/contratos.php?op=load&id=" + codb);
					}
				}
				else
					dhtmlx.alert("El contrato ya fue Finalizado");
			}
			else
				dhtmlx.alert("El contrato aun no ha sido Iniciado");
		}
		else
			dhtmlx.alert("Seleccione el contrato que desea Finalizar");
	}
}

//Form.OnButtonClick - Case Limpiar
function clickLimpiar()
{
	form.clear();
	gdContratos.clearAll();
	gdProyectos.clearAll();
}

//Form.OnButtonClick - Case ProyectoIni
function clickProyectoIni()
{
	with(gdProyectos)
	{
		rowId = getSelectedRowId();
		if(rowId > 0)
		{
			if(!proyectoIniciado(rowId))
			{
				if(confirm("Esta seguro que desea Iniciar el proyecto?"))
				{
					var xml = dhtmlxAjax.getSync(urlxmls + "formularios/data/proyectos.php?&op=ini&id=" + rowId);
					codb = form.getCombo("codigob").getSelectedValue();
					gdProyectos = new dhtmlXGridObject(form.getContainer('proyectosgrid'));
					cargaGridProyectos();
					gdProyectos.clearAndLoad(urlxmls + "formularios/data/proyectos.php?op=load&id=" + codb);
				}
			}
			else
				dhtmlx.alert("El proyecto ya fue Iniciado");
		}
		else
			dhtmlx.alert("Seleccione el proyecto que desea Iniciar");
	}
}

//Form.OnButtonClick - Case ProyectoBase
function clickProyectoBase()
{
	with(gdProyectos)
	{
		rowId = getSelectedRowId();
		if(rowId > 0)
		{
			if(proyectoIniciado(rowId))
			{
				ventanaProyecto("base");
			}
			else
				dhtmlx.alert("El proyecto aun no ha sido Iniciado");
		}
		else
			dhtmlx.alert("Seleccione el proyecto para ingresar el progreso");
	}
}

//Form.OnButtonClick - Case ProyectoGuardar
function clickProyectoSave()
{
	with(formProyecto)
	{

		setItemValue("op", "update");
		var xml1 = serializar(gdBaseline);
		setItemValue("baseline", xml1);

		send(urlxmls + "formularios/data/proyectos.php","post",function(xml){
			win.close();
			dhtmlx.alert(xml.xmlDoc.responseText);

			codb = form.getCombo("codigob").getSelectedValue();
			gdProyectos = new dhtmlXGridObject(form.getContainer('proyectosgrid'));
			cargaGridProyectos();
			gdProyectos.clearAndLoad(urlxmls + "formularios/data/proyectos.php?op=load&id=" + codb);
		});
	}
}

//Form.OnButtonClick - Case Reportar
function clickReportar()
{
	with(form)
	{
		codb = getCombo("codigob").getSelectedValue();
		if(codb>0)
		{
			showItem("frinversion");
			showItem("frcontratos");
			showItem("frproyectos");
			hideItem("frbuscar");
			
			load(urlxmls + "formularios/data/inversiones.php?op=loadnames&id=" + codb, function(){
				gdContratos.clearAndLoad(urlxmls + "formularios/data/contratos.php?op=load&id=" + codb);
				gdProyectos.clearAndLoad(urlxmls + "formularios/data/proyectos.php?op=load&id=" + codb);
				setItemValue("act_tipo",1); 
			});
		}
	}
}

function contratoIniciado(rowId)
{
	if(gdContratos.cells(rowId,4).getValue() != '')
		return true;
	return false;
}

function contratoFinalizado(rowId)
{
	if(gdContratos.cells(rowId,6).getValue() != '')
		return true;
	return false;
}

function proyectoIniciado(rowId)
{
	if(gdProyectos.cells(rowId,4).getValue() != '')
		return true;
	return false;
}

///////////////////////////////////

///////////////////////////////////
//    FUNCIONES DE LOS COMBOS    // 
///////////////////////////////////

function cargaAgenciaB()
{
	optsAgenciaB = form.getCombo("agenciab");
	with(optsAgenciaB)
	{
		loadXML(urlxmls + "formularios/data/opciones.php?op=agencia");
		attachEvent("onChange", function(){
			var v_a = getSelectedValue();
			if(v_a)
			{
		    	optsEnteB.loadXML(urlxmls + "formularios/data/opciones.php?op=entidad&agencia=" + v_a);
		    	form.setItemValue('agencia', v_a);
			}
		});
	}
}

function cargaEnteB()
{
	optsEnteB = form.getCombo("entidadb");
	with(optsEnteB)
	{
		attachEvent("onChange", function(){
			var v_a = optsAgenciaB.getSelectedValue();
			var v_e = getSelectedValue();
			if(v_a && v_e)
			{
				optsCodigoB.loadXML(urlxmls + "formularios/data/opciones.php?op=inversion&agencia=" + v_a + "&entidad=" + v_e);
				form.setItemValue('entidad', v_e);
			}
		});
	}
}

function cargaCodigoB()
{
	optsCodigoB = form.getCombo("codigob");
	with(optsCodigoB)
	{
		enableFilteringMode(true);
	}
}

/////////////////////////////

function ventanaProyecto(op)
{
	win = creaVentana(500,470,"Datos del Proyecto",920);
	formProyecto = formProyectos(win);
	
	with(formProyecto)
	{
		gdBaseline = new dhtmlXGridObject(getContainer("gdbaseline"));
		cargaGridBaseline();
		
		var rowId = gdProyectos.getSelectedRowId();

		setItemValue("act_tipo",2);
		setItemValue("id",rowId);
			
		load(urlxmls + "formularios/data/proyectos.php?op=get&id=" + rowId);
		gdBaseline.clearAndLoad(urlxmls + "formularios/data/proyectos.php?op=base&id=" + rowId);

		attachEvent("onButtonClick", function(id){
	        switch(id)
	        {
				case "proyectoguardar":
					clickProyectoSave();
					break;
					
				default:
					win.close();
					break;
	    	}
	    });
	}
	
}

function creaVentana(wd, ht, txt, pos)
{
	var w = wins.createWindow("win", 0, 0, wd, ht);
	with(w)
	{
		setText(txt);
		button("park").hide();
		button("minmax1").hide();
		center();
		setModal(true);
        setPosition(getPosition()[0], pos);
		divModalCollection = document.getElementsByClassName("dhx_modal_cover_dv");
		divModal = divModalCollection[0];
		divModal.style.height = "1570px";
	}
	return w;
}


